/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.jbcsrc.EnhancedAbstractExprNodeVisitor;
import com.google.template.soy.jbcsrc.ExpressionCompiler;
import com.google.template.soy.jbcsrc.ExpressionDetacher;
import com.google.template.soy.jbcsrc.TemplateAnalysis;
import com.google.template.soy.jbcsrc.TemplateParameterLookup;
import com.google.template.soy.jbcsrc.restricted.Branch;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.soytree.defn.LocalVar;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.Optional;
import javax.annotation.Nullable;
import org.objectweb.asm.Type;

final class ExpressionToSoyValueProviderCompiler {
    private final TemplateAnalysis analysis;
    private final TemplateParameterLookup variables;
    private final ExpressionCompiler exprCompiler;

    static ExpressionToSoyValueProviderCompiler create(TemplateAnalysis analysis, ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        return new ExpressionToSoyValueProviderCompiler(analysis, exprCompiler, variables);
    }

    private ExpressionToSoyValueProviderCompiler(TemplateAnalysis analysis, ExpressionCompiler exprCompiler, TemplateParameterLookup variables) {
        this.analysis = analysis;
        this.exprCompiler = exprCompiler;
        this.variables = variables;
    }

    Expression compile(ExprNode node, ExpressionDetacher detacher) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)detacher);
        return (Expression)((Optional)this.createVisitor(this.exprCompiler, detacher).exec(node)).get();
    }

    Optional<Expression> compileToSoyValueProviderIfUsefulToPreserveStreaming(ExprNode node, ExpressionDetacher detacher) {
        Preconditions.checkNotNull((Object)node);
        Preconditions.checkNotNull((Object)detacher);
        return (Optional)this.createVisitor(null, detacher).exec(node);
    }

    Optional<Expression> compileAvoidingDetaches(ExprNode node) {
        Preconditions.checkNotNull((Object)node);
        return (Optional)this.createVisitor(this.exprCompiler, null).exec(node);
    }

    private CompilerVisitor createVisitor(@Nullable ExpressionCompiler exprCompiler, @Nullable ExpressionDetacher detacher) {
        return new CompilerVisitor(this.analysis, this.variables, exprCompiler, detacher == null ? null : this.exprCompiler.asBasicCompiler(detacher), detacher);
    }

    private static final class CompilerVisitor
    extends EnhancedAbstractExprNodeVisitor<Optional<Expression>> {
        final TemplateAnalysis analysis;
        final TemplateParameterLookup variables;
        @Nullable
        final ExpressionCompiler exprCompiler;
        @Nullable
        final ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler;
        @Nullable
        final ExpressionDetacher detacher;

        CompilerVisitor(TemplateAnalysis analysis, TemplateParameterLookup variables, @Nullable ExpressionCompiler exprCompiler, @Nullable ExpressionCompiler.BasicExpressionCompiler detachingExprCompiler, @Nullable ExpressionDetacher detacher) {
            this.analysis = analysis;
            this.variables = variables;
            Preconditions.checkArgument((exprCompiler != null || detachingExprCompiler != null ? 1 : 0) != 0);
            this.exprCompiler = exprCompiler;
            this.detachingExprCompiler = detachingExprCompiler;
            this.detacher = detacher;
        }

        private boolean allowsBoxing() {
            return this.exprCompiler != null;
        }

        private boolean allowsDetaches() {
            return this.detachingExprCompiler != null;
        }

        @Override
        protected Optional<Expression> visitExprRootNode(ExprRootNode node) {
            return (Optional)this.visit(node.getRoot());
        }

        @Override
        protected Optional<Expression> visitNullNode(NullNode node) {
            return Optional.of(BytecodeUtils.soyNull());
        }

        @Override
        protected Optional<Expression> visitUndefinedNode(UndefinedNode node) {
            return Optional.of(BytecodeUtils.soyUndefined());
        }

        @Override
        protected Optional<Expression> visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            if (this.allowsDetaches()) {
                Optional maybeLeft = (Optional)this.visit(node.getLeftChild());
                Optional maybeRight = (Optional)this.visit(node.getRightChild());
                if (maybeLeft.isPresent() || maybeRight.isPresent()) {
                    Expression left;
                    Expression right = maybeRight.orElseGet(() -> this.compileToSoyValueProviderWithDetaching(node.getRightChild()));
                    if (maybeLeft.isPresent()) {
                        Expression leftSvp = (Expression)maybeLeft.get();
                        left = ExpressionCompiler.requiresDetach(this.analysis, node.getLeftChild()) ? this.detacher.waitForSoyValueProvider(leftSvp) : leftSvp;
                    } else {
                        left = this.compileToSoyValueProviderWithDetaching(node.getLeftChild());
                    }
                    left = MethodRefs.SOY_VALUE_PROVIDER_OR_NULLISH.invoke(left);
                    return Optional.of(BytecodeUtils.firstSoyNonNullish(left, right));
                }
            }
            return this.visitExprNode(node);
        }

        private Expression compileToSoyValueProviderWithDetaching(ExprNode expr) {
            return this.detachingExprCompiler.compile(expr).box();
        }

        @Override
        protected Optional<Expression> visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            if (this.allowsDetaches()) {
                Optional trueBranchOpt = (Optional)this.visit(node.getChild(1));
                Optional falseBranchOpt = (Optional)this.visit(node.getChild(2));
                if (trueBranchOpt.isPresent() || falseBranchOpt.isPresent()) {
                    Branch condition = this.detachingExprCompiler.compile(node.getChild(0)).compileToBranch();
                    Expression trueBranch = trueBranchOpt.orElseGet(() -> this.compileToSoyValueProviderWithDetaching(node.getChild(1)));
                    Expression falseBranch = falseBranchOpt.orElseGet(() -> this.compileToSoyValueProviderWithDetaching(node.getChild(2)));
                    Type resultType = trueBranch.resultType().equals((Object)falseBranch.resultType()) ? trueBranch.resultType() : (BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, trueBranch.resultType()) && BytecodeUtils.isDefinitelyAssignableFrom(BytecodeUtils.SOY_VALUE_TYPE, falseBranch.resultType()) ? BytecodeUtils.SOY_VALUE_TYPE : BytecodeUtils.SOY_VALUE_PROVIDER_TYPE);
                    return Optional.of(condition.ternary(resultType, trueBranch, falseBranch));
                }
                return Optional.empty();
            }
            return this.visitExprNode(node);
        }

        @Override
        Optional<Expression> visitForLoopVar(VarRefNode varRef, LocalVar local) {
            Expression loopVar = this.variables.getLocal(local);
            if (loopVar.resultType().equals((Object)Type.LONG_TYPE)) {
                if (this.allowsBoxing()) {
                    return Optional.of(SoyExpression.forInt(loopVar).box());
                }
                return Optional.empty();
            }
            return Optional.of(loopVar);
        }

        @Override
        Optional<Expression> visitParam(VarRefNode varRef, TemplateParam param) {
            return Optional.of(this.variables.getParam(param));
        }

        @Override
        Optional<Expression> visitLetNodeVar(VarRefNode varRef, LocalVar local) {
            return Optional.of(this.variables.getLocal(local));
        }

        @Override
        protected Optional<Expression> visitDataAccessNode(DataAccessNode node) {
            return this.visitExprNode(node);
        }

        @Override
        protected Optional<Expression> visitExprNode(ExprNode node) {
            if (this.allowsBoxing()) {
                Optional<SoyExpression> compileWithNoDetaches = this.exprCompiler.compileWithNoDetaches(node);
                if (compileWithNoDetaches.isPresent()) {
                    return Optional.of(compileWithNoDetaches.get().box());
                }
                if (this.allowsDetaches()) {
                    return Optional.of(this.compileToSoyValueProviderWithDetaching(node));
                }
            }
            return Optional.empty();
        }
    }
}

