/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.auto.value.AutoValue;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.jbcsrc.AutoValue_CompiledTemplateMetadata;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.TypeInfo;
import com.google.template.soy.jbcsrc.shared.Names;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateMetadata;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.types.TemplateType;
import java.util.Optional;
import java.util.stream.Stream;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.Method;

@AutoValue
abstract class CompiledTemplateMetadata {
    public static final String DEFAULT_IMPL_JBC_CLASS_SUFFIX = "__modifiable_default_impl__";

    CompiledTemplateMetadata() {
    }

    static Method createRenderMethod(String methodName) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.RENDER_RESULT_TYPE, (Type[])new Type[]{BytecodeUtils.PARAM_STORE_TYPE, BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, BytecodeUtils.RENDER_CONTEXT_TYPE}));
    }

    private static Method createPositionalRenderMethod(String methodName, TemplateType templateType) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.RENDER_RESULT_TYPE, (Type[])((Type[])Stream.concat(templateType.getActualParameters().stream().map(i -> BytecodeUtils.SOY_VALUE_PROVIDER_TYPE), Stream.of(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, BytecodeUtils.RENDER_CONTEXT_TYPE)).toArray(Type[]::new))));
    }

    static boolean isPrivateCall(CallBasicNode call) {
        return call.getNearestAncestor(SoyFileNode.class).getTemplates().stream().anyMatch(t -> t.getVisibility() == Visibility.PRIVATE && t.getTemplateName().equals(call.getCalleeName()));
    }

    static boolean isPrivateReference(SoyNode callContext, TemplateLiteralNode call) {
        return callContext.getNearestAncestor(SoyFileNode.class).getTemplates().stream().anyMatch(t -> t.getVisibility() == Visibility.PRIVATE && t.getTemplateName().equals(call.getResolvedName()));
    }

    static Method createTemplateMethod(String methodName) {
        return new Method(methodName, Type.getMethodDescriptor((Type)BytecodeUtils.COMPILED_TEMPLATE_TYPE, (Type[])new Type[0]));
    }

    static CompiledTemplateMetadata create(TemplateNode node) {
        return CompiledTemplateMetadata.create(node.getTemplateName(), TemplateMetadata.buildTemplateType(node));
    }

    static CompiledTemplateMetadata create(CallBasicNode callNode) {
        return CompiledTemplateMetadata.create(callNode.getCalleeName(), callNode.getStaticType());
    }

    private static CompiledTemplateMetadata create(String templateName, TemplateType templateType) {
        String className = Names.javaClassNameFromSoyTemplateName(templateName);
        TypeInfo type = TypeInfo.createClass(className);
        boolean hasPositionalSignature = templateType.getDataAllCallSituations().isEmpty() && !templateType.getActualParameters().isEmpty() && templateType.getTemplateKind() != TemplateType.TemplateKind.DELTEMPLATE && !templateType.isModifiable() && !templateType.isModifying();
        String methodName = Names.renderMethodNameFromSoyTemplateName(templateName);
        return CompiledTemplateMetadata.builder().setRenderMethod(MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createRenderMethod(methodName + (templateType.isModifiable() ? DEFAULT_IMPL_JBC_CLASS_SUFFIX : "")), MethodRef.MethodPureness.NON_PURE).asNonJavaNullable()).setPositionalRenderMethod(Optional.ofNullable(hasPositionalSignature ? MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createPositionalRenderMethod(methodName, templateType), MethodRef.MethodPureness.NON_PURE).asNonJavaNullable() : null)).setModifiableSelectMethod(Optional.ofNullable(templateType.isModifiable() ? MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createRenderMethod(methodName), MethodRef.MethodPureness.NON_PURE).asCheap().asNonJavaNullable() : null)).setTemplateMethod(MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createTemplateMethod(methodName), MethodRef.MethodPureness.PURE).asCheap().asNonJavaNullable()).setDefaultModTemplateMethod(Optional.ofNullable(templateType.isModifiable() ? MethodRef.createStaticMethod(type, CompiledTemplateMetadata.createTemplateMethod(methodName + DEFAULT_IMPL_JBC_CLASS_SUFFIX), MethodRef.MethodPureness.NON_PURE).asCheap().asNonJavaNullable() : null)).setTemplateType(templateType).setTypeInfo(type).build();
    }

    abstract MethodRef renderMethod();

    abstract Optional<MethodRef> positionalRenderMethod();

    abstract Optional<MethodRef> modifiableSelectMethod();

    abstract MethodRef templateMethod();

    abstract Optional<MethodRef> defaultModTemplateMethod();

    boolean hasPositionalSignature() {
        return this.positionalRenderMethod().isPresent();
    }

    abstract TemplateType templateType();

    abstract TypeInfo typeInfo();

    static Builder builder() {
        return new AutoValue_CompiledTemplateMetadata.Builder();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setRenderMethod(MethodRef var1);

        abstract Builder setPositionalRenderMethod(Optional<MethodRef> var1);

        abstract Builder setModifiableSelectMethod(Optional<MethodRef> var1);

        abstract Builder setTemplateMethod(MethodRef var1);

        abstract Builder setDefaultModTemplateMethod(Optional<MethodRef> var1);

        abstract Builder setTemplateType(TemplateType var1);

        abstract Builder setTypeInfo(TypeInfo var1);

        abstract CompiledTemplateMetadata build();
    }
}

