/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.CodeBuilder;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.MethodRefs;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.Statement;
import java.util.List;
import org.objectweb.asm.Label;
import org.objectweb.asm.Type;

final class AppendableExpression
extends Expression {
    private static final MethodRef APPEND = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "append", CharSequence.class);
    private static final MethodRef APPEND_CHAR = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "append", Character.TYPE);
    private static final MethodRef SOFT_LIMITED = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "softLimitReached", new Class[0]).asCheap();
    static final MethodRef ENTER_LOGGABLE_STATEMENT = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "enterLoggableElement", LogStatement.class);
    private static final MethodRef EXIT_LOGGABLE_STATEMENT = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "exitLoggableElement", new Class[0]);
    private static final MethodRef APPEND_LOGGING_FUNCTION_INVOCATION = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "appendLoggingFunctionInvocation", LoggingFunctionInvocation.class, ImmutableList.class);
    private static final MethodRef LOGGING_FUNCTION_INVOCATION_CREATE = MethodRef.createNonPure(LoggingFunctionInvocation.class, "create", String.class, String.class, List.class);
    private static final MethodRef SET_SANITIZED_CONTENT_KIND_AND_DIRECTIONALITY = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "setKindAndDirectionality", SanitizedContent.ContentKind.class).asCheap();
    private static final MethodRef FLUSH_BUFFERS = MethodRef.createNonPure(LoggingAdvisingAppendable.class, "flushBuffers", Integer.TYPE);
    private final Expression delegate;
    private final boolean hasSideEffects;
    private final boolean supportsSoftLimiting;

    static AppendableExpression forExpression(Expression delegate) {
        return new AppendableExpression(delegate, false, true);
    }

    static AppendableExpression forStringBuilder(Expression delegate) {
        Preconditions.checkArgument((boolean)delegate.resultType().equals((Object)BytecodeUtils.LOGGING_ADVISING_BUILDER_TYPE));
        return new AppendableExpression(BytecodeUtils.LOGGING_ADVISING_BUILDER_TYPE, delegate, false, false);
    }

    static AppendableExpression logger() {
        return new AppendableExpression(MethodRefs.RUNTIME_LOGGER.invoke(new Expression[0]), false, false);
    }

    private AppendableExpression(Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        this(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE, delegate, hasSideEffects, supportsSoftLimiting);
    }

    private AppendableExpression(Type resultType, Expression delegate, boolean hasSideEffects, boolean supportsSoftLimiting) {
        super(resultType, delegate.features());
        delegate.checkAssignableTo(BytecodeUtils.LOGGING_ADVISING_APPENDABLE_TYPE);
        Preconditions.checkArgument((boolean)delegate.isNonJavaNullable(), (String)"advising appendable expressions should always be non nullable: %s", (Object)delegate);
        this.delegate = delegate;
        this.hasSideEffects = hasSideEffects;
        this.supportsSoftLimiting = supportsSoftLimiting;
    }

    @Override
    protected void doGen(CodeBuilder adapter) {
        this.delegate.gen(adapter);
    }

    AppendableExpression appendString(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND, exp), true);
    }

    AppendableExpression appendChar(Expression exp) {
        return this.withNewDelegate(this.delegate.invoke(APPEND_CHAR, exp), true);
    }

    Expression softLimitReached() {
        Preconditions.checkArgument((boolean)this.supportsSoftLimiting);
        return this.delegate.invoke(SOFT_LIMITED, new Expression[0]);
    }

    AppendableExpression enterLoggableElement(Expression logStatement) {
        return this.withNewDelegate(this.delegate.invoke(ENTER_LOGGABLE_STATEMENT, logStatement), true);
    }

    AppendableExpression exitLoggableElement() {
        return this.withNewDelegate(this.delegate.invoke(EXIT_LOGGABLE_STATEMENT, new Expression[0]), true);
    }

    AppendableExpression appendLoggingFunctionInvocation(String functionName, String placeholderValue, List<SoyExpression> args, List<Expression> escapingDirectives) {
        return this.withNewDelegate(this.delegate.invoke(APPEND_LOGGING_FUNCTION_INVOCATION, LOGGING_FUNCTION_INVOCATION_CREATE.invoke(BytecodeUtils.constant(functionName), BytecodeUtils.constant(placeholderValue), SoyExpression.boxListWithSoyNullishAsJavaNull(args)), BytecodeUtils.asImmutableList(escapingDirectives)), true);
    }

    AppendableExpression setSanitizedContentKindAndDirectionality(SanitizedContentKind kind) {
        return this.withNewDelegate(this.delegate.invoke(SET_SANITIZED_CONTENT_KIND_AND_DIRECTIONALITY, BytecodeUtils.constantSanitizedContentKindAsContentKind(kind)), true);
    }

    Statement flushBuffers(int depth) {
        return this.delegate.invokeVoid(FLUSH_BUFFERS, BytecodeUtils.constant(depth));
    }

    @Override
    public AppendableExpression labelStart(Label label) {
        return this.withNewDelegate(this.delegate.labelStart(label), this.hasSideEffects);
    }

    @Override
    public Statement toStatement() {
        if (this.hasSideEffects) {
            return super.toStatement();
        }
        return Statement.NULL_STATEMENT;
    }

    private AppendableExpression withNewDelegate(Expression newDelegate, boolean hasSideEffects) {
        return new AppendableExpression(newDelegate, hasSideEffects, this.supportsSoftLimiting);
    }

    boolean supportsSoftLimiting() {
        return this.supportsSoftLimiting;
    }
}

