/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.javagencode;

import com.google.common.base.Utf8;
import com.google.template.soy.base.SourceLocation;

public final class IndexedLines {
    private final String[] lines;
    private final int[] startOffsets;

    public IndexedLines(String contents) {
        this.lines = contents.split("\n", -1);
        this.startOffsets = new int[this.lines.length + 1];
        int currIndex = 0;
        for (int i = 0; i < this.lines.length; ++i) {
            this.startOffsets[i] = currIndex;
            currIndex += Utf8.encodedLength((CharSequence)this.lines[i]);
            ++currIndex;
        }
        this.startOffsets[this.startOffsets.length - 1] = currIndex;
    }

    public SourceLocation.ByteSpan convertToSpan(SourceLocation loc) {
        SourceLocation.Point begin = loc.getBeginPoint();
        SourceLocation.Point end = loc.getEndPoint();
        String firstLine = this.getLine(begin.line());
        int beginOffset = this.getOffset(begin.line()) + Utf8.encodedLength((CharSequence)firstLine.substring(0, begin.column() - 1));
        if (begin.line() == end.line()) {
            return SourceLocation.ByteSpan.create(beginOffset, beginOffset + Utf8.encodedLength((CharSequence)firstLine.substring(begin.column() - 1, end.column())));
        }
        int endOffset = beginOffset + Utf8.encodedLength((CharSequence)firstLine.substring(begin.column() - 1));
        for (int i = begin.line() + 1; i < end.line(); ++i) {
            ++endOffset;
            endOffset += Utf8.encodedLength((CharSequence)this.getLine(i));
        }
        ++endOffset;
        return SourceLocation.ByteSpan.create(beginOffset, endOffset += Utf8.encodedLength((CharSequence)this.getLine(end.line()).substring(0, end.column())));
    }

    String getLine(int oneBased) {
        return this.lines[oneBased - 1];
    }

    int getOffset(int oneBased) {
        return this.startOffsets[oneBased - 1];
    }
}

