/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.util;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public final class TopoSort<T> {
    private ImmutableList<T> cyclicKeys;

    public ImmutableList<T> sort(Iterable<T> unsorted, Function<T, Iterable<T>> successorFunc) {
        this.cyclicKeys = null;
        LinkedHashMap deps = new LinkedHashMap();
        HashMap revDeps = new HashMap();
        unsorted.forEach(fn -> {
            HashSet successors = Sets.newHashSet((Iterable)((Iterable)successorFunc.apply(fn)));
            Preconditions.checkArgument((!successors.contains(fn) ? 1 : 0) != 0, (Object)"No self edges please");
            deps.put(fn, successors);
            revDeps.put(fn, new HashSet());
        });
        for (Map.Entry entry : deps.entrySet()) {
            for (Object to : (Set)entry.getValue()) {
                Set rev = (Set)revDeps.get(to);
                Preconditions.checkNotNull((Object)rev, (String)"Successor %s of %s not in input", to, entry.getKey());
                rev.add(entry.getKey());
            }
        }
        ArrayList reordered = new ArrayList(deps.size());
        Object cleared = ImmutableSet.of();
        LinkedHashSet candidateLeaves = (LinkedHashSet)((Object)deps.keySet().stream().filter(k -> ((Set)deps.get(k)).isEmpty()).collect(Collectors.toList()));
        while (!deps.isEmpty()) {
            HashSet nextCleared = new HashSet();
            LinkedHashSet nextCandidateLeaves = new LinkedHashSet();
            for (Object possibleLeaf : candidateLeaves) {
                Set leafDeps = (Set)deps.get(possibleLeaf);
                leafDeps.removeAll((Collection<?>)cleared);
                if (!leafDeps.isEmpty()) continue;
                reordered.add(possibleLeaf);
                deps.remove(possibleLeaf);
                nextCleared.add(possibleLeaf);
                nextCandidateLeaves.addAll((Collection)revDeps.get(possibleLeaf));
            }
            if (nextCleared.isEmpty()) {
                this.cyclicKeys = TopoSort.findCycle(deps);
                throw new NoSuchElementException("cycle");
            }
            candidateLeaves = nextCandidateLeaves;
            cleared = nextCleared;
        }
        return ImmutableList.copyOf(reordered);
    }

    private static <T> ImmutableList<T> findCycle(Map<T, Set<T>> remaining) {
        T root = remaining.keySet().iterator().next();
        HashSet visited = new HashSet();
        ArrayDeque chain = new ArrayDeque();
        if (!TopoSort.dfs(visited, chain, root, remaining::get)) {
            throw new IllegalArgumentException("no cycle found");
        }
        Object lastItem = chain.getLast();
        while (!chain.getFirst().equals(lastItem)) {
            chain.removeFirst();
        }
        Preconditions.checkArgument((chain.size() > 2 ? 1 : 0) != 0, (String)"Short chain %s", chain);
        return ImmutableList.copyOf(chain);
    }

    private static <T> boolean dfs(Set<T> visited, Deque<T> chain, T node, Function<T, Iterable<T>> successors) {
        chain.addLast(node);
        if (!visited.add(node)) {
            return true;
        }
        for (T t : successors.apply(node)) {
            if (!TopoSort.dfs(visited, chain, t, successors)) continue;
            return true;
        }
        chain.removeLast();
        return false;
    }

    public ImmutableList<T> getCyclicKeys() {
        return (ImmutableList)Preconditions.checkNotNull(this.cyclicKeys, (Object)"Topo sort did not fail.");
    }
}

