/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.proto;

import com.google.common.base.CaseFormat;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Sets;
import com.google.common.html.types.SafeHtmlProto;
import com.google.common.html.types.SafeScriptProto;
import com.google.common.html.types.SafeStyleProto;
import com.google.common.html.types.SafeStyleSheetProto;
import com.google.common.html.types.SafeUrlProto;
import com.google.common.html.types.TrustedResourceUrlProto;
import com.google.protobuf.DescriptorProtos;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistry;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import java.util.HashMap;
import javax.annotation.Nullable;

public final class ProtoUtils {
    public static final ExtensionRegistry REGISTRY = ProtoUtils.createRegistry();
    private static final ImmutableSet<String> SAFE_PROTO_TYPES = ImmutableSet.of((Object)SafeHtmlProto.getDescriptor().getFullName(), (Object)SafeScriptProto.getDescriptor().getFullName(), (Object)SafeStyleProto.getDescriptor().getFullName(), (Object)SafeStyleSheetProto.getDescriptor().getFullName(), (Object)SafeUrlProto.getDescriptor().getFullName(), (Object)TrustedResourceUrlProto.getDescriptor().getFullName(), (Object[])new String[0]);
    private static final ImmutableSet<Descriptors.FieldDescriptor.Type> JS_TYPEABLE_FIELDS = Sets.immutableEnumSet((Enum)Descriptors.FieldDescriptor.Type.INT64, (Enum[])new Descriptors.FieldDescriptor.Type[]{Descriptors.FieldDescriptor.Type.SFIXED64, Descriptors.FieldDescriptor.Type.UINT64, Descriptors.FieldDescriptor.Type.FIXED64, Descriptors.FieldDescriptor.Type.SINT64});

    private static ExtensionRegistry createRegistry() {
        ExtensionRegistry instance = ExtensionRegistry.newInstance();
        return instance;
    }

    private ProtoUtils() {
    }

    public static boolean isSanitizedContentField(Descriptors.FieldDescriptor fieldDescriptor) {
        return fieldDescriptor.getType() == Descriptors.FieldDescriptor.Type.MESSAGE && SAFE_PROTO_TYPES.contains((Object)fieldDescriptor.getMessageType().getFullName());
    }

    public static boolean isSanitizedContentMap(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!fieldDescriptor.isMapField()) {
            return false;
        }
        Descriptors.Descriptor valueDesc = ProtoUtils.getMapValueMessageType(fieldDescriptor);
        if (valueDesc == null) {
            return false;
        }
        return SAFE_PROTO_TYPES.contains((Object)valueDesc.getFullName());
    }

    @Nullable
    public static Descriptors.Descriptor getMapValueMessageType(Descriptors.FieldDescriptor mapField) {
        Descriptors.FieldDescriptor valueDesc = ProtoUtils.getMapValueFieldDescriptor(mapField);
        if (valueDesc.getType() == Descriptors.FieldDescriptor.Type.MESSAGE) {
            return valueDesc.getMessageType();
        }
        return null;
    }

    @Nullable
    public static Descriptors.FieldDescriptor getMapValueFieldDescriptor(Descriptors.FieldDescriptor mapField) {
        Preconditions.checkArgument((boolean)mapField.isMapField());
        return mapField.getMessageType().findFieldByName("value");
    }

    public static String getQualifiedOuterClassname(Descriptors.GenericDescriptor desc) {
        return String.format("%s.%s.getDescriptor()", JavaQualifiedNames.getPackage(desc.getFile()), JavaQualifiedNames.getOuterClassname(desc.getFile()));
    }

    public static String getJsExtensionImport(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            return ProtoUtils.calculateUnprefixedJsName((Descriptors.GenericDescriptor)scope);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    public static String getJsExtensionName(Descriptors.FieldDescriptor desc) {
        Descriptors.Descriptor scope = desc.getExtensionScope();
        if (scope != null) {
            return ProtoUtils.calculateUnprefixedJsName((Descriptors.GenericDescriptor)scope) + "." + ProtoUtils.computeJsExtensionName(desc);
        }
        return ProtoUtils.getJsPackage(desc.getFile()) + "." + ProtoUtils.computeJsExtensionName(desc);
    }

    private static String computeJsExtensionName(Descriptors.FieldDescriptor field) {
        String name = CaseFormat.LOWER_UNDERSCORE.to(CaseFormat.LOWER_CAMEL, field.getName());
        return field.isRepeated() ? name + "List" : name;
    }

    private static String getJsPackage(Descriptors.FileDescriptor file) {
        String protoPackage = file.getPackage();
        if (!protoPackage.isEmpty()) {
            return "proto." + protoPackage;
        }
        return "proto";
    }

    public static boolean shouldJsIgnoreField(Descriptors.FieldDescriptor fieldDescriptor) {
        return false;
    }

    public static boolean hasJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        if (!JS_TYPEABLE_FIELDS.contains((Object)fieldDescriptor.getType())) {
            return false;
        }
        return fieldDescriptor.getOptions().hasJstype();
    }

    public static boolean isUnsigned(Descriptors.FieldDescriptor descriptor) {
        switch (descriptor.getType()) {
            case FIXED32: 
            case FIXED64: 
            case UINT32: 
            case UINT64: {
                return true;
            }
        }
        return false;
    }

    public static DescriptorProtos.FieldOptions.JSType getJsType(Descriptors.FieldDescriptor fieldDescriptor) {
        boolean hasJstype = fieldDescriptor.getOptions().hasJstype();
        if (hasJstype) {
            return fieldDescriptor.getOptions().getJstype();
        }
        return null;
    }

    public static String calculateJsEnumName(Descriptors.EnumDescriptor descriptor) {
        return ProtoUtils.calculateUnprefixedJsName((Descriptors.GenericDescriptor)descriptor);
    }

    public static String calculateFileLocalName(Descriptors.GenericDescriptor descriptor) {
        String protoPackage = descriptor.getFile().getPackage();
        String name = descriptor.getFullName();
        if (!name.startsWith(protoPackage)) {
            throw new AssertionError((Object)("Expected \"" + name + "\" to start with \"" + protoPackage + "\""));
        }
        return protoPackage.isEmpty() ? name : name.substring(protoPackage.length() + 1);
    }

    public static String calculateUnprefixedJsName(Descriptors.GenericDescriptor descriptor) {
        String jsPackage = ProtoUtils.getJsPackage(descriptor.getFile());
        return jsPackage + "." + ProtoUtils.calculateFileLocalName(descriptor);
    }

    public static String getJsFieldSpecificSuffix(Descriptors.FieldDescriptor fieldDesc) {
        HashMap fieldSpecificSuffixes = new HashMap();
        return fieldSpecificSuffixes.getOrDefault(fieldDesc, "");
    }

    public static Descriptors.OneofDescriptor getContainingOneof(Descriptors.FieldDescriptor fd) {
        return fd.getContainingOneof();
    }

    public static enum MutabilityMode {
        MUTABLE("Mutable"),
        READONLY("Readonly"),
        IMMUTABLE("Immutable");

        final String prefix;

        private MutabilityMode(String prefix) {
            this.prefix = prefix;
        }
    }
}

