/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprNode;

public final class GroupNode
extends AbstractParentExprNode {
    private final boolean nullSafePlaceholder;

    public GroupNode(ExprNode expr, SourceLocation sourceLocation) {
        this(expr, sourceLocation, false);
    }

    public GroupNode(ExprNode expr, SourceLocation sourceLocation, boolean nullSafePlaceholder) {
        super(sourceLocation);
        Preconditions.checkArgument((expr != null ? 1 : 0) != 0);
        this.addChild(expr);
        this.nullSafePlaceholder = nullSafePlaceholder;
    }

    private GroupNode(GroupNode orig, CopyState copyState) {
        super(orig, copyState);
        this.nullSafePlaceholder = orig.nullSafePlaceholder;
    }

    public boolean isNullSafeAccessPlaceHolder() {
        return this.nullSafePlaceholder;
    }

    @Override
    public String toSourceString() {
        return "(" + this.getChild(0).toSourceString() + ")";
    }

    @Override
    public GroupNode copy(CopyState copyState) {
        return new GroupNode(this, copyState);
    }

    @Override
    public ExprNode.Kind getKind() {
        return ExprNode.Kind.GROUP_NODE;
    }
}

