/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Booleans;
import com.google.common.primitives.Doubles;
import com.google.common.primitives.Longs;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.GroupNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.ListComprehensionNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralFromListNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.MethodCallNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.NullSafeAccessNode;
import com.google.template.soy.exprtree.ProtoEnumValueNode;
import com.google.template.soy.exprtree.RecordLiteralNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.TemplateLiteralNode;
import com.google.template.soy.exprtree.UndefinedNode;
import com.google.template.soy.exprtree.VarRefNode;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;

public final class ExprEquivalence {
    private final IdentityHashMap<ExprNode, Wrapper> interningMap = new IdentityHashMap();
    private final Equivalence<ExprNode> equivalence = new Equivalence<ExprNode>(){

        protected boolean doEquivalent(ExprNode a, ExprNode b) {
            return a.getKind() == b.getKind() && (Boolean)new EqualsVisitor(a).exec(b) != false;
        }

        protected int doHash(ExprNode t) {
            return 31 * t.getKind().hashCode() + (Integer)ExprEquivalence.this.hashCodeVisitor.exec(t);
        }
    };
    private final AbstractReturningExprNodeVisitor<Integer> hashCodeVisitor = new AbstractReturningExprNodeVisitor<Integer>(){

        @Override
        protected Integer visitVarRefNode(VarRefNode node) {
            return Objects.hashCode(node.getDefnDecl());
        }

        @Override
        protected Integer visitFieldAccessNode(FieldAccessNode node) {
            return Objects.hash(ExprEquivalence.this.wrap(node.getBaseExprChild()), node.getFieldName(), node.isNullSafe());
        }

        @Override
        protected Integer visitItemAccessNode(ItemAccessNode node) {
            return Objects.hash(ExprEquivalence.this.wrap(node.getBaseExprChild()), ExprEquivalence.this.wrap(node.getKeyExprChild()), node.isNullSafe());
        }

        @Override
        protected Integer visitMethodCallNode(MethodCallNode node) {
            return 31 * (node.getMethodName().identifier().hashCode() * 31 + this.hashChildren(node)) + Boolean.hashCode(node.isNullSafe());
        }

        @Override
        protected Integer visitNullSafeAccessNode(NullSafeAccessNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitFunctionNode(FunctionNode node) {
            int hash = 1;
            hash = node.hasStaticName() ? hash * 31 + node.getStaticFunctionName().hashCode() : hash * 31 + (Integer)this.visit(node.getNameExpr());
            hash = node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED ? hash * 31 + ExprEquivalence.this.namedParamsMap(node).hashCode() : hash * 31 + this.hashChildren(node);
            return hash;
        }

        @Override
        protected Integer visitGlobalNode(GlobalNode node) {
            return node.getName().hashCode();
        }

        @Override
        protected Integer visitGroupNode(GroupNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitListLiteralNode(ListLiteralNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitListComprehensionNode(ListComprehensionNode node) {
            return Objects.hash(node.getListIterVar(), node.getIndexVar(), node.getListExpr(), node.getListItemTransformExpr(), node.getFilterExpr());
        }

        @Override
        protected Integer visitRecordLiteralNode(RecordLiteralNode node) {
            return ExprEquivalence.this.recordLiteralFields(node).hashCode();
        }

        @Override
        protected Integer visitMapLiteralNode(MapLiteralNode node) {
            return ExprEquivalence.this.mapLiteralFields(node).hashCode();
        }

        @Override
        protected Integer visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitTemplateLiteralNode(TemplateLiteralNode node) {
            return node.getResolvedName().hashCode();
        }

        @Override
        protected Integer visitBooleanNode(BooleanNode node) {
            return Booleans.hashCode((boolean)node.getValue());
        }

        @Override
        protected Integer visitIntegerNode(IntegerNode node) {
            return Longs.hashCode((long)node.getValue());
        }

        @Override
        protected Integer visitFloatNode(FloatNode node) {
            return Doubles.hashCode((double)node.getValue());
        }

        @Override
        protected Integer visitStringNode(StringNode node) {
            return node.getValue().hashCode();
        }

        @Override
        protected Integer visitProtoEnumValueNode(ProtoEnumValueNode node) {
            return Objects.hash(node.getType(), node.getValue());
        }

        @Override
        protected Integer visitExprRootNode(ExprRootNode node) {
            return this.hashChildren(node);
        }

        @Override
        protected Integer visitOperatorNode(ExprNode.OperatorNode node) {
            return node.getOperator().hashCode() * 31 + this.hashChildren(node);
        }

        @Override
        protected Integer visitNullNode(NullNode node) {
            return 0;
        }

        @Override
        protected Integer visitUndefinedNode(UndefinedNode node) {
            return -1;
        }

        @Override
        protected Integer visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException(node.toSourceString());
        }

        private int hashChildren(ExprNode.ParentExprNode node) {
            return ExprEquivalence.this.hash(node.getChildren());
        }
    };

    private HashMap<String, Wrapper> namedParamsMap(FunctionNode node) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        List<ExprNode> params = node.getParams();
        for (int i = 0; i < params.size(); ++i) {
            map.put(node.getParamName(i).identifier(), this.wrap(params.get(i)));
        }
        return map;
    }

    private HashMap<String, Wrapper> recordLiteralFields(RecordLiteralNode node) {
        HashMap<String, Wrapper> map = new HashMap<String, Wrapper>();
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            map.put(node.getKey(i).identifier(), this.wrap(children.get(i)));
        }
        return map;
    }

    private HashMap<Wrapper, Wrapper> mapLiteralFields(MapLiteralNode node) {
        HashMap<Wrapper, Wrapper> map = new HashMap<Wrapper, Wrapper>();
        List<ExprNode> children = node.getChildren();
        for (int i = 0; i < children.size(); i += 2) {
            map.put(this.wrap(children.get(i)), this.wrap(children.get(i + 1)));
        }
        return map;
    }

    public boolean equivalent(ExprNode a, ExprNode b) {
        return this.equivalence.equivalent((Object)a, (Object)b);
    }

    public boolean equivalent(List<ExprNode> a, List<ExprNode> b) {
        if (a.size() != b.size()) {
            return false;
        }
        for (int i = 0; i < a.size(); ++i) {
            if (this.equivalent(a.get(i), b.get(i))) continue;
            return false;
        }
        return true;
    }

    public int hash(ExprNode a) {
        return this.wrap(a).hashCode();
    }

    public int hash(List<ExprNode> a) {
        int result = 1;
        for (ExprNode element : a) {
            result = 31 * result + this.wrap(element).hashCode();
        }
        return result;
    }

    public Wrapper wrap(ExprNode expr) {
        return this.interningMap.computeIfAbsent(expr, this::createWrapper);
    }

    private Wrapper createWrapper(ExprNode expr) {
        return new Wrapper(this.equivalence, expr);
    }

    public static final class Wrapper {
        private final Equivalence<ExprNode> equivalence;
        private final ExprNode expr;
        private final int hashCode;

        Wrapper(Equivalence<ExprNode> equivalence, ExprNode expr) {
            this.equivalence = equivalence;
            this.expr = (ExprNode)Preconditions.checkNotNull((Object)expr);
            this.hashCode = equivalence.hash((Object)expr);
        }

        public ExprNode get() {
            return this.expr;
        }

        public int hashCode() {
            return this.hashCode;
        }

        public boolean equals(Object other) {
            if (this == other) {
                return true;
            }
            if (other instanceof Wrapper) {
                Wrapper otherWrapper = (Wrapper)other;
                if (otherWrapper.equivalence != this.equivalence) {
                    return false;
                }
                return this.equivalence.equivalent((Object)this.expr, (Object)otherWrapper.expr);
            }
            return false;
        }

        public String toString() {
            return this.expr.toSourceString();
        }
    }

    final class EqualsVisitor
    extends AbstractReturningExprNodeVisitor<Boolean> {
        private final ExprNode other;

        EqualsVisitor(ExprNode other) {
            this.other = other;
        }

        @Override
        protected Boolean visitVarRefNode(VarRefNode node) {
            VarRefNode typedOther = (VarRefNode)this.other;
            if (node.getDefnDecl() != null || typedOther.getDefnDecl() != null) {
                return node.getDefnDecl().isEquivalent(typedOther.getDefnDecl());
            }
            return typedOther.getName().equals(node.getName());
        }

        @Override
        protected Boolean visitFieldAccessNode(FieldAccessNode node) {
            FieldAccessNode typedOther = (FieldAccessNode)this.other;
            return ExprEquivalence.this.equivalent(node.getBaseExprChild(), typedOther.getBaseExprChild()) && node.getFieldName().equals(typedOther.getFieldName()) && node.isNullSafe() == typedOther.isNullSafe();
        }

        @Override
        protected Boolean visitItemAccessNode(ItemAccessNode node) {
            ItemAccessNode typedOther = (ItemAccessNode)this.other;
            return ExprEquivalence.this.equivalent(node.getBaseExprChild(), typedOther.getBaseExprChild()) && ExprEquivalence.this.equivalent(node.getKeyExprChild(), typedOther.getKeyExprChild()) && node.isNullSafe() == typedOther.isNullSafe();
        }

        @Override
        protected Boolean visitMethodCallNode(MethodCallNode node) {
            MethodCallNode typedOther = (MethodCallNode)this.other;
            return node.getMethodName().identifier().equals(typedOther.getMethodName().identifier()) && node.isNullSafe() == typedOther.isNullSafe() && this.compareChildren(node);
        }

        @Override
        protected Boolean visitNullSafeAccessNode(NullSafeAccessNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitFunctionNode(FunctionNode node) {
            boolean ok;
            FunctionNode typedOther = (FunctionNode)this.other;
            if (node.hasStaticName() != typedOther.hasStaticName()) {
                return false;
            }
            boolean bl = ok = node.hasStaticName() ? node.getStaticFunctionName().equals(typedOther.getStaticFunctionName()) : ExprEquivalence.this.equivalent(node.getNameExpr(), typedOther.getNameExpr());
            ok = node.getParamsStyle() == ExprNode.CallableExpr.ParamsStyle.NAMED ? ok && ExprEquivalence.this.namedParamsMap(node).equals(ExprEquivalence.this.namedParamsMap(typedOther)) : ok && this.compareChildren(node);
            return ok;
        }

        @Override
        protected Boolean visitGlobalNode(GlobalNode node) {
            return node.getName().equals(((GlobalNode)this.other).getName());
        }

        @Override
        protected Boolean visitListLiteralNode(ListLiteralNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitRecordLiteralNode(RecordLiteralNode node) {
            return ExprEquivalence.this.recordLiteralFields(node).equals(ExprEquivalence.this.recordLiteralFields((RecordLiteralNode)this.other));
        }

        @Override
        protected Boolean visitMapLiteralNode(MapLiteralNode node) {
            return ExprEquivalence.this.mapLiteralFields(node).equals(ExprEquivalence.this.mapLiteralFields((MapLiteralNode)this.other));
        }

        @Override
        protected Boolean visitListComprehensionNode(ListComprehensionNode node) {
            return node == this.other;
        }

        @Override
        protected Boolean visitMapLiteralFromListNode(MapLiteralFromListNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitTemplateLiteralNode(TemplateLiteralNode node) {
            TemplateLiteralNode otherNode = (TemplateLiteralNode)this.other;
            return node.getResolvedName().equals(otherNode.getResolvedName());
        }

        @Override
        protected Boolean visitBooleanNode(BooleanNode node) {
            return node.getValue() == ((BooleanNode)this.other).getValue();
        }

        @Override
        protected Boolean visitIntegerNode(IntegerNode node) {
            return node.getValue() == ((IntegerNode)this.other).getValue();
        }

        @Override
        protected Boolean visitFloatNode(FloatNode node) {
            return node.getValue() == ((FloatNode)this.other).getValue();
        }

        @Override
        protected Boolean visitStringNode(StringNode node) {
            return node.getValue().equals(((StringNode)this.other).getValue());
        }

        @Override
        protected Boolean visitProtoEnumValueNode(ProtoEnumValueNode node) {
            return node.getType().equals(((ProtoEnumValueNode)this.other).getType()) && node.getValue() == ((ProtoEnumValueNode)this.other).getValue();
        }

        @Override
        protected Boolean visitExprRootNode(ExprRootNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitOperatorNode(ExprNode.OperatorNode node) {
            return node.getOperator() == ((ExprNode.OperatorNode)this.other).getOperator() && this.compareChildren(node);
        }

        @Override
        protected Boolean visitNullNode(NullNode node) {
            return true;
        }

        @Override
        protected Boolean visitUndefinedNode(UndefinedNode node) {
            return true;
        }

        @Override
        protected Boolean visitGroupNode(GroupNode node) {
            return this.compareChildren(node);
        }

        @Override
        protected Boolean visitExprNode(ExprNode node) {
            throw new UnsupportedOperationException(node.toSourceString());
        }

        private boolean compareChildren(ExprNode.ParentExprNode node) {
            return ExprEquivalence.this.equivalent(node.getChildren(), ((ExprNode.ParentExprNode)this.other).getChildren());
        }
    }
}

