/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.exprtree;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.SetOnce;
import com.google.template.soy.basetree.AbstractNode;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.ExprNode;

public abstract class AbstractExprNode
extends AbstractNode
implements ExprNode {
    private final SourceLocation sourceLocation;
    private SetOnce<Boolean> desugaredGroup = new SetOnce();

    @Override
    public ExprNode.ParentExprNode getParent() {
        return (ExprNode.ParentExprNode)super.getParent();
    }

    protected AbstractExprNode(SourceLocation sourceLocation) {
        this.sourceLocation = (SourceLocation)Preconditions.checkNotNull((Object)sourceLocation);
    }

    protected AbstractExprNode(AbstractExprNode orig, CopyState copyState) {
        super(orig, copyState);
        this.sourceLocation = orig.sourceLocation;
        this.desugaredGroup = orig.desugaredGroup.copy();
    }

    @Override
    public SourceLocation getSourceLocation() {
        return this.sourceLocation;
    }

    @Override
    public <N extends Node> N getNearestAncestor(Class<N> ancestorClass) {
        Preconditions.checkArgument((boolean)ExprNode.class.isAssignableFrom(ancestorClass));
        return super.getNearestAncestor(ancestorClass);
    }

    @Override
    public boolean isDesugaredGroup() {
        return this.desugaredGroup.isPresent() ? this.desugaredGroup.get() : false;
    }

    @Override
    public void setDesugaredGroup(boolean groupedInSource) {
        this.desugaredGroup.set(groupedInSource);
    }
}

