/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.examples;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.io.Resources;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.examples.FeaturesSoyInfo;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URL;
import java.util.Map;
import org.kohsuke.args4j.CmdLineException;
import org.kohsuke.args4j.CmdLineParser;
import org.kohsuke.args4j.Option;

public class FeaturesUsage {
    private static final String USAGE_PREFIX = "Usage:\njava com.google.template.soy.examples.FeaturesUsage [-locale <locale>]\n";
    private static final String XLIFF_RESOURCE_PREFIX = "examples_translated_";
    @Option(name="-locale", usage="The locale to render templates in. The corresponding XLIFF resource examples_translated_<locale>.xlf must exist. If not provided, the messages from the Soy source will be used.")
    private String locale = "";
    private int numExamples = 0;

    private FeaturesUsage() {
    }

    public static void main(String[] args) throws IOException {
        new FeaturesUsage().execMain(args);
    }

    private void execMain(String[] args) throws IOException {
        SoyMsgBundle msgBundle;
        CmdLineParser cmdLineParser = new CmdLineParser((Object)this);
        cmdLineParser.setUsageWidth(100);
        try {
            cmdLineParser.parseArgument(args);
        }
        catch (CmdLineException cle) {
            System.err.println("\nError: " + cle.getMessage() + "\n\n");
            System.err.println(USAGE_PREFIX);
            cmdLineParser.printUsage((OutputStream)System.err);
            System.exit(1);
        }
        SoyFileSet.Builder sfsBuilder = SoyFileSet.builder();
        SoyFileSet sfs = sfsBuilder.add(Resources.getResource((String)"simple.soy"), "examples/simple.soy").add(Resources.getResource((String)"features.soy"), "examples/features.soy").build();
        SoyTofu tofu = sfs.compileToTofu().forNamespace("soy.examples.features");
        if (this.locale.length() > 0) {
            SoyMsgBundleHandler msgBundleHandler = new SoyMsgBundleHandler(new XliffMsgPlugin());
            URL xliffResource = Resources.getResource((String)(XLIFF_RESOURCE_PREFIX + this.locale + ".xlf"));
            msgBundle = msgBundleHandler.createFromResource(xliffResource);
            if (msgBundle.getLocaleString() == null) {
                throw new IOException("Error reading message resource \"examples_translated_" + this.locale + ".xlf\".");
            }
        } else {
            msgBundle = null;
        }
        this.writeExampleHeader("demoComments");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_COMMENTS).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoLineJoining");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_LINE_JOINING).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoRawTextCommands");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_RAW_TEXT_COMMANDS).setMsgBundle(msgBundle).renderText());
        this.writeExampleHeader("demoPrint");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_PRINT).setData((Map<String, ?>)ImmutableMap.of((Object)"boo", (Object)"Boo!", (Object)"two", (Object)2)).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoAutoescapeTrue");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_AUTOESCAPE_TRUE).setData((Map<String, ?>)ImmutableMap.of((Object)"italicHtml", (Object)"<i>italic</i>")).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoMsg");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_MSG).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Ed")).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoIf");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_IF).setData((Map<String, ?>)ImmutableMap.of((Object)"pi", (Object)3.14159)).setMsgBundle(msgBundle).render());
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_IF).setData((Map<String, ?>)ImmutableMap.of((Object)"pi", (Object)2.71828)).setMsgBundle(msgBundle).render());
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_IF).setData((Map<String, ?>)ImmutableMap.of((Object)"pi", (Object)1.61803)).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoSwitch");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_SWITCH).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Fay")).setMsgBundle(msgBundle).render());
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_SWITCH).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Go")).setMsgBundle(msgBundle).render());
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_SWITCH).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Hal")).setMsgBundle(msgBundle).render());
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_SWITCH).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Ivy")).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoFor");
        ImmutableList persons = ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)"Jen", (Object)"numWaffles", (Object)1), (Object)ImmutableMap.of((Object)"name", (Object)"Kai", (Object)"numWaffles", (Object)3), (Object)ImmutableMap.of((Object)"name", (Object)"Lex", (Object)"numWaffles", (Object)1), (Object)ImmutableMap.of((Object)"name", (Object)"Mel", (Object)"numWaffles", (Object)2));
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_FOR).setData((Map<String, ?>)ImmutableMap.of((Object)"persons", (Object)persons)).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoFor_Range");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_FOR_RANGE).setData((Map<String, ?>)ImmutableMap.of((Object)"numLines", (Object)3)).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoCallWithoutParam");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_CALL_WITHOUT_PARAM).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Neo", (Object)"tripInfo", (Object)ImmutableMap.of((Object)"name", (Object)"Neo", (Object)"destination", (Object)"The Matrix"))).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoCallWithParam");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_CALL_WITH_PARAM).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Oz", (Object)"companionName", (Object)"Pip", (Object)"destinations", (Object)ImmutableList.of((Object)"Gillikin Country", (Object)"Munchkin Country", (Object)"Quadling Country", (Object)"Winkie Country"))).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoCallWithParamBlock");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_CALL_WITH_PARAM_BLOCK).setData((Map<String, ?>)ImmutableMap.of((Object)"name", (Object)"Quo")).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoExpressions");
        ImmutableList students = ImmutableList.of((Object)ImmutableMap.of((Object)"name", (Object)"Rob", (Object)"major", (Object)"Physics", (Object)"year", (Object)1999), (Object)ImmutableMap.of((Object)"name", (Object)"Sha", (Object)"major", (Object)"Finance", (Object)"year", (Object)1980), (Object)ImmutableMap.of((Object)"name", (Object)"Tim", (Object)"major", (Object)"Engineering", (Object)"year", (Object)2005), (Object)ImmutableMap.of((Object)"name", (Object)"Uma", (Object)"major", (Object)"Biology", (Object)"year", (Object)1972));
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_EXPRESSIONS).setData((Map<String, ?>)ImmutableMap.of((Object)"students", (Object)students, (Object)"currentYear", (Object)2008)).setMsgBundle(msgBundle).render());
        this.writeExampleHeader("demoDoubleBraces");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_DOUBLE_BRACES).setData((Map<String, ?>)ImmutableMap.of((Object)"setName", (Object)"prime numbers", (Object)"setMembers", (Object)ImmutableList.of((Object)2, (Object)3, (Object)5, (Object)7, (Object)11, (Object)13))).setMsgBundle(msgBundle).renderText());
        this.writeExampleHeader("demoBidiSupport");
        System.out.println(tofu.newRenderer(FeaturesSoyInfo.DEMO_BIDI_SUPPORT).setData((Map<String, ?>)ImmutableMap.of((Object)"title", (Object)"2008: A BiDi Odyssey", (Object)"author", (Object)"John Doe, Esq.", (Object)"year", (Object)1973, (Object)"keywords", (Object)ImmutableList.of((Object)"Bi(Di)", (Object)"2008 (\u05e9\u05e0\u05d4)", (Object)"2008 (year)"))).setMsgBundle(msgBundle).render());
    }

    private void writeExampleHeader(String exampleName) {
        ++this.numExamples;
        System.out.println("--------------------------------------------------------------------------------");
        System.out.printf("[%d. %s]\n", this.numExamples, exampleName);
    }
}

