/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.error;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.error.ErrorReporterImpl;
import com.google.template.soy.error.ExplodingErrorReporter;
import com.google.template.soy.error.IllegalArgumentExceptionErrorReporter;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrorKind;
import java.util.Map;

public abstract class ErrorReporter {
    private static final LocationBound NO_OP = new LocationBound(){

        @Override
        public void report(SoyErrorKind error, Object ... args) {
        }

        @Override
        public void warn(SoyErrorKind error, Object ... args) {
        }
    };

    public static ErrorReporter create(Map<SourceLogicalPath, SoyFileSupplier> filePathsToSuppliers) {
        return new ErrorReporterImpl((ImmutableMap<SourceLogicalPath, SoyFileSupplier>)ImmutableMap.copyOf(filePathsToSuppliers));
    }

    public static ErrorReporter devnull() {
        return new ExplodingErrorReporter(){

            @Override
            public void report(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            }

            @Override
            public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
            }
        };
    }

    @VisibleForTesting
    public static ErrorReporter createForTest() {
        return new ErrorReporterImpl((ImmutableMap<SourceLogicalPath, SoyFileSupplier>)ImmutableMap.of());
    }

    public static ErrorReporter exploding() {
        return ExplodingErrorReporter.EXPLODING;
    }

    public static ErrorReporter illegalArgumentExceptionExploding() {
        return IllegalArgumentExceptionErrorReporter.INSTANCE;
    }

    public static ErrorReporter explodeOnErrorsAndIgnoreWarnings() {
        return ExplodingErrorReporter.EXPLODING_IGNORE_WARNINGS;
    }

    public static ErrorReporter explodeOnErrorsAndIgnoreDeprecations() {
        return new ExplodingErrorReporter(){

            @Override
            public void warn(SourceLocation sourceLocation, SoyErrorKind error, Object ... args) {
                if (!error.isDeprecation()) {
                    super.warn(sourceLocation, error, args);
                }
            }
        };
    }

    public abstract void report(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public abstract void warn(SourceLocation var1, SoyErrorKind var2, Object ... var3);

    public abstract void copyTo(ErrorReporter var1);

    public LocationBound bind(SourceLocation sourceLocation) {
        return new LocationBoundImp(sourceLocation);
    }

    public LocationBound bindIgnoringUnknown(SourceLocation sourceLocation) {
        return sourceLocation.isKnown() ? new LocationBoundImp(sourceLocation) : NO_OP;
    }

    public final Checkpoint checkpoint() {
        return new Checkpoint(this, this.getCurrentNumberOfReports(), this.getCurrentNumberOfErrors());
    }

    public final boolean errorsSince(Checkpoint checkpoint) {
        if (checkpoint.owner != this) {
            throw new IllegalArgumentException("Can only call errorsSince on a Checkpoint instance that was returned from this same reporter");
        }
        return this.getCurrentNumberOfErrors() > checkpoint.errorsSoFar;
    }

    public final ImmutableList<SoyError> getErrorsSince(Checkpoint checkpoint) {
        return (ImmutableList)this.getReportsSince(checkpoint).stream().filter(e -> !e.isWarning()).collect(ImmutableList.toImmutableList());
    }

    public final ImmutableList<SoyError> getReportsSince(Checkpoint checkpoint) {
        if (checkpoint.owner != this) {
            throw new IllegalArgumentException("Can only call errorsSince on a Checkpoint instance that was returned from this same reporter");
        }
        return this.getReports(checkpoint.reportsSoFar, this.getCurrentNumberOfReports());
    }

    public final boolean hasErrors() {
        return this.getCurrentNumberOfErrors() != 0;
    }

    public final boolean hasErrorsOrWarnings() {
        return this.getCurrentNumberOfReports() != 0;
    }

    @ForOverride
    int getCurrentNumberOfErrors() {
        return (int)this.getReports().stream().filter(r -> !r.isWarning()).count();
    }

    @ForOverride
    int getCurrentNumberOfReports() {
        return this.getReports().size();
    }

    public abstract ImmutableList<SoyError> getReports();

    protected ImmutableList<SoyError> getReports(int from, int to) {
        return this.getReports().subList(from, to);
    }

    public ImmutableList<SoyError> getErrors() {
        return (ImmutableList)this.getReports().stream().filter(r -> !r.isWarning()).collect(ImmutableList.toImmutableList());
    }

    public ImmutableList<SoyError> getWarnings() {
        return (ImmutableList)this.getReports().stream().filter(SoyError::isWarning).collect(ImmutableList.toImmutableList());
    }

    private class LocationBoundImp
    implements LocationBound {
        private final SourceLocation sourceLocation;

        public LocationBoundImp(SourceLocation sourceLocation) {
            this.sourceLocation = sourceLocation;
        }

        @Override
        public void report(SoyErrorKind error, Object ... args) {
            ErrorReporter.this.report(this.sourceLocation, error, args);
        }

        @Override
        public void warn(SoyErrorKind error, Object ... args) {
            ErrorReporter.this.warn(this.sourceLocation, error, args);
        }
    }

    public static final class Checkpoint {
        private final ErrorReporter owner;
        private final int reportsSoFar;
        private final int errorsSoFar;

        private Checkpoint(ErrorReporter owner, int reportsSoFar, int errorsSoFar) {
            this.owner = owner;
            this.reportsSoFar = reportsSoFar;
            this.errorsSoFar = errorsSoFar;
        }
    }

    public static interface LocationBound {
        public void report(SoyErrorKind var1, Object ... var2);

        public void warn(SoyErrorKind var1, Object ... var2);
    }
}

