/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SoyTemplate;
import com.google.template.soy.data.SoyTemplateParam;
import com.google.template.soy.parseinfo.SoyTemplateInfo;
import com.google.template.soy.parseinfo.TemplateName;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.Arrays;

public final class SoyTemplatesRestrictedApi {
    private static final ClassValue<String> templateNameValue = new ClassValue<String>(){

        @Override
        protected String computeValue(Class<?> type) {
            try {
                Field field = type.getDeclaredField("__NAME__");
                field.setAccessible(true);
                return (String)field.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unexpected error while accessing the template name of " + type.getName(), e);
            }
        }
    };
    private static final ClassValue<ImmutableSet<SoyTemplateParam<?>>> templateParamsValue = new ClassValue<ImmutableSet<SoyTemplateParam<?>>>(){

        @Override
        protected ImmutableSet<SoyTemplateParam<?>> computeValue(Class<?> type) {
            try {
                Field field = type.getDeclaredField("__PARAMS__");
                field.setAccessible(true);
                return (ImmutableSet)field.get(null);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Unexpected error while accessing the template params of " + type.getName(), e);
            }
        }
    };

    private SoyTemplatesRestrictedApi() {
    }

    public static String getTemplateName(Class<? extends SoyTemplate> type) {
        return templateNameValue.get(type);
    }

    public static ImmutableSet<SoyTemplateParam<?>> getParams(Class<? extends SoyTemplate> type) {
        return templateParamsValue.get(type);
    }

    public static SoyTemplateInfo asSoyTemplateInfo(Class<? extends SoyTemplate> type) {
        return new SoyTemplateInfoShim(type);
    }

    public static ImmutableList<Class<? extends SoyTemplate>> getTemplatesInFileWrapper(Class<?> wrapperClass) {
        ImmutableList rv = (ImmutableList)Arrays.stream(wrapperClass.getDeclaredClasses()).filter(c -> Modifier.isStatic(c.getModifiers()) && SoyTemplate.class.isAssignableFrom((Class<?>)c)).map(c -> c).collect(ImmutableList.toImmutableList());
        if (rv.isEmpty() && !wrapperClass.getName().endsWith("Templates")) {
            throw new IllegalArgumentException("Not a file wrapper class: " + String.valueOf(wrapperClass));
        }
        return rv;
    }

    private static final class SoyTemplateInfoShim
    extends SoyTemplateInfo {
        SoyTemplateInfoShim(Class<? extends SoyTemplate> type) {
            super(SoyTemplatesRestrictedApi.getTemplateName(type), TemplateName.of(SoyTemplatesRestrictedApi.getTemplateName(type)), SoyTemplateInfoShim.paramsAsMap(SoyTemplatesRestrictedApi.getParams(type)));
        }

        private static ImmutableMap<String, SoyTemplateInfo.ParamRequisiteness> paramsAsMap(ImmutableSet<SoyTemplateParam<?>> params) {
            return (ImmutableMap)params.stream().collect(ImmutableMap.toImmutableMap(SoyTemplateParam::getName, p -> p.isRequired() ? SoyTemplateInfo.ParamRequisiteness.REQUIRED : SoyTemplateInfo.ParamRequisiteness.OPTIONAL));
        }
    }
}

