/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.concurrent.LazyInit;
import com.google.protobuf.Descriptors;
import com.google.protobuf.Message;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.TextFormat;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.ProtoFieldInterpreter;
import com.google.template.soy.data.RecordProperty;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.internal.proto.Field;
import com.google.template.soy.internal.proto.JavaQualifiedNames;
import com.google.template.soy.jbcsrc.shared.Names;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.function.BiConsumer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;

public final class SoyProtoValue
extends SoyAbstractValue
implements SoyLegacyObjectMap,
SoyRecord {
    private static final Logger logger = Logger.getLogger(SoyProtoValue.class.getName());
    private static final LoadingCache<Descriptors.Descriptor, ProtoClass> classCache = CacheBuilder.newBuilder().weakKeys().build((CacheLoader)new CacheLoader<Descriptors.Descriptor, ProtoClass>(){
        final Field.Factory<FieldWithInterpreter> factory = FieldWithInterpreter::new;

        public ProtoClass load(Descriptors.Descriptor descriptor) throws Exception {
            LinkedHashSet<Descriptors.FieldDescriptor> extensions = new LinkedHashSet<Descriptors.FieldDescriptor>();
            return new ProtoClass(SoyProtoValue.getDefaultInstance(descriptor), Field.getFieldsForType(descriptor, extensions, this.factory));
        }
    });
    private final Message proto;
    private ProtoClass clazz;
    private Object locationKey;

    private static Message getDefaultInstance(Descriptors.Descriptor key) throws ClassNotFoundException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        Class<?> messageClass = Class.forName(JavaQualifiedNames.getClassName(key));
        return (Message)messageClass.getMethod("getDefaultInstance", new Class[0]).invoke(null, new Object[0]);
    }

    @Nonnull
    public static SoyProtoValue create(Message proto) {
        return new SoyProtoValue(proto);
    }

    private SoyProtoValue(Message proto) {
        this.proto = (Message)Preconditions.checkNotNull((Object)proto);
    }

    private ProtoClass clazz() {
        ProtoClass localClazz = this.clazz;
        if (localClazz == null) {
            this.clazz = localClazz = (ProtoClass)classCache.getUnchecked((Object)this.proto.getDescriptorForType());
        }
        return localClazz;
    }

    @Override
    @Nonnull
    public Message getProto() {
        return this.proto;
    }

    public SoyValue getProtoField(String name) {
        return this.getProtoField(name, false);
    }

    public SoyValue getProtoField(String name, boolean forceStringConversion) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        Descriptors.FieldDescriptor fd = field.getDescriptor();
        if (!fd.isRepeated() && fd.getJavaType() == Descriptors.FieldDescriptor.JavaType.MESSAGE && !this.proto.hasField(fd)) {
            return UndefinedData.INSTANCE;
        }
        return field.interpretField(this.proto, forceStringConversion);
    }

    public SoyValue getReadonlyProtoField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        Descriptors.FieldDescriptor fd = field.getDescriptor();
        if (fd.isRepeated() || fd.getJavaType() != Descriptors.FieldDescriptor.JavaType.MESSAGE) {
            throw new AssertionError((Object)"impossible");
        }
        return field.interpretField(this.proto);
    }

    public SoyValue getProtoFieldOrNull(String name) {
        return this.getProtoFieldOrNull(name, false);
    }

    public SoyValue getProtoFieldOrNull(String name, boolean forceStringConversion) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        Descriptors.FieldDescriptor fd = field.getDescriptor();
        if (fd.hasPresence() && !this.proto.hasField(fd)) {
            return UndefinedData.INSTANCE;
        }
        return field.interpretField(this.proto, forceStringConversion);
    }

    public boolean hasProtoField(String name) {
        FieldWithInterpreter field = (FieldWithInterpreter)this.clazz().fields.get((Object)name);
        if (field == null) {
            throw new IllegalArgumentException("Proto " + this.proto.getClass().getName() + " does not have a field of name " + name);
        }
        if (field.getDescriptor().isRepeated()) {
            throw new IllegalArgumentException("Cannot check for presence on repeated field " + name);
        }
        return this.proto.hasField(field.getDescriptor());
    }

    public void setAccessLocationKey(Object location) {
        this.locationKey = location;
    }

    @Override
    @Deprecated
    public boolean hasField(RecordProperty name) {
        this.asRecord();
        return false;
    }

    @Override
    @Deprecated
    public SoyValue getField(RecordProperty name) {
        this.asRecord();
        return null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getFieldProvider(RecordProperty name) {
        this.asRecord();
        return null;
    }

    @Override
    public ImmutableMap<String, SoyValueProvider> recordAsMap() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void forEach(BiConsumer<RecordProperty, ? super SoyValueProvider> action) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int recordSize() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Deprecated
    public int getItemCnt() {
        return this.getItemKeys().size();
    }

    @Deprecated
    public Collection<SoyValue> getItemKeys() {
        this.asMap();
        return ImmutableList.of();
    }

    @Override
    @Deprecated
    public boolean hasItem(SoyValue key) {
        this.asMap();
        return false;
    }

    @Override
    @Deprecated
    public SoyValue getItem(SoyValue key) {
        this.asMap();
        return null;
    }

    @Override
    @Deprecated
    public SoyValueProvider getItemProvider(SoyValue key) {
        this.asMap();
        return null;
    }

    private void asMap() {
        this.asDeprecatedType("map");
    }

    private void asRecord() {
        this.asDeprecatedType("record");
    }

    private void asDeprecatedType(String type) {
        Object locationKey = this.getAndClearLocationKey();
        ProtoClass clazz = this.clazz();
        if (locationKey == null) {
            Exception e = new Exception("bad proto access");
            Names.rewriteStackTrace(e);
            logger.log(Level.SEVERE, String.format("Accessing a proto of type %s (import {%s} from '%s';) as a %s is deprecated. Add static types to fix.", clazz.fullName, clazz.topLevelName, clazz.importPath, type), e);
        } else {
            logger.log(Level.SEVERE, String.format("Accessing a proto of type %s (import {%s} from '%s';) as a %s is deprecated. Add static types to fix.\n\t%s", clazz.fullName, clazz.topLevelName, clazz.importPath, type, locationKey), new Exception("bad proto access @" + String.valueOf(locationKey)));
        }
    }

    private Object getAndClearLocationKey() {
        Object key = this.locationKey;
        if (key != null) {
            this.locationKey = null;
        }
        return key;
    }

    @Override
    public boolean equals(Object other) {
        return other != null && this.getClass() == other.getClass() && this.proto == ((SoyProtoValue)other).proto;
    }

    @Override
    public boolean coerceToBoolean() {
        return true;
    }

    @Override
    public String coerceToString() {
        return this.proto.toString();
    }

    @Override
    public void render(LoggingAdvisingAppendable appendable) throws IOException {
        TextFormat.printer().print((MessageOrBuilder)this.proto, (Appendable)appendable);
    }

    @Override
    public SoyValue checkNullishProto(Class<? extends Message> messageType) {
        messageType.cast(this.proto);
        return this;
    }

    public String toString() {
        Object[] objectArray = new Object[2];
        objectArray[0] = this.proto.getDescriptorForType().getFullName();
        objectArray[1] = this.proto.equals((Object)this.proto.getDefaultInstanceForType()) ? (this.proto == this.proto.getDefaultInstanceForType() ? "empty(default)" : "empty") : "not-empty";
        return String.format("SoyProtoValue<%s, %s>", objectArray);
    }

    @Override
    public int hashCode() {
        return this.proto.hashCode();
    }

    public static final class Builder {
        private final ProtoClass clazz;
        private Message.Builder builder;

        public Builder(Descriptors.Descriptor soyProto) {
            this.clazz = (ProtoClass)classCache.getUnchecked((Object)soyProto);
        }

        private Message.Builder builder() {
            Message.Builder localBuilder = this.builder;
            if (localBuilder == null) {
                localBuilder = this.builder = this.clazz.defaultInstance.newBuilderForType();
            }
            return localBuilder;
        }

        @CanIgnoreReturnValue
        public Builder setField(String field, SoyValue value) {
            ((FieldWithInterpreter)this.clazz.fields.get((Object)field)).assignField(this.builder(), value);
            return this;
        }

        public SoyProtoValue build() {
            SoyProtoValue soyProtoValue = new SoyProtoValue(this.builder == null ? this.clazz.defaultInstance : this.builder.build());
            soyProtoValue.clazz = this.clazz;
            return soyProtoValue;
        }

        public boolean hasField(String field) {
            return this.clazz.fields.containsKey((Object)field);
        }
    }

    private static final class FieldWithInterpreter
    extends Field {
        @LazyInit
        ProtoFieldInterpreter interpreter;

        FieldWithInterpreter(Descriptors.FieldDescriptor fieldDesc) {
            super(fieldDesc);
        }

        private ProtoFieldInterpreter impl(boolean forceStringConversion) {
            ProtoFieldInterpreter local = this.interpreter;
            if (local == null) {
                local = ProtoFieldInterpreter.create(this.getDescriptor(), forceStringConversion);
            }
            return local;
        }

        public SoyValue interpretField(Message message) {
            return this.interpretField(message, false);
        }

        private SoyValue interpretField(Message message, boolean forceStringConversion) {
            return this.impl(forceStringConversion).soyFromProto(message.getField(this.getDescriptor()));
        }

        public void assignField(Message.Builder builder, SoyValue value) {
            builder.setField(this.getDescriptor(), this.impl(false).protoFromSoy(value));
        }
    }

    private static final class ProtoClass {
        final ImmutableMap<String, FieldWithInterpreter> fields;
        final Message defaultInstance;
        final String topLevelName;
        final String fullName;
        final String importPath;

        ProtoClass(Message defaultInstance, ImmutableMap<String, FieldWithInterpreter> fields) {
            this.fullName = defaultInstance.getDescriptorForType().getFullName();
            Descriptors.Descriptor d = defaultInstance.getDescriptorForType();
            while (d.getContainingType() != null) {
                d = d.getContainingType();
            }
            this.topLevelName = d.getName();
            this.importPath = defaultInstance.getDescriptorForType().getFile().getFullName();
            this.defaultInstance = (Message)Preconditions.checkNotNull((Object)defaultInstance);
            this.fields = (ImmutableMap)Preconditions.checkNotNull(fields);
        }
    }
}

