/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.common.base.Preconditions;
import com.google.template.soy.data.SoyLegacyObjectMap;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.SoyValueProvider;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.RuntimeMapTypeTracker;
import com.google.template.soy.data.internal.SoyMapImpl;
import java.util.HashMap;

public final class SoyMaps {
    public static boolean isMapOrLegacyObjectMap(SoyValue value) {
        return value instanceof SoyMap || value instanceof SoyLegacyObjectMap;
    }

    public static SoyMap asSoyMap(SoyValue map) {
        Preconditions.checkArgument((boolean)SoyMaps.isMapOrLegacyObjectMap(map));
        if (map instanceof SoyMapImpl || map instanceof DictImpl && ((DictImpl)map).getMapType() == RuntimeMapTypeTracker.Type.MAP) {
            return (SoyMap)map;
        }
        return SoyMaps.legacyObjectMapToMap((SoyLegacyObjectMap)map);
    }

    public static SoyMap legacyObjectMapToMap(SoyLegacyObjectMap map) {
        HashMap<SoyValue, SoyValueProvider> newMap = new HashMap<SoyValue, SoyValueProvider>();
        for (SoyValue soyValue : map.getItemKeys()) {
            newMap.put(soyValue, map.getItemProvider(soyValue));
        }
        return SoyMapImpl.forProviderMap(newMap);
    }
}

