/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.data;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.ForOverride;
import com.google.template.soy.data.AbstractLoggingAdvisingAppendable;
import com.google.template.soy.data.AutoValue_LoggingAdvisingAppendable_BufferingAppendable_LoggingFunctionCommand;
import com.google.template.soy.data.Dir;
import com.google.template.soy.data.ForwardingLoggingAdvisingAppendable;
import com.google.template.soy.data.LogStatement;
import com.google.template.soy.data.LoggingFunctionInvocation;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.api.AdvisingAppendable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public abstract class LoggingAdvisingAppendable
implements AdvisingAppendable {
    @Nullable
    private SanitizedContent.ContentKind kind;
    @Nullable
    private Dir contentDir;

    @Nonnull
    public static BufferingAppendable buffering() {
        return new BufferingAppendable();
    }

    public static LoggingAdvisingAppendable delegating(Appendable appendable) {
        return new DelegatingToAppendable<Appendable>(appendable);
    }

    @Nonnull
    public static LoggingAdvisingAppendable stringCoercing(LoggingAdvisingAppendable delegate) {
        return new StringCoercingAppendable(delegate);
    }

    @Override
    @Nonnull
    public abstract LoggingAdvisingAppendable append(CharSequence var1) throws IOException;

    @Override
    @Nonnull
    public abstract LoggingAdvisingAppendable append(CharSequence var1, int var2, int var3) throws IOException;

    @Override
    @Nonnull
    public abstract LoggingAdvisingAppendable append(char var1) throws IOException;

    @Nonnull
    public abstract LoggingAdvisingAppendable enterLoggableElement(LogStatement var1);

    @Nonnull
    public abstract LoggingAdvisingAppendable exitLoggableElement();

    public abstract void flushBuffers(int var1) throws IOException;

    @Nonnull
    @CanIgnoreReturnValue
    public final LoggingAdvisingAppendable setKindAndDirectionality(SanitizedContent.ContentKind kind) throws IOException {
        if (this.kind == null) {
            this.kind = kind;
            Dir direction = this.contentDir = kind.getDefaultDir();
            this.notifyKindAndDirectionality(kind, direction);
        }
        return this;
    }

    @Nonnull
    @CanIgnoreReturnValue
    public final LoggingAdvisingAppendable setKindAndDirectionality(SanitizedContent.ContentKind kind, @Nullable Dir direction) throws IOException {
        Preconditions.checkNotNull((Object)((Object)kind));
        if (this.kind == null) {
            this.kind = kind;
            this.contentDir = direction;
            this.notifyKindAndDirectionality(kind, direction);
        }
        return this;
    }

    @ForOverride
    protected void notifyKindAndDirectionality(SanitizedContent.ContentKind kind, @Nullable Dir direction) throws IOException {
    }

    @Nullable
    public final SanitizedContent.ContentKind getSanitizedContentKind() {
        return this.kind;
    }

    @Nullable
    public final Dir getSanitizedContentDirectionality() {
        return this.contentDir;
    }

    @Nonnull
    public abstract LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation var1, ImmutableList<Function<String, String>> var2) throws IOException;

    protected static String escapePlaceholder(String placeholder, List<Function<String, String>> escapers) {
        for (Function<String, String> escaper : escapers) {
            placeholder = escaper.apply(placeholder);
        }
        return placeholder;
    }

    public static final class BufferingAppendable
    extends DelegatingToAppendable<StringBuilder> {
        private static final Object EXIT_LOG_STATEMENT_MARKER = new Object();
        private List<Object> commands;

        BufferingAppendable() {
            super(new StringBuilder());
        }

        private List<Object> getCommandsAndAddPendingStringData() {
            StringBuilder delegate;
            List<Object> commands = this.commands;
            if (commands == null) {
                this.commands = commands = new ArrayList<Object>();
            }
            if ((delegate = (StringBuilder)this.delegate).length() != 0) {
                commands.add(delegate.toString());
                delegate.setLength(0);
            }
            return commands;
        }

        @Override
        protected void doEnterLoggableElement(LogStatement statement) {
            this.getCommandsAndAddPendingStringData().add(statement);
        }

        @Override
        protected void doExitLoggableElement() {
            this.getCommandsAndAddPendingStringData().add(EXIT_LOG_STATEMENT_MARKER);
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) {
            this.getCommandsAndAddPendingStringData().add(LoggingFunctionCommand.create(funCall, escapers));
        }

        public void replayOn(LoggingAdvisingAppendable appendable) throws IOException {
            if (this.getSanitizedContentKind() != null) {
                appendable.setKindAndDirectionality(this.getSanitizedContentKind(), this.getSanitizedContentDirectionality());
            }
            if (this.commands != null) {
                for (Object o : this.getCommandsAndAddPendingStringData()) {
                    if (o instanceof String) {
                        appendable.append((String)o);
                        continue;
                    }
                    if (o instanceof LoggingFunctionCommand) {
                        ((LoggingFunctionCommand)o).replayOn(appendable);
                        continue;
                    }
                    if (o == EXIT_LOG_STATEMENT_MARKER) {
                        appendable.exitLoggableElement();
                        continue;
                    }
                    if (o instanceof LogStatement) {
                        appendable.enterLoggableElement((LogStatement)o);
                        continue;
                    }
                    throw new AssertionError((Object)("unexpected command object: " + String.valueOf(o)));
                }
            } else {
                appendable.append((CharSequence)((Object)this.delegate));
            }
        }

        @VisibleForTesting
        public String getAndClearBuffer() {
            if (this.commands != null) {
                BufferingAppendable.appendCommandsToBuilder(this.getCommandsAndAddPendingStringData(), (StringBuilder)this.delegate);
                this.commands = null;
            }
            String value = ((StringBuilder)this.delegate).toString();
            ((StringBuilder)this.delegate).setLength(0);
            return value;
        }

        public SoyValue getAsSoyValue() {
            return this.getSanitizedContentKind() == SanitizedContent.ContentKind.TEXT || this.getSanitizedContentKind() == null ? StringData.forValue(this.toString()) : SanitizedContent.create(this.toString(), this.getSanitizedContentKind(), this.getSanitizedContentDirectionality());
        }

        public String toString() {
            if (this.commands != null) {
                StringBuilder builder = new StringBuilder();
                BufferingAppendable.appendCommandsToBuilder(this.commands, builder);
                builder.append((CharSequence)((Object)this.delegate));
                return builder.toString();
            }
            return ((StringBuilder)this.delegate).toString();
        }

        private static void appendCommandsToBuilder(List<Object> commands, StringBuilder builder) {
            for (Object o : commands) {
                if (o instanceof String) {
                    builder.append((String)o);
                    continue;
                }
                if (!(o instanceof LoggingFunctionCommand)) continue;
                LoggingFunctionCommand command = (LoggingFunctionCommand)o;
                builder.append(BufferingAppendable.escapePlaceholder(command.fn().placeholderValue(), command.escapers()));
            }
        }

        @AutoValue
        static abstract class LoggingFunctionCommand {
            LoggingFunctionCommand() {
            }

            static LoggingFunctionCommand create(LoggingFunctionInvocation fn, ImmutableList<Function<String, String>> escapers) {
                return new AutoValue_LoggingAdvisingAppendable_BufferingAppendable_LoggingFunctionCommand(fn, escapers);
            }

            abstract LoggingFunctionInvocation fn();

            abstract ImmutableList<Function<String, String>> escapers();

            LoggingAdvisingAppendable replayOn(LoggingAdvisingAppendable appendable) throws IOException {
                return appendable.appendLoggingFunctionInvocation(this.fn(), this.escapers());
            }
        }
    }

    private static class DelegatingToAppendable<T extends Appendable>
    extends AbstractLoggingAdvisingAppendable {
        final T delegate;

        private DelegatingToAppendable(T delegate) {
            this.delegate = (Appendable)Preconditions.checkNotNull(delegate);
        }

        @Override
        protected final void doAppend(CharSequence s) throws IOException {
            this.delegate.append(s);
        }

        @Override
        protected final void doAppend(CharSequence s, int start, int end) throws IOException {
            this.delegate.append(s, start, end);
        }

        @Override
        protected final void doAppend(char c) throws IOException {
            this.delegate.append(c);
        }

        @Override
        protected void doAppendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) {
            DelegatingToAppendable.escapePlaceholder(funCall.placeholderValue(), escapers);
        }

        @Override
        protected void doEnterLoggableElement(LogStatement statement) {
        }

        @Override
        protected void doExitLoggableElement() {
        }

        @Override
        public boolean softLimitReached() {
            return false;
        }

        @Override
        public void flushBuffers(int depth) {
            throw new AssertionError((Object)"should not be called");
        }
    }

    private static final class StringCoercingAppendable
    extends ForwardingLoggingAdvisingAppendable {
        StringCoercingAppendable(LoggingAdvisingAppendable delegate) {
            super(delegate);
        }

        @Override
        public LoggingAdvisingAppendable enterLoggableElement(LogStatement statement) {
            return this;
        }

        @Override
        public LoggingAdvisingAppendable exitLoggableElement() {
            return this;
        }

        @Override
        public LoggingAdvisingAppendable appendLoggingFunctionInvocation(LoggingFunctionInvocation funCall, ImmutableList<Function<String, String>> escapers) throws IOException {
            return this.append(StringCoercingAppendable.escapePlaceholder(funCall.placeholderValue(), escapers));
        }
    }
}

