/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.css;

import com.google.common.base.CaseFormat;
import com.google.common.collect.Streams;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Objects;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class CssPrefixUtil {
    private CssPrefixUtil() {
    }

    @Nullable
    public static String getNamespacePrefix(SoyFileNode file) {
        if (file.getCssPrefix() != null) {
            return file.getCssPrefix();
        }
        if (file.getCssBaseNamespace() != null) {
            return CssPrefixUtil.toCamelCase(file.getCssBaseNamespace());
        }
        if (!file.getRequiredCssNamespaces().isEmpty()) {
            return CssPrefixUtil.toCamelCase((String)file.getRequiredCssNamespaces().get(0));
        }
        return null;
    }

    @Nullable
    public static String getTemplatePrefix(TemplateNode template, @Nullable String namespacePrefix) {
        if (template.getCssBaseNamespace() != null) {
            return CssPrefixUtil.toCamelCase(template.getCssBaseNamespace());
        }
        return namespacePrefix;
    }

    public static String getTemplatePrefix(TemplateNode template) {
        return CssPrefixUtil.getTemplatePrefix(template, CssPrefixUtil.getNamespacePrefix(template.getNearestAncestor(SoyFileNode.class)));
    }

    public static Stream<String> getRequiredCssSymbols(TemplateNode template) {
        SoyFileNode fileNode = template.getNearestAncestor(SoyFileNode.class);
        return Streams.concat((Stream[])new Stream[]{template.getRequiredCssNamespaces().stream(), fileNode.getRequiredCssNamespaces().stream(), fileNode.getRequiredCssPaths().stream().map(cssPath -> {
            if (cssPath.resolvedPath().isPresent()) {
                return cssPath.resolvedPath().get();
            }
            return null;
        }).filter(Objects::nonNull)});
    }

    private static String toCamelCase(String packageName) {
        String packageNameWithDashes = packageName.replace('.', '-');
        return CaseFormat.LOWER_HYPHEN.to(CaseFormat.LOWER_CAMEL, packageNameWithDashes);
    }
}

