/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.conformance.RuleWithExemptions;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayList;

public final class SoyConformance {
    private final ImmutableList<RuleWithExemptions> rules;

    public static SoyConformance create(ValidatedConformanceConfig conformanceConfig) {
        return new SoyConformance(conformanceConfig.getRules());
    }

    SoyConformance(ImmutableList<RuleWithExemptions> rules) {
        this.rules = rules;
    }

    public void check(SoyFileNode file, ErrorReporter errorReporter) {
        ArrayList<Rule<? extends Node>> rulesForFile = new ArrayList<Rule<? extends Node>>(this.rules.size());
        SourceLogicalPath filePath = file.getFilePath().asLogicalPath();
        for (RuleWithExemptions rule : this.rules) {
            if (!rule.shouldCheckConformanceFor(filePath.path())) continue;
            rulesForFile.add(rule.getRule());
        }
        if (rulesForFile.isEmpty()) {
            return;
        }
        SoyTreeUtils.allNodes(file).forEach(node -> {
            for (Rule rule : rulesForFile) {
                rule.checkConformance((Node)node, errorReporter);
            }
        });
    }
}

