/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlAttributeNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.Collection;

final class BannedHtmlTag
extends Rule<HtmlOpenTagNode> {
    private final ImmutableSet<String> bannedTagNames;
    private final ImmutableSet<String> bannedPossiblyPresentAttributes;
    private final ImmutableSet<String> bannedPossiblyMissingAttributes;

    BannedHtmlTag(Collection<String> bannedTagNames, Collection<String> bannedPossiblyPresentAttributes, Collection<String> bannedPossiblyMissingAttributes, SoyErrorKind error) {
        super(error);
        this.bannedTagNames = (ImmutableSet)bannedTagNames.stream().map(Ascii::toLowerCase).collect(ImmutableSet.toImmutableSet());
        this.bannedPossiblyPresentAttributes = (ImmutableSet)bannedPossiblyPresentAttributes.stream().map(Ascii::toLowerCase).collect(ImmutableSet.toImmutableSet());
        this.bannedPossiblyMissingAttributes = (ImmutableSet)bannedPossiblyMissingAttributes.stream().map(Ascii::toLowerCase).collect(ImmutableSet.toImmutableSet());
    }

    @Override
    protected void doCheckConformance(HtmlOpenTagNode node, ErrorReporter errorReporter) {
        if (this.hasConformanceError(node)) {
            errorReporter.report(node.getSourceLocation(), this.error, new Object[0]);
        }
    }

    private boolean hasConformanceError(HtmlOpenTagNode node) {
        boolean isBannedTag = this.isBannedTag(node);
        if (!isBannedTag) {
            return false;
        }
        if (this.bannedPossiblyPresentAttributes.isEmpty() && this.bannedPossiblyMissingAttributes.isEmpty()) {
            return true;
        }
        boolean containsBannedAttributes = !this.bannedPossiblyPresentAttributes.isEmpty() && BannedHtmlTag.hasAllAttributes(node, this.bannedPossiblyPresentAttributes);
        boolean containsMissingAttributes = !this.bannedPossiblyMissingAttributes.isEmpty() && !BannedHtmlTag.hasAllAttributes(node, this.bannedPossiblyMissingAttributes);
        return containsBannedAttributes || containsMissingAttributes;
    }

    private boolean isBannedTag(HtmlOpenTagNode node) {
        return node.getTagName().isStatic() && this.bannedTagNames.contains((Object)node.getTagName().getStaticTagNameAsLowerCase());
    }

    private static boolean hasAllAttributes(HtmlOpenTagNode node, ImmutableSet<String> attributes) {
        return attributes.stream().allMatch(attrName -> SoyTreeUtils.allNodesOfType(node, HtmlAttributeNode.class).anyMatch(attr -> attr.definitelyMatchesAttributeName((String)attrName)));
    }
}

