/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.FunctionNode;

final class BannedFunction
extends Rule<FunctionNode> {
    private final ImmutableSet<String> bannedFunctions;

    BannedFunction(ImmutableSet<String> bannedFunctions, SoyErrorKind error) {
        super(error);
        this.bannedFunctions = bannedFunctions;
    }

    @Override
    protected void doCheckConformance(FunctionNode node, ErrorReporter errorReporter) {
        Object functImpl;
        String functionStr = node.getFunctionName();
        if (functionStr.isEmpty() && node.isResolved() && (functImpl = node.getSoyFunction()) instanceof FunctionNode.ExternRef) {
            functionStr = BannedFunction.externStringRepresentation((FunctionNode.ExternRef)functImpl);
        }
        if (!functionStr.isEmpty() && this.bannedFunctions.contains((Object)functionStr)) {
            errorReporter.report(node.getSourceLocation(), this.error, new Object[0]);
        }
    }

    static String externStringRepresentation(FunctionNode.ExternRef ref) {
        return String.format("{%s} from '%s'", ref.name(), ref.path().path());
    }
}

