/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.io.FileWriteMode;
import com.google.common.io.Files;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.SoyMsgPlugin;
import com.google.template.soy.xliffmsgplugin.XliffMsgPlugin;
import java.io.File;
import org.kohsuke.args4j.Option;

public final class SoyMsgExtractor
extends AbstractSoyCompiler {
    @Option(name="--outputFile", required=true, usage="The path to the output file to write. If a file already exists at this location, it will be overwritten. The file extension must match the output format requested.")
    private File outputFile;
    @Option(name="--sourceLocaleString", usage="The locale string of the source language (default 'en').")
    private String sourceLocaleString = "en";
    @Option(name="--targetLocaleString", usage="The locale string of the target language (default empty). If empty, then the output messages file will not specify a target locale string. Note that this option may not be applicable for certain message plugins (in which case this value will be ignored by the message plugin).")
    private String targetLocaleString = "";
    @Option(name="--messagePlugin", usage="Specifies the full class name of a SoyMsgPlugin.  If not specified, the default is com.google.template.soy.xliffmsgplugin.XliffMsgPlugin.")
    private SoyMsgPlugin messagePlugin = new XliffMsgPlugin();

    public static void main(String ... args) {
        new SoyMsgExtractor().runMain(args);
    }

    SoyMsgExtractor(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyMsgExtractor() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) {
        SoyFileSet sfs = sfsBuilder.build();
        SoyMsgBundleHandler.OutputFileOptions options = new SoyMsgBundleHandler.OutputFileOptions();
        options.setSourceLocaleString(this.sourceLocaleString);
        if (this.targetLocaleString.length() > 0) {
            options.setTargetLocaleString(this.targetLocaleString);
        }
        sfs.extractAndWriteMsgs(new SoyMsgBundleHandler(this.messagePlugin), options, Files.asByteSink((File)this.outputFile, (FileWriteMode[])new FileWriteMode[0]));
    }
}

