/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.common.collect.Iterables;
import com.google.template.soy.AbstractSoyCompiler;
import com.google.template.soy.PluginLoader;
import com.google.template.soy.SoyFileSet;
import com.google.template.soy.SoyInputCache;
import com.google.template.soy.css.CssMetadata;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import com.google.template.soy.soytree.TemplateMetadataSerializer;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.templatecall.TemplateCallMetadata;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.zip.GZIPOutputStream;
import org.kohsuke.args4j.Option;

final class SoyHeaderCompiler
extends AbstractSoyCompiler {
    private static final int OUTPUT_STREAM_BUFFER_SIZE = 65536;
    @Option(name="--output", required=true, usage="[Required] The file name of the output file to be written.  Each compiler invocation will produce exactly one file containing all the TemplateMetadata")
    private File output;
    @Option(name="--cssMetadataOutput", usage="Where to write metadata about CSS.  This will be a file containing a gzipped CssMetadata proto")
    private File cssMetadataOutput = null;
    @Option(name="--templateCallMetadataOutput", usage="Where to write metadata about the template calls.  This will be a file containing a gzipped TemplateCallMetadata proto")
    private File templateCallMetadataOutput = null;

    SoyHeaderCompiler(PluginLoader loader, SoyInputCache cache) {
        super(loader, cache);
    }

    SoyHeaderCompiler() {
    }

    @Override
    protected void compile(SoyFileSet.Builder sfsBuilder) throws IOException {
        SoyFileSet.HeaderResult result = sfsBuilder.build().compileMinimallyForHeaders();
        CompilationUnit unit = TemplateMetadataSerializer.compilationUnitFromFileSet(result.fileSet(), result.templateRegistry());
        try (GZIPOutputStream os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.output), 65536);){
            unit.writeTo(os);
        }
        if (this.cssMetadataOutput != null) {
            os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.cssMetadataOutput), 65536);
            try {
                SoyHeaderCompiler.calculateCssMetadata(result.fileSet(), result.cssRegistry()).writeTo(os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
        if (this.templateCallMetadataOutput != null) {
            os = new GZIPOutputStream((OutputStream)new FileOutputStream(this.templateCallMetadataOutput), 65536);
            try {
                SoyHeaderCompiler.calculateTemplateCallMetadata(result.fileSet()).writeTo(os);
            }
            finally {
                ((OutputStream)os).close();
            }
        }
    }

    private static CssMetadata calculateCssMetadata(SoyFileSetNode fileSet, CssRegistry cssRegistry) {
        LinkedHashSet<String> requiredCssNames = new LinkedHashSet<String>();
        LinkedHashSet<String> requiredCssPaths = new LinkedHashSet<String>();
        LinkedHashSet<String> cssNamesFromPath = new LinkedHashSet<String>();
        for (SoyFileNode file : fileSet.getChildren()) {
            requiredCssNames.addAll((Collection<String>)file.getRequiredCssNamespaces());
            for (SoyFileNode.CssPath cssPath : file.getAllRequiredCssPaths()) {
                cssPath.resolvedPath().ifPresent(path -> {
                    requiredCssPaths.add((String)path);
                    if (cssPath.getNamespace() != null) {
                        cssNamesFromPath.add(cssPath.getNamespace());
                    }
                });
            }
            for (TemplateNode template : file.getTemplates()) {
                requiredCssNames.addAll((Collection<String>)template.getRequiredCssNamespaces());
            }
        }
        LinkedHashSet<String> cssClassNames = new LinkedHashSet<String>();
        SoyTreeUtils.allFunctionInvocations(fileSet, BuiltinFunction.CSS).forEach(fn -> cssClassNames.add(((StringNode)Iterables.getLast(fn.getChildren())).getValue()));
        return CssMetadata.newBuilder().addAllRequireCssNames(requiredCssNames).addAllRequireCssNames(cssNamesFromPath).addAllRequireCssPaths(requiredCssPaths).addAllRequireCssPathsFromNamespaces(requiredCssNames.stream().map(cssRegistry::getLfpmeForSymbol).filter(Objects::nonNull).collect(Collectors.toList())).addAllCssClassNames(cssClassNames).build();
    }

    private static TemplateCallMetadata calculateTemplateCallMetadata(SoyFileSetNode fileSet) {
        TemplateCallMetadata.Builder templateCallMetadata = TemplateCallMetadata.newBuilder();
        for (SoyFileNode file : fileSet.getChildren()) {
            for (TemplateNode template : file.getTemplates()) {
                templateCallMetadata.addTemplates(template.getTemplateCallMetadata());
            }
        }
        return templateCallMetadata.build();
    }

    public static void main(String[] args) {
        new SoyHeaderCompiler().runMain(args);
    }
}

