/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy;

import com.google.auto.value.AutoValue;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import com.google.common.collect.Iterables;
import com.google.common.io.ByteSink;
import com.google.common.io.CharSource;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.protobuf.Descriptors;
import com.google.template.soy.AutoValue_SoyFileSet_AnalysisResult;
import com.google.template.soy.AutoValue_SoyFileSet_HeaderResult;
import com.google.template.soy.SoyFileSetParser;
import com.google.template.soy.base.SourceFilePath;
import com.google.template.soy.base.SourceLogicalPath;
import com.google.template.soy.base.internal.KytheMode;
import com.google.template.soy.base.internal.SoyFileKind;
import com.google.template.soy.base.internal.SoyFileSupplier;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.css.CssRegistry;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyCompilationException;
import com.google.template.soy.error.SoyError;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.error.SoyInternalCompilerException;
import com.google.template.soy.incrementaldomsrc.IncrementalDomInteropSrcMain;
import com.google.template.soy.incrementaldomsrc.IncrementalDomSrcMain;
import com.google.template.soy.incrementaldomsrc.SoyIncrementalDomSrcOptions;
import com.google.template.soy.javagencode.GenerateBuildersVisitor;
import com.google.template.soy.javagencode.GenerateParseInfoVisitor;
import com.google.template.soy.jbcsrc.BytecodeCompiler;
import com.google.template.soy.jbcsrc.api.SoySauce;
import com.google.template.soy.jbcsrc.api.SoySauceImpl;
import com.google.template.soy.jbcsrc.shared.CompiledTemplates;
import com.google.template.soy.jssrc.SoyJsSrcOptions;
import com.google.template.soy.jssrc.internal.JsSrcMain;
import com.google.template.soy.msgs.SoyMsgBundle;
import com.google.template.soy.msgs.SoyMsgBundleHandler;
import com.google.template.soy.msgs.internal.ExtractMsgsVisitor;
import com.google.template.soy.passes.CheckTemplateHeaderVarsPass;
import com.google.template.soy.passes.ClearSoyDocStringsVisitor;
import com.google.template.soy.passes.PassManager;
import com.google.template.soy.passes.PluginResolver;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.plugin.internal.PluginValidator;
import com.google.template.soy.plugin.internal.SoySourceFunctionDescriptor;
import com.google.template.soy.plugin.java.MethodChecker;
import com.google.template.soy.plugin.java.PluginInstances;
import com.google.template.soy.plugin.java.ReflectiveMethodChecker;
import com.google.template.soy.plugin.restricted.SoySourceFunction;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.PySrcMain;
import com.google.template.soy.shared.SoyAstCache;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.ToggleRegistry;
import com.google.template.soy.shared.internal.InternalPlugins;
import com.google.template.soy.shared.internal.SoyScopedData;
import com.google.template.soy.shared.internal.SoySimpleScope;
import com.google.template.soy.shared.internal.gencode.GeneratedFile;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyFunctionSignature;
import com.google.template.soy.shared.restricted.SoyMethodSignature;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.CompilationUnit;
import com.google.template.soy.soytree.FileSetMetadata;
import com.google.template.soy.soytree.Metadata;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.tofu.SoyTofu;
import com.google.template.soy.tofu.internal.BaseTofu;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypeRegistryBuilder;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nullable;

public final class SoyFileSet {
    private static final Logger logger = Logger.getLogger(SoyFileSet.class.getName());
    private final SoyScopedData scopedData;
    private final SoyTypeRegistry typeRegistry;
    private final ImmutableMap<SourceLogicalPath, SoyFileSupplier> soyFileSuppliers;
    private final ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits;
    @Nullable
    private final SoyAstCache cache;
    private final SoyGeneralOptions generalOptions;
    private final ValidatedConformanceConfig conformanceConfig;
    private final ImmutableList<File> pluginRuntimeJars;
    private final CssRegistry cssRegistry;
    private final ToggleRegistry toggleRegistry;
    private final ImmutableList<SoyFunction> soyFunctions;
    private final ImmutableList<SoyPrintDirective> printDirectives;
    private final ImmutableList<SoySourceFunctionDescriptor> soySourceFunctions;
    private final ImmutableList<SoySourceFunction> soyMethods;
    private final boolean skipPluginValidation;
    private final boolean optimize;
    private final ImmutableSet<SourceLogicalPath> generatedPathsToCheck;
    private final MethodChecker javaMethodChecker;
    private ErrorReporter errorReporter;
    @Nullable
    private final Appendable warningSink;
    private boolean isCompiling;

    @Deprecated
    public static Builder builder() {
        return new Builder(true);
    }

    SoyFileSet(SoyScopedData apiCallScopeProvider, SoyTypeRegistry typeRegistry, ImmutableList<SoyFunction> soyFunctions, ImmutableList<SoyPrintDirective> printDirectives, ImmutableList<SoySourceFunctionDescriptor> soySourceFunctions, ImmutableList<SoySourceFunction> soyMethods, ImmutableMap<SourceLogicalPath, SoyFileSupplier> soyFileSuppliers, ImmutableList<Metadata.CompilationUnitAndKind> compilationUnits, SoyGeneralOptions generalOptions, @Nullable SoyAstCache cache, ValidatedConformanceConfig conformanceConfig, @Nullable Appendable warningSink, ImmutableList<File> pluginRuntimeJars, boolean skipPluginValidation, boolean optimize, Set<SourceLogicalPath> generatedPathsToCheck, CssRegistry cssRegistry, ToggleRegistry toggleRegistry, MethodChecker javaMethodChecker) {
        this.scopedData = apiCallScopeProvider;
        this.typeRegistry = typeRegistry;
        this.soyFileSuppliers = soyFileSuppliers;
        this.compilationUnits = compilationUnits;
        this.cache = cache;
        this.generalOptions = generalOptions.clone();
        this.soyFunctions = InternalPlugins.filterDuplicateFunctions(soyFunctions);
        this.printDirectives = InternalPlugins.filterDuplicateDirectives(printDirectives);
        this.soySourceFunctions = soySourceFunctions;
        this.soyMethods = soyMethods;
        this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
        this.warningSink = warningSink;
        this.pluginRuntimeJars = pluginRuntimeJars;
        this.skipPluginValidation = skipPluginValidation;
        this.optimize = optimize;
        this.generatedPathsToCheck = ImmutableSet.copyOf(generatedPathsToCheck);
        this.cssRegistry = cssRegistry;
        this.toggleRegistry = toggleRegistry;
        this.javaMethodChecker = javaMethodChecker;
    }

    @VisibleForTesting
    ImmutableMap<SourceLogicalPath, SoyFileSupplier> getSoyFileSuppliersForTesting() {
        return this.soyFileSuppliers;
    }

    ImmutableList<SourceLogicalPath> getSourceFilePaths() {
        return this.soyFileSuppliers.keySet().asList();
    }

    @VisibleForTesting
    SoyTypeRegistry getTypeRegistryForTesting() {
        return this.typeRegistry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> T entryPoint(Supplier<T> variant) {
        SoyFileSet soyFileSet = this;
        synchronized (soyFileSet) {
            if (this.isCompiling) {
                logger.log(Level.SEVERE, "concurrent use of a SoyFileSet object is undefined behavior.", new Exception());
            }
            this.isCompiling = true;
        }
        this.resetErrorReporter();
        try {
            T rv = variant.get();
            this.throwIfErrorsPresent();
            this.reportWarnings();
            T t = rv;
            return t;
        }
        catch (SoyCompilationException | SoyInternalCompilerException e) {
            throw e;
        }
        catch (RuntimeException e) {
            if (this.errorReporter.hasErrorsOrWarnings()) {
                throw new SoyInternalCompilerException(Iterables.concat(this.errorReporter.getErrors(), this.errorReporter.getWarnings()), (Throwable)e);
            }
            throw e;
        }
        finally {
            SoyFileSet soyFileSet2 = this;
            synchronized (soyFileSet2) {
                this.isCompiling = false;
            }
        }
    }

    private void entryPointVoid(Runnable variant) {
        Object unused = this.entryPoint(() -> {
            variant.run();
            return null;
        });
    }

    ImmutableList<GeneratedFile> generateBuilders(String javaPackage, KytheMode kytheMode) {
        return this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parseWithoutOptimizingOrDesugaringHtml();
            this.throwIfErrorsPresent();
            SoyFileSetNode soyTree = result.fileSet();
            return new GenerateBuildersVisitor(this.errorReporter, javaPackage, kytheMode, result.registry()).exec(soyTree);
        });
    }

    ImmutableList<GeneratedFile> generateParseInfo(String javaPackage, KytheMode kytheMode, String javaClassNameSource) {
        return this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parseWithoutOptimizingOrDesugaringHtml();
            this.throwIfErrorsPresent();
            SoyFileSetNode soyTree = result.fileSet();
            FileSetMetadata registry = result.registry();
            return new GenerateParseInfoVisitor(javaPackage, kytheMode, javaClassNameSource, registry).exec(soyTree);
        });
    }

    String validateUserPlugins(boolean validateJavaImpls, boolean translateToTsx) {
        Preconditions.checkArgument((!translateToTsx || validateJavaImpls ? 1 : 0) != 0);
        return this.entryPoint(() -> {
            new PluginResolver(PluginResolver.Mode.REQUIRE_DEFINITIONS, (List<SoyPrintDirective>)this.printDirectives, (List<SoyFunction>)this.soyFunctions, (List<SoySourceFunctionDescriptor>)this.soySourceFunctions, (List<SoySourceFunction>)this.soyMethods, this.errorReporter);
            this.throwIfErrorsPresent();
            if (validateJavaImpls) {
                ImmutableList userSuppliedFunctions = (ImmutableList)this.soySourceFunctions.stream().filter(desc -> !desc.isInternal()).map(SoySourceFunctionDescriptor::soySourceFunction).collect(ImmutableList.toImmutableList());
                new PluginValidator(this.errorReporter, this.typeRegistry, (List<File>)this.pluginRuntimeJars).validate((Iterable<SoySourceFunction>)userSuppliedFunctions);
                this.throwIfErrorsPresent();
            }
            return "";
        });
    }

    void checkConformance() {
        this.entryPointVoid(() -> this.parse(this.passManagerBuilder().allowUnknownJsGlobals().astRewrites(PassManager.AstRewrites.KYTHE).desugarHtmlNodes(false).optimize(false).addHtmlAttributesForDebugging(false).addPassContinuationRule(SoyConformancePass.class, PassManager.PassContinuationRule.STOP_AFTER_PASS).validateJavaMethods(false)));
    }

    @Deprecated
    public SoyMsgBundle extractMsgs() {
        return this.entryPoint(this::doExtractMsgs);
    }

    void extractAndWriteMsgs(SoyMsgBundleHandler msgBundleHandler, SoyMsgBundleHandler.OutputFileOptions options, ByteSink output) {
        this.entryPointVoid(() -> {
            SoyMsgBundle bundle = this.doExtractMsgs();
            try {
                msgBundleHandler.writeExtractedMsgs(bundle, options, output, this.errorReporter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private SoyMsgBundle doExtractMsgs() {
        SoyFileSetNode soyTree = this.parse(this.passManagerBuilder().allowUnknownGlobals().allowUnknownJsGlobals().optimize(false).desugarHtmlNodes(false).validateJavaMethods(false)).fileSet();
        this.throwIfErrorsPresent();
        SoyMsgBundle bundle = new ExtractMsgsVisitor(this.errorReporter).exec(soyTree);
        this.throwIfErrorsPresent();
        return bundle;
    }

    @Deprecated
    public SoyTofu compileToTofu() {
        return this.compileToTofu((Map<String, ? extends Supplier<Object>>)ImmutableMap.of());
    }

    @Deprecated
    public SoyTofu compileToTofu(Map<String, ? extends Supplier<Object>> pluginInstances) {
        return this.entryPoint(() -> {
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            this.throwIfErrorsPresent();
            return this.doCompileToTofu(primitives, pluginInstances);
        });
    }

    private SoyTofu doCompileToTofu(ServerCompilationPrimitives primitives, Map<String, ? extends Supplier<Object>> pluginInstances) {
        return new BaseTofu(this.scopedData.enterable(), primitives.soyTree, PluginInstances.of(pluginInstances));
    }

    public SoySauce compileTemplates() {
        return this.compileTemplates((Map<String, ? extends Supplier<Object>>)ImmutableMap.of());
    }

    public SoySauce compileTemplates(Map<String, ? extends Supplier<Object>> pluginInstances) {
        return this.entryPoint(() -> {
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            this.throwIfErrorsPresent();
            return this.doCompileSoySauce(primitives, PluginInstances.of(pluginInstances));
        });
    }

    public CssRegistry getCssRegistry() {
        return this.cssRegistry;
    }

    void compileToJar(ByteSink jarTarget, Optional<ByteSink> srcJarTarget) {
        this.entryPointVoid(() -> {
            ServerCompilationPrimitives primitives = this.compileForServerRendering();
            try {
                BytecodeCompiler.compileToJar(primitives.soyTree, this.errorReporter, this.typeRegistry, jarTarget, primitives.registry);
                if (srcJarTarget.isPresent()) {
                    BytecodeCompiler.writeSrcJar(primitives.soyTree, this.soyFileSuppliers, (ByteSink)srcJarTarget.get());
                }
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    private SoySauce doCompileSoySauce(ServerCompilationPrimitives primitives, PluginInstances pluginInstances) {
        Optional<CompiledTemplates> templates = BytecodeCompiler.compile(primitives.registry, primitives.soyTree, this.errorReporter, this.soyFileSuppliers, this.typeRegistry);
        this.throwIfErrorsPresent();
        return new SoySauceImpl(templates.get(), this.soyFunctions, this.printDirectives, pluginInstances);
    }

    private ServerCompilationPrimitives compileForServerRendering() {
        SoyFileSetParser.ParseResult result = this.parse();
        this.throwIfErrorsPresent();
        SoyFileSetNode soyTree = result.fileSet();
        FileSetMetadata registry = result.registry();
        if (this.cache == null) {
            new ClearSoyDocStringsVisitor().exec(soyTree);
        }
        this.throwIfErrorsPresent();
        return new ServerCompilationPrimitives(registry, soyTree);
    }

    @Deprecated
    public List<String> compileToJsSrc(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        return this.compileToJsSrcInternal(jsSrcOptions, msgBundle);
    }

    List<String> compileToJsSrcInternal(SoyJsSrcOptions jsSrcOptions, @Nullable SoyMsgBundle msgBundle) {
        return this.entryPoint(() -> {
            PassManager.Builder builder = this.passManagerBuilder().allowUnknownJsGlobals().desugarHtmlNodes(false).validateJavaMethods(false);
            SoyFileSetParser.ParseResult result = this.parse(builder);
            this.throwIfErrorsPresent();
            FileSetMetadata registry = result.registry();
            SoyFileSetNode fileSet = result.fileSet();
            return new JsSrcMain(this.scopedData.enterable(), this.typeRegistry).genJsSrc(fileSet, registry, jsSrcOptions, msgBundle, this.errorReporter);
        });
    }

    List<String> compileToIncrementalDomSrcInternal(SoyIncrementalDomSrcOptions jsSrcOptions) {
        return this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder().desugarHtmlNodes(false).allowUnknownJsGlobals().desugarIdomFeatures(false).validateJavaMethods(false));
            this.throwIfErrorsPresent();
            return new IncrementalDomSrcMain(this.scopedData.enterable(), this.typeRegistry).genJsSrc(result.fileSet(), result.registry(), jsSrcOptions, this.errorReporter);
        });
    }

    List<String> compileToIncrementalDomInteropSrcInternal() {
        return this.entryPoint(() -> {
            SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder().allowUnknownJsGlobals().desugarIdomFeatures(false).validateJavaMethods(false));
            this.throwIfErrorsPresent();
            return new IncrementalDomInteropSrcMain().genJsSrc(result.fileSet(), this.errorReporter);
        });
    }

    List<String> compileToPySrcFiles(SoyPySrcOptions pySrcOptions) {
        return this.entryPoint(() -> {
            try {
                SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilder().validateJavaMethods(false));
                this.throwIfErrorsPresent();
                return new PySrcMain(this.scopedData.enterable()).genPyFiles(result.fileSet(), result.registry(), pySrcOptions, this.errorReporter);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        });
    }

    HeaderResult compileMinimallyForHeaders() {
        return this.entryPoint(() -> {
            SoyFileSetParser.ParseResult parseResult = this.parse(this.passManagerBuilder().allowUnknownJsGlobals().addPassContinuationRule(CheckTemplateHeaderVarsPass.class, PassManager.PassContinuationRule.STOP_BEFORE_PASS).validateJavaMethods(false), this.typeRegistry);
            this.throwIfErrorsPresent();
            return new AutoValue_SoyFileSet_HeaderResult(parseResult.fileSet(), parseResult.registry(), this.cssRegistry);
        });
    }

    public AnalysisResult compileForAnalysis(boolean treatErrorsAsWarnings, PassManager.AstRewrites astRewrites) {
        return this.entryPoint(() -> {
            ImmutableList warnings;
            SoyFileSetParser.ParseResult result = this.parse(this.passManagerBuilderForAnalysis(astRewrites));
            if (treatErrorsAsWarnings) {
                this.resetErrorReporter();
                warnings = ImmutableList.builder().addAll(this.errorReporter.getErrors()).addAll(this.errorReporter.getWarnings()).build();
            } else {
                warnings = this.errorReporter.getWarnings();
                this.throwIfErrorsPresent();
            }
            return new AutoValue_SoyFileSet_AnalysisResult(result.hasRegistry() ? Optional.of(result.registry()) : Optional.empty(), result.fileSet(), result.cssRegistry(), this.toggleRegistry, (ImmutableList<SoyError>)warnings);
        });
    }

    private PassManager.Builder passManagerBuilderForAnalysis(PassManager.AstRewrites astRewrites) {
        return this.passManagerBuilder().optimize(false).astRewrites(astRewrites).addHtmlAttributesForDebugging(false).insertEscapingDirectives(false).desugarHtmlNodes(false).allowUnknownGlobals().allowUnknownJsGlobals().validateJavaMethods(false);
    }

    private SoyFileSetParser.ParseResult parseWithoutOptimizingOrDesugaringHtml() {
        return this.parse(this.passManagerBuilderWithoutOptimizingOrDesugaringHtml());
    }

    @VisibleForTesting
    public SoyFileSetParser.ParseResult parse() {
        return this.parse(this.passManagerBuilder());
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder) {
        return this.parse(builder, this.typeRegistry);
    }

    private SoyFileSetParser.ParseResult parse(PassManager.Builder builder, SoyTypeRegistry typeRegistry) {
        return SoyFileSetParser.newBuilder().setCache(this.cache).setSoyFileSuppliers(this.soyFileSuppliers).setCompilationUnits(this.compilationUnits).setCssRegistry(this.cssRegistry).setToggleRegistry(this.toggleRegistry).setTypeRegistry(typeRegistry).setPassManager(builder.setTypeRegistry(typeRegistry).build()).setErrorReporter(this.errorReporter).build().parse();
    }

    SoyFileSetParser.ParseResult parseInEntryPoint() {
        return this.entryPoint(this::parse);
    }

    private PassManager.Builder passManagerBuilder() {
        return new PassManager.Builder().setGeneralOptions(this.generalOptions).optimize(this.optimize).setGeneratedPathsToCheck(this.generatedPathsToCheck).setSoyPrintDirectives(this.printDirectives).setCssRegistry(this.cssRegistry).setToggleRegistry(this.toggleRegistry).setErrorReporter(this.errorReporter).setJavaPluginValidator(this.javaMethodChecker).setConformanceConfig(this.conformanceConfig).setPluginResolver(this.buildPluginResolver());
    }

    private PluginResolver buildPluginResolver() {
        return new PluginResolver(this.skipPluginValidation ? PluginResolver.Mode.ALLOW_UNDEFINED : PluginResolver.Mode.REQUIRE_DEFINITIONS, (List<SoyPrintDirective>)this.printDirectives, (List<SoyFunction>)this.soyFunctions, (List<SoySourceFunctionDescriptor>)this.soySourceFunctions, (List<SoySourceFunction>)this.soyMethods, this.errorReporter);
    }

    private PassManager.Builder passManagerBuilderWithoutOptimizingOrDesugaringHtml() {
        return this.passManagerBuilder().optimize(false).desugarHtmlNodes(false);
    }

    @VisibleForTesting
    public synchronized void resetErrorReporter() {
        this.errorReporter = ErrorReporter.create(this.soyFileSuppliers);
    }

    private void throwIfErrorsPresent() {
        if (this.errorReporter.hasErrors()) {
            Iterable errors = Iterables.concat(this.errorReporter.getErrors(), this.errorReporter.getWarnings());
            this.errorReporter = null;
            throw new SoyCompilationException(errors);
        }
    }

    private void reportWarnings() {
        ImmutableList<SoyError> warnings = this.errorReporter.getWarnings();
        if (warnings.isEmpty()) {
            return;
        }
        if (this.generalOptions.getExperimentalFeatures().contains((Object)"testonly_throw_on_warnings")) {
            this.errorReporter = null;
            throw new SoyCompilationException((Iterable<SoyError>)warnings);
        }
        String formatted = SoyErrors.formatErrors(warnings);
        if (this.warningSink != null) {
            try {
                this.warningSink.append(formatted);
            }
            catch (IOException ioe) {
                System.err.println("error while printing warnings");
                ioe.printStackTrace();
            }
        } else {
            logger.warning(formatted);
        }
    }

    @AutoValue
    public static abstract class AnalysisResult {
        AnalysisResult() {
        }

        public abstract Optional<FileSetMetadata> registry();

        public abstract SoyFileSetNode fileSet();

        public abstract CssRegistry cssRegistry();

        public abstract ToggleRegistry toggleRegistry();

        public abstract ImmutableList<SoyError> warnings();
    }

    @AutoValue
    static abstract class HeaderResult {
        HeaderResult() {
        }

        abstract SoyFileSetNode fileSet();

        abstract FileSetMetadata templateRegistry();

        abstract CssRegistry cssRegistry();
    }

    private static final class ServerCompilationPrimitives {
        final SoyFileSetNode soyTree;
        final FileSetMetadata registry;

        ServerCompilationPrimitives(FileSetMetadata registry, SoyFileSetNode soyTree) {
            this.registry = registry;
            this.soyTree = soyTree;
        }
    }

    public static final class Builder {
        private final Map<SourceLogicalPath, SoyFileSupplier> filesBuilder = new LinkedHashMap<SourceLogicalPath, SoyFileSupplier>();
        private final ImmutableList.Builder<Metadata.CompilationUnitAndKind> compilationUnitsBuilder = ImmutableList.builder();
        private SoyAstCache cache = null;
        private SoyGeneralOptions lazyGeneralOptions = null;
        private final SoyTypeRegistryBuilder typeRegistryBuilder = new SoyTypeRegistryBuilder();
        @Nullable
        private Appendable warningSink;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ImmutableList<File> pluginRuntimeJars = ImmutableList.of();
        private CssRegistry cssRegistry = CssRegistry.EMPTY;
        private ToggleRegistry toggleRegistry = ToggleRegistry.EMPTY;
        private boolean skipPluginValidation = false;
        private boolean optimize = true;
        private MethodChecker javaPluginValidator = (className, methodName, returnType, arguments) -> MethodChecker.Response.error(MethodChecker.Code.NO_SUCH_CLASS);
        private Set<SourceLogicalPath> generatedPathsToCheck = ImmutableSet.of();
        private final ImmutableSet.Builder<SoyFunction> soyFunctions = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoyPrintDirective> soyPrintDirectives = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoySourceFunctionDescriptor> sourceFunctions = ImmutableSet.builder();
        private final ImmutableSet.Builder<SoySourceFunction> sourceMethods = ImmutableSet.builder();

        Builder(boolean ignored) {
        }

        @CanIgnoreReturnValue
        public Builder setGeneralOptions(SoyGeneralOptions generalOptions) {
            Preconditions.checkState((this.lazyGeneralOptions == null ? 1 : 0) != 0, (Object)"Call SoyFileSet#setGeneralOptions before any other setters.");
            Preconditions.checkNotNull((Object)generalOptions, (Object)"Non-null argument expected.");
            this.lazyGeneralOptions = generalOptions.clone();
            return this;
        }

        private SoyGeneralOptions getGeneralOptions() {
            if (this.lazyGeneralOptions == null) {
                this.lazyGeneralOptions = new SoyGeneralOptions();
            }
            return this.lazyGeneralOptions;
        }

        public SoyFileSet build() {
            SoySimpleScope data = new SoySimpleScope();
            return new SoyFileSet(data, this.typeRegistryBuilder.build(), (ImmutableList<SoyFunction>)ImmutableList.builder().addAll(InternalPlugins.internalLegacyFunctions()).addAll((Iterable)this.soyFunctions.build()).build(), (ImmutableList<SoyPrintDirective>)ImmutableList.builder().addAll(InternalPlugins.internalDirectives(data)).addAll((Iterable)this.soyPrintDirectives.build()).build(), (ImmutableList<SoySourceFunctionDescriptor>)ImmutableList.builder().addAll(InternalPlugins.internalFunctionDescriptors()).addAll((Iterable)this.sourceFunctions.build()).build(), (ImmutableList<SoySourceFunction>)ImmutableList.builder().addAll(InternalPlugins.internalMethods()).addAll((Iterable)this.sourceMethods.build()).build(), (ImmutableMap<SourceLogicalPath, SoyFileSupplier>)ImmutableMap.copyOf(this.filesBuilder), (ImmutableList<Metadata.CompilationUnitAndKind>)this.compilationUnitsBuilder.build(), this.getGeneralOptions(), this.cache, this.conformanceConfig, this.warningSink, this.pluginRuntimeJars, this.skipPluginValidation, this.optimize, this.generatedPathsToCheck, this.cssRegistry, this.toggleRegistry, this.javaPluginValidator);
        }

        @CanIgnoreReturnValue
        public Builder setJavaPluginValidator(MethodChecker javaPluginValidator) {
            this.javaPluginValidator = javaPluginValidator;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setReflectivePluginValidator() {
            this.javaPluginValidator = new ReflectiveMethodChecker();
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSourceFunction(SoySourceFunction function) {
            return this.addSourceFunctionInternal(null, function);
        }

        @CanIgnoreReturnValue
        public Builder addSourceFunction(String pluginTarget, SoySourceFunction function) {
            return this.addSourceFunctionInternal((String)Preconditions.checkNotNull((Object)pluginTarget), function);
        }

        @CanIgnoreReturnValue
        private Builder addSourceFunctionInternal(@Nullable String pluginTarget, SoySourceFunction function) {
            boolean method = false;
            if (SoyMethodSignature.IS_SOY_METHOD.test(function)) {
                this.sourceMethods.add((Object)function);
                method = true;
            }
            if (!method || function.getClass().isAnnotationPresent(SoyFunctionSignature.class)) {
                this.sourceFunctions.add((Object)(pluginTarget != null ? SoySourceFunctionDescriptor.create(pluginTarget, function) : SoySourceFunctionDescriptor.createUnknownPlugin(function)));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSourceFunctions(Iterable<? extends SoySourceFunction> function) {
            for (SoySourceFunction soySourceFunction : function) {
                this.addSourceFunctionInternal(null, soySourceFunction);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSourceMethod(SoySourceFunction function) {
            Preconditions.checkArgument((boolean)SoyMethodSignature.IS_SOY_METHOD.test(function));
            this.sourceMethods.add((Object)function);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSoyFunction(SoyFunction function) {
            this.soyFunctions.add((Object)function);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSoyFunctions(Iterable<? extends SoyFunction> function) {
            this.soyFunctions.addAll(function);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSoyPrintDirective(SoyPrintDirective function) {
            this.soyPrintDirectives.add((Object)function);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addSoyPrintDirectives(Iterable<? extends SoyPrintDirective> function) {
            this.soyPrintDirectives.addAll(function);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder add(SoyFileSupplier soyFileSupplier) {
            return this.addFile(soyFileSupplier);
        }

        @CanIgnoreReturnValue
        public Builder add(CharSource contentSource, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(contentSource, SourceFilePath.create(filePath, filePath)));
        }

        @CanIgnoreReturnValue
        public Builder add(URL inputFileUrl, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFileUrl, SourceFilePath.create(filePath, inputFileUrl.toString())));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder add(URL inputFileUrl) {
            return this.add(inputFileUrl, inputFileUrl.toString());
        }

        @CanIgnoreReturnValue
        public Builder add(CharSequence content, String filePath) {
            return this.addFile(SoyFileSupplier.Factory.create(content, SourceFilePath.create(filePath, filePath)));
        }

        @CanIgnoreReturnValue
        public Builder add(File inputFile) {
            return this.addFile(SoyFileSupplier.Factory.create(inputFile));
        }

        @CanIgnoreReturnValue
        public SoyFileSupplier clobberFile(SoyFileSupplier contents) {
            SoyFileSupplier previous = this.filesBuilder.put(contents.getFilePath().asLogicalPath(), contents);
            return (SoyFileSupplier)Preconditions.checkNotNull((Object)previous);
        }

        @CanIgnoreReturnValue
        public Builder setSoyAstCache(SoyAstCache cache) {
            this.cache = cache;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setExperimentalFeatures(List<String> experimentalFeatures) {
            this.getGeneralOptions().setExperimentalFeatures(experimentalFeatures);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder disableOptimizer() {
            this.optimize = false;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setGeneratedPathsToCheck(Set<SourceLogicalPath> generatedPaths) {
            this.generatedPathsToCheck = generatedPaths;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addProtoDescriptors(SoyFileKind depKind, Descriptors.GenericDescriptor ... descriptors) {
            return this.addProtoDescriptors(depKind, Arrays.asList(descriptors));
        }

        @CanIgnoreReturnValue
        public Builder addProtoDescriptors(SoyFileKind depKind, Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            this.typeRegistryBuilder.addDescriptors(depKind, descriptors);
            return this;
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addProtoDescriptors(Descriptors.GenericDescriptor ... descriptors) {
            return this.addProtoDescriptors(SoyFileKind.DEP, Arrays.asList(descriptors));
        }

        @Deprecated
        @CanIgnoreReturnValue
        public Builder addProtoDescriptors(Iterable<? extends Descriptors.GenericDescriptor> descriptors) {
            this.typeRegistryBuilder.addDescriptors(SoyFileKind.DEP, descriptors);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setConformanceConfig(ValidatedConformanceConfig config) {
            Preconditions.checkNotNull((Object)config);
            this.conformanceConfig = config;
            return this;
        }

        @CanIgnoreReturnValue
        Builder addCompilationUnit(SoyFileKind fileKind, CompilationUnit compilationUnit) {
            this.compilationUnitsBuilder.add((Object)Metadata.CompilationUnitAndKind.create(fileKind, compilationUnit));
            return this;
        }

        @CanIgnoreReturnValue
        private Builder addFile(SoyFileSupplier supplier) {
            SoyFileSupplier previous = this.filesBuilder.put(supplier.getFilePath().asLogicalPath(), supplier);
            if (previous != null) {
                throw new IllegalArgumentException("Duplicate path " + String.valueOf(supplier.getFilePath()));
            }
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setWarningSink(Appendable warningSink) {
            this.warningSink = (Appendable)Preconditions.checkNotNull((Object)warningSink);
            return this;
        }

        @CanIgnoreReturnValue
        Builder setPluginRuntimeJars(List<File> pluginRuntimeJars) {
            this.pluginRuntimeJars = ImmutableList.copyOf(pluginRuntimeJars);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setCssRegistry(CssRegistry cssRegistry) {
            this.cssRegistry = (CssRegistry)Preconditions.checkNotNull((Object)cssRegistry);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setToggleRegistry(ToggleRegistry toggleRegistry) {
            this.toggleRegistry = (ToggleRegistry)Preconditions.checkNotNull((Object)toggleRegistry);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder setSkipPluginValidation(boolean skipPluginValidation) {
            this.skipPluginValidation = skipPluginValidation;
            return this;
        }
    }
}

