/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableListMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soytree.AbstractBlockCommandNode;
import com.google.template.soy.soytree.AutoValue_MsgNode_RepresentativeNodes;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTagAttribute;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.RawTextNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SoyTreeUtils;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

public final class MsgNode
extends AbstractBlockCommandNode
implements SoyNode.ExprHolderNode,
SoyNode.MsgBlockNode {
    private static final SoyErrorKind WRONG_NUMBER_OF_GENDER_EXPRS = SoyErrorKind.of("Attribute ''genders'' should contain 1-3 expressions.", new SoyErrorKind.StyleAllowance[0]);
    private static final Pattern LINE_BOUNDARY_PATTERN = Pattern.compile("\\s*?(\\n|\\r)\\s*");
    private static final String DEFAULT_CONTENT_TYPE = "text/html";
    @Nullable
    private ImmutableList<ExprRootNode> genderExprs;
    @Nullable
    private final String meaning;
    private final String desc;
    private final boolean isHidden;
    @Nullable
    private final String genderExprsString;
    @Nullable
    private SubstUnitInfo substUnitInfo = null;

    public MsgNode(int id, SourceLocation location, String commandName, List<CommandTagAttribute> attributes, ErrorReporter errorReporter) {
        super(id, location, commandName);
        String meaning = null;
        String desc = null;
        boolean hidden = false;
        ImmutableList<ExprRootNode> genders = null;
        block12: for (CommandTagAttribute attr : attributes) {
            String name = attr.getName().identifier();
            switch (attr.getName().identifier()) {
                case "meaning": {
                    meaning = attr.getValue();
                    meaning = LINE_BOUNDARY_PATTERN.matcher(meaning).replaceAll(" ");
                    continue block12;
                }
                case "desc": {
                    desc = attr.getValue();
                    desc = LINE_BOUNDARY_PATTERN.matcher(desc).replaceAll(" ");
                    continue block12;
                }
                case "hidden": {
                    hidden = attr.valueAsEnabled(errorReporter);
                    continue block12;
                }
                case "genders": {
                    genders = ExprRootNode.wrap(attr.valueAsExprList());
                    if (!genders.isEmpty() && genders.size() <= 3) continue block12;
                    errorReporter.report(attr.getValueLocation(), WRONG_NUMBER_OF_GENDER_EXPRS, new Object[0]);
                    continue block12;
                }
            }
            errorReporter.report(attr.getName().location(), CommandTagAttribute.UNSUPPORTED_ATTRIBUTE_KEY, name, commandName, ImmutableList.of((Object)"meaning", (Object)"desc", (Object)"hidden", (Object)"genders"));
        }
        if (desc == null) {
            errorReporter.report(location, CommandTagAttribute.MISSING_ATTRIBUTE, "desc", commandName);
            desc = "";
        }
        this.meaning = meaning;
        this.desc = desc;
        this.isHidden = hidden;
        this.genderExprs = genders;
        this.genderExprsString = genders != null ? SoyTreeUtils.toSourceString(genders) : null;
    }

    private MsgNode(MsgNode orig, CopyState copyState) {
        super(orig, copyState);
        if (orig.genderExprs != null) {
            ImmutableList.Builder builder = ImmutableList.builder();
            for (ExprRootNode node : orig.genderExprs) {
                builder.add((Object)node.copy(copyState));
            }
            this.genderExprs = builder.build();
        } else {
            this.genderExprs = null;
        }
        this.meaning = orig.meaning;
        this.desc = orig.desc;
        this.isHidden = orig.isHidden;
        this.substUnitInfo = orig.substUnitInfo;
        this.genderExprsString = orig.genderExprsString;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_NODE;
    }

    @Nullable
    public List<ExprRootNode> getAndRemoveGenderExprs() {
        ImmutableList<ExprRootNode> genderExprs = this.genderExprs;
        this.genderExprs = null;
        return genderExprs;
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        if (this.genderExprs != null) {
            return ImmutableList.copyOf(this.genderExprs);
        }
        return ImmutableList.of();
    }

    @Nullable
    public String getMeaning() {
        return this.meaning;
    }

    public String getDesc() {
        return this.desc;
    }

    public boolean isHidden() {
        return this.isHidden;
    }

    public String getContentType() {
        return DEFAULT_CONTENT_TYPE;
    }

    public boolean isPlrselMsg() {
        return this.isSelectMsg() || this.isPluralMsg();
    }

    public boolean isSelectMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgSelectNode;
    }

    public boolean isPluralMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof MsgPluralNode;
    }

    public boolean isRawTextMsg() {
        Preconditions.checkState((this.numChildren() > 0 ? 1 : 0) != 0);
        return this.numChildren() == 1 && this.getChild(0) instanceof RawTextNode;
    }

    public void ensureSubstUnitInfoHasNotBeenAccessed() {
        if (this.substUnitInfo != null) {
            throw new IllegalStateException("Substitution info has already been accessed.");
        }
    }

    public MsgPlaceholderNode getRepPlaceholderNode(String placeholderName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgPlaceholderNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)placeholderName);
    }

    public String getPlaceholderName(MsgPlaceholderNode placeholderNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)placeholderNode);
    }

    public MsgPluralNode getRepPluralNode(String pluralVarName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgPluralNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)pluralVarName);
    }

    public String getPluralVarName(MsgPluralNode pluralNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)pluralNode);
    }

    public MsgSelectNode getRepSelectNode(String selectVarName) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (MsgSelectNode)this.substUnitInfo.varNameToRepNodeMap.get((Object)selectVarName);
    }

    public String getSelectVarName(MsgSelectNode selectNode) {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return (String)this.substUnitInfo.nodeToVarNameMap.get((Object)selectNode);
    }

    public ImmutableMap<String, SoyNode.MsgSubstUnitNode> getVarNameToRepNodeMap() {
        if (this.substUnitInfo == null) {
            this.substUnitInfo = MsgNode.genSubstUnitInfo(this);
        }
        return this.substUnitInfo.varNameToRepNodeMap;
    }

    @Override
    public String getCommandText() {
        StringBuilder commandText = new StringBuilder();
        if (this.meaning != null) {
            commandText.append(" meaning=\"").append(this.meaning).append('\"');
        }
        if (this.desc != null) {
            commandText.append(" desc=\"").append(this.desc).append('\"');
        }
        if (this.isHidden) {
            commandText.append(" hidden=\"").append(this.isHidden).append('\"');
        }
        if (this.genderExprsString != null) {
            commandText.append(" genders=\"").append(this.genderExprsString).append('\"');
        }
        return commandText.toString().trim();
    }

    @Override
    public String toSourceString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getTagString());
        this.appendSourceStringForChildren(sb);
        return sb.toString();
    }

    @Override
    public MsgNode copy(CopyState copyState) {
        return new MsgNode(this, copyState);
    }

    private static SubstUnitInfo genSubstUnitInfo(MsgNode msgNode) {
        return MsgNode.genFinalSubstUnitInfoMapsHelper(RepresentativeNodes.createFromNode(msgNode));
    }

    private static SubstUnitInfo genFinalSubstUnitInfoMapsHelper(RepresentativeNodes representativeNodes) {
        LinkedHashMap<String, Object> substUnitVarNameToRepNodeMap = new LinkedHashMap<String, Object>();
        for (String baseName : representativeNodes.baseNameToRepNodesMap().keys()) {
            ImmutableList immutableList = representativeNodes.baseNameToRepNodesMap().get((Object)baseName);
            if (immutableList.size() == 1) {
                substUnitVarNameToRepNodeMap.put(baseName, immutableList.get(0));
                continue;
            }
            int nextSuffix = 1;
            for (SoyNode.MsgSubstUnitNode repNode : immutableList) {
                String newName;
                do {
                    newName = baseName + "_" + nextSuffix;
                    ++nextSuffix;
                } while (representativeNodes.baseNameToRepNodesMap().containsKey((Object)newName));
                substUnitVarNameToRepNodeMap.put(newName, repNode);
            }
        }
        LinkedHashMap<Object, Object> substUnitNodeToVarNameMap = new LinkedHashMap<Object, Object>();
        for (Map.Entry entry : substUnitVarNameToRepNodeMap.entrySet()) {
            substUnitNodeToVarNameMap.put(entry.getValue(), entry.getKey());
        }
        for (Map.Entry entry : representativeNodes.nonRepNodeToRepNodeMap().entrySet()) {
            SoyNode.MsgSubstUnitNode nonRepNode = (SoyNode.MsgSubstUnitNode)entry.getKey();
            SoyNode.MsgSubstUnitNode repNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            substUnitNodeToVarNameMap.put(nonRepNode, substUnitNodeToVarNameMap.get(repNode));
        }
        return new SubstUnitInfo((ImmutableMap<String, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(substUnitVarNameToRepNodeMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, String>)ImmutableMap.copyOf(substUnitNodeToVarNameMap));
    }

    static abstract class RepresentativeNodes {
        RepresentativeNodes() {
        }

        static RepresentativeNodes createFromNode(MsgNode msgNode) {
            LinkedListMultimap baseNameToRepNodesMap = LinkedListMultimap.create();
            HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> nonRepNodeToRepNodeMap = new HashMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>();
            ArrayDeque<SoyNode.MsgSubstUnitNode> traversalQueue = new ArrayDeque<SoyNode.MsgSubstUnitNode>();
            for (Object child : msgNode.getChildren()) {
                if (!(child instanceof SoyNode.MsgSubstUnitNode)) continue;
                traversalQueue.add((SoyNode.MsgSubstUnitNode)child);
            }
            while (!traversalQueue.isEmpty()) {
                String baseName;
                SoyNode.MsgSubstUnitNode node = (SoyNode.MsgSubstUnitNode)traversalQueue.remove();
                if (node instanceof MsgSelectNode || node instanceof MsgPluralNode) {
                    for (CaseOrDefaultNode child : ((SoyNode.ParentSoyNode)((Object)node)).getChildren()) {
                        for (SoyNode grandchild : child.getChildren()) {
                            if (!(grandchild instanceof SoyNode.MsgSubstUnitNode)) continue;
                            traversalQueue.add((SoyNode.MsgSubstUnitNode)grandchild);
                        }
                    }
                }
                if (!baseNameToRepNodesMap.containsKey((Object)(baseName = node.getBaseVarName()))) {
                    baseNameToRepNodesMap.put((Object)baseName, (Object)node);
                    continue;
                }
                boolean isNew = true;
                for (SoyNode.MsgSubstUnitNode other : baseNameToRepNodesMap.get((Object)baseName)) {
                    if (!node.shouldUseSameVarNameAs(other)) continue;
                    nonRepNodeToRepNodeMap.put(node, other);
                    isNew = false;
                    break;
                }
                if (!isNew) continue;
                baseNameToRepNodesMap.put((Object)baseName, (Object)node);
            }
            return new AutoValue_MsgNode_RepresentativeNodes((ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode>)ImmutableListMultimap.copyOf((Multimap)baseNameToRepNodesMap), (ImmutableMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode>)ImmutableMap.copyOf(nonRepNodeToRepNodeMap));
        }

        abstract ImmutableListMultimap<String, SoyNode.MsgSubstUnitNode> baseNameToRepNodesMap();

        abstract ImmutableMap<SoyNode.MsgSubstUnitNode, SoyNode.MsgSubstUnitNode> nonRepNodeToRepNodeMap();
    }

    private static final class SubstUnitInfo {
        public final ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap;
        public final ImmutableMap<SoyNode.MsgSubstUnitNode, String> nodeToVarNameMap;

        public SubstUnitInfo(ImmutableMap<String, SoyNode.MsgSubstUnitNode> varNameToRepNodeMap, ImmutableMap<SoyNode.MsgSubstUnitNode, String> nodeToVarNameMap) {
            this.varNameToRepNodeMap = varNameToRepNodeMap;
            this.nodeToVarNameMap = nodeToVarNameMap;
        }
    }
}

