/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Optional;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.CopyState;
import com.google.template.soy.basicfunctions.RangeFunction;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.AutoValue_ForeachNode_RangeArgs;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class ForeachNode
extends AbstractParentCommandNode<SoyNode.BlockNode>
implements SoyNode.StandaloneNode,
SoyNode.SplitLevelTopNode<SoyNode.BlockNode>,
SoyNode.StatementNode,
SoyNode.ExprHolderNode {
    private final ExprRootNode expr;

    public ForeachNode(int id, SourceLocation location, String commandName, ExprNode expr) {
        super(id, location, commandName);
        this.expr = new ExprRootNode(expr);
    }

    private ForeachNode(ForeachNode orig, CopyState copyState) {
        super(orig, copyState);
        this.expr = orig.expr.copy(copyState);
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.FOREACH_NODE;
    }

    public boolean hasIfEmptyBlock() {
        return this.numChildren() > 1;
    }

    public ExprRootNode getExpr() {
        return this.expr;
    }

    public Optional<RangeArgs> exprAsRangeArgs() {
        FunctionNode fn;
        if (this.expr.getRoot() instanceof FunctionNode && (fn = (FunctionNode)this.expr.getRoot()).getSoyFunction() instanceof RangeFunction) {
            return Optional.of((Object)RangeArgs.create(fn.getChildren()));
        }
        return Optional.absent();
    }

    @Override
    public String getCommandText() {
        return "$" + ((ForeachNonemptyNode)this.getChild(0)).getVarName() + " in " + this.expr.toSourceString();
    }

    @Override
    public ImmutableList<ExprRootNode> getExprList() {
        return ImmutableList.of((Object)this.expr);
    }

    @Override
    public SoyNode.ParentSoyNode<SoyNode.StandaloneNode> getParent() {
        return super.getParent();
    }

    @Override
    public ForeachNode copy(CopyState copyState) {
        return new ForeachNode(this, copyState);
    }

    public static abstract class RangeArgs {
        static RangeArgs create(List<ExprNode> args) {
            switch (args.size()) {
                case 1: {
                    return new AutoValue_ForeachNode_RangeArgs((Optional<ExprNode>)Optional.absent(), args.get(0), (Optional<ExprNode>)Optional.absent());
                }
                case 2: {
                    return new AutoValue_ForeachNode_RangeArgs((Optional<ExprNode>)Optional.of((Object)args.get(0)), args.get(1), (Optional<ExprNode>)Optional.absent());
                }
                case 3: {
                    return new AutoValue_ForeachNode_RangeArgs((Optional<ExprNode>)Optional.of((Object)args.get(0)), args.get(1), (Optional<ExprNode>)Optional.of((Object)args.get(2)));
                }
            }
            throw new AssertionError();
        }

        public abstract Optional<ExprNode> start();

        public abstract ExprNode limit();

        public abstract Optional<ExprNode> increment();
    }
}

