/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.sharedpasses.render;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basicfunctions.DebugSoyTemplateInfoFunction;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyAbstractValue;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyNewMap;
import com.google.template.soy.data.SoyProtoValue;
import com.google.template.soy.data.SoyRecord;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.DictImpl;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.data.internal.SoyMapImpl;
import com.google.template.soy.data.restricted.BooleanData;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NullData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.data.restricted.UndefinedData;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.AbstractReturningExprNodeVisitor;
import com.google.template.soy.exprtree.BooleanNode;
import com.google.template.soy.exprtree.DataAccessNode;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FloatNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.LegacyObjectMapLiteralNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.NullNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.logging.LoggingFunction;
import com.google.template.soy.shared.SoyCssRenamingMap;
import com.google.template.soy.shared.SoyIdRenamingMap;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.internal.SharedRuntime;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.sharedpasses.render.Environment;
import com.google.template.soy.sharedpasses.render.RenderException;
import com.google.template.soy.sharedpasses.render.TofuTypeChecks;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.proto.SoyProtoType;
import com.google.template.soy.types.proto.SoyProtoValueImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import javax.annotation.Nullable;

public class EvalVisitor
extends AbstractReturningExprNodeVisitor<SoyValue> {
    private final Environment env;
    @Nullable
    private final SoyRecord ijData;
    private final SoyCssRenamingMap cssRenamingMap;
    private final SoyIdRenamingMap xidRenamingMap;
    private final boolean debugSoyTemplateInfo;

    protected EvalVisitor(Environment env, @Nullable SoyRecord ijData, @Nullable SoyCssRenamingMap cssRenamingMap, @Nullable SoyIdRenamingMap xidRenamingMap, boolean debugSoyTemplateInfo) {
        this.env = (Environment)Preconditions.checkNotNull((Object)env);
        this.ijData = ijData;
        this.cssRenamingMap = cssRenamingMap == null ? SoyCssRenamingMap.EMPTY : cssRenamingMap;
        this.xidRenamingMap = xidRenamingMap == null ? SoyCssRenamingMap.EMPTY : xidRenamingMap;
        this.debugSoyTemplateInfo = debugSoyTemplateInfo;
    }

    @Override
    protected SoyValue visitExprRootNode(ExprRootNode node) {
        return (SoyValue)this.visit(node.getRoot());
    }

    @Override
    protected SoyValue visitNullNode(NullNode node) {
        return NullData.INSTANCE;
    }

    @Override
    protected SoyValue visitBooleanNode(BooleanNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitIntegerNode(IntegerNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitFloatNode(FloatNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitStringNode(StringNode node) {
        return this.convertResult(node.getValue());
    }

    @Override
    protected SoyValue visitGlobalNode(GlobalNode node) {
        return (SoyValue)this.visit(node.getValue());
    }

    @Override
    protected SoyValue visitListLiteralNode(ListLiteralNode node) {
        List values = this.visitChildren(node);
        return ListImpl.forProviderList(values);
    }

    @Override
    protected SoyValue visitLegacyObjectMapLiteralNode(LegacyObjectMapLiteralNode node) {
        return this.visitLegacyObjectMapLiteralOrMapLiteralNode(node);
    }

    @Override
    protected SoyValue visitMapLiteralNode(MapLiteralNode node) {
        return this.visitLegacyObjectMapLiteralOrMapLiteralNode(node);
    }

    private SoyValue visitLegacyObjectMapLiteralOrMapLiteralNode(AbstractParentExprNode node) {
        Preconditions.checkState((node.getKind() == ExprNode.Kind.LEGACY_OBJECT_MAP_LITERAL_NODE || node.getKind() == ExprNode.Kind.MAP_LITERAL_NODE ? 1 : 0) != 0);
        int numItems = node.numChildren() / 2;
        boolean isStringKeyed = true;
        Node firstNonstringKeyNode = null;
        ArrayList keys = Lists.newArrayListWithCapacity((int)numItems);
        ArrayList values = Lists.newArrayListWithCapacity((int)numItems);
        for (int i = 0; i < numItems; ++i) {
            SoyValue key = (SoyValue)this.visit(node.getChild(2 * i));
            if (isStringKeyed && !(key instanceof StringData)) {
                isStringKeyed = false;
                firstNonstringKeyNode = node.getChild(2 * i);
            }
            keys.add(key);
            values.add(this.visit(node.getChild(2 * i + 1)));
        }
        if (isStringKeyed) {
            LinkedHashMap map = Maps.newLinkedHashMap();
            for (int i = 0; i < numItems; ++i) {
                map.put(((SoyValue)keys.get(i)).stringValue(), values.get(i));
            }
            return node.getKind() == ExprNode.Kind.LEGACY_OBJECT_MAP_LITERAL_NODE ? DictImpl.forProviderMap(map) : SoyMapImpl.forProviderMap(map);
        }
        throw RenderException.create(String.format("Currently, map literals must have string keys (key \"%s\" in map %s does not evaluate to a string). Support for nonstring keys is a todo.", firstNonstringKeyNode.toSourceString(), node.toSourceString()));
    }

    @Override
    protected SoyValue visitVarRefNode(VarRefNode node) {
        return this.visitNullSafeNode(node);
    }

    @Override
    protected SoyValue visitDataAccessNode(DataAccessNode node) {
        return this.visitNullSafeNode(node);
    }

    private SoyValue visitNullSafeNode(ExprNode node) {
        SoyValue value = this.visitNullSafeNodeRecurse(node);
        if (value == NullSafetySentinel.INSTANCE) {
            return NullData.INSTANCE;
        }
        return value;
    }

    private SoyValue visitNullSafeNodeRecurse(ExprNode node) {
        switch (node.getKind()) {
            case VAR_REF_NODE: {
                return this.visitNullSafeVarRefNode((VarRefNode)node);
            }
            case FIELD_ACCESS_NODE: {
                return this.visitNullSafeFieldAccessNode((FieldAccessNode)node);
            }
            case ITEM_ACCESS_NODE: {
                return this.visitNullSafeItemAccessNode((ItemAccessNode)node);
            }
        }
        return (SoyValue)this.visit(node);
    }

    private SoyValue visitNullSafeVarRefNode(VarRefNode varRef) {
        SoyValue result = null;
        if (varRef.isDollarSignIjParameter()) {
            if (this.ijData == null) {
                throw RenderException.create("Injected data not provided, yet referenced (" + varRef.toSourceString() + ").");
            }
        } else {
            return this.env.getVar(varRef.getDefnDecl());
        }
        result = this.ijData.getField(varRef.getName());
        return result != null ? result : UndefinedData.INSTANCE;
    }

    private SoyValue visitNullSafeFieldAccessNode(FieldAccessNode fieldAccess) {
        SoyValue base = this.visitNullSafeNodeRecurse(fieldAccess.getBaseExprChild());
        if (!(base instanceof SoyRecord) && !(base instanceof SoyProtoValue)) {
            if (base == NullSafetySentinel.INSTANCE) {
                return NullSafetySentinel.INSTANCE;
            }
            if (fieldAccess.isNullSafe()) {
                if (EvalVisitor.isNullOrUndefinedBase(base)) {
                    return NullSafetySentinel.INSTANCE;
                }
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-record just before accessing \"%s\".", fieldAccess.toSourceString(), fieldAccess.getSourceStringSuffix()));
            }
            return UndefinedData.INSTANCE;
        }
        if (fieldAccess.getBaseExprChild().getType().getKind() == SoyType.Kind.PROTO) {
            return ((SoyProtoValue)base).getProtoField(fieldAccess.getFieldName());
        }
        SoyValue value = ((SoyRecord)base).getField(fieldAccess.getFieldName());
        if (value != null && !TofuTypeChecks.isInstance(fieldAccess.getType(), value)) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", fieldAccess.getType(), value.getClass().getSimpleName()));
        }
        return value != null ? value : UndefinedData.INSTANCE;
    }

    private SoyValue visitNullSafeItemAccessNode(ItemAccessNode itemAccess) {
        SoyValue value;
        SoyValue base = this.visitNullSafeNodeRecurse(itemAccess.getBaseExprChild());
        if (!(base instanceof SoyMap) && !(base instanceof SoyNewMap)) {
            if (base == NullSafetySentinel.INSTANCE) {
                return NullSafetySentinel.INSTANCE;
            }
            if (itemAccess.isNullSafe()) {
                if (EvalVisitor.isNullOrUndefinedBase(base)) {
                    return NullSafetySentinel.INSTANCE;
                }
                throw RenderException.create(String.format("While evaluating \"%s\", encountered non-map/list just before accessing \"%s\".", itemAccess.toSourceString(), itemAccess.getSourceStringSuffix()));
            }
            return UndefinedData.INSTANCE;
        }
        SoyValue key = (SoyValue)this.visit(itemAccess.getKeyExprChild());
        SoyValue soyValue = value = base instanceof SoyMap ? ((SoyMap)base).getItem(key) : ((SoyNewMap)base).get(key);
        if (value != null && !TofuTypeChecks.isInstance(itemAccess.getType(), value)) {
            throw RenderException.create(String.format("Expected value of type '%s', but actual type was '%s'.", itemAccess.getType(), value.getClass().getSimpleName()));
        }
        return value != null ? value : UndefinedData.INSTANCE;
    }

    private static boolean isNullOrUndefinedBase(SoyValue base) {
        return base == null || base instanceof NullData || base instanceof UndefinedData || base == NullSafetySentinel.INSTANCE;
    }

    @Override
    protected SoyValue visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
        return SharedRuntime.negative((SoyValue)this.visit(node.getChild(0)));
    }

    @Override
    protected SoyValue visitNotOpNode(OperatorNodes.NotOpNode node) {
        SoyValue operand = (SoyValue)this.visit(node.getChild(0));
        return this.convertResult(!operand.coerceToBoolean());
    }

    @Override
    protected SoyValue visitTimesOpNode(OperatorNodes.TimesOpNode node) {
        return SharedRuntime.times((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
        return FloatData.forValue(SharedRuntime.dividedBy((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitModOpNode(OperatorNodes.ModOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand0.longValue() % operand1.longValue());
    }

    @Override
    protected SoyValue visitPlusOpNode(OperatorNodes.PlusOpNode node) {
        return SharedRuntime.plus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitMinusOpNode(OperatorNodes.MinusOpNode node) {
        return SharedRuntime.minus((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1)));
    }

    @Override
    protected SoyValue visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThan((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
        return BooleanData.forValue(SharedRuntime.lessThanOrEqual((SoyValue)this.visit(node.getChild(1)), (SoyValue)this.visit(node.getChild(0))));
    }

    @Override
    protected SoyValue visitEqualOpNode(OperatorNodes.EqualOpNode node) {
        return this.convertResult(SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
        return this.convertResult(!SharedRuntime.equal((SoyValue)this.visit(node.getChild(0)), (SoyValue)this.visit(node.getChild(1))));
    }

    @Override
    protected SoyValue visitAndOpNode(OperatorNodes.AndOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (!operand0.coerceToBoolean()) {
            return this.convertResult(false);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitOrOpNode(OperatorNodes.OrOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return this.convertResult(true);
        }
        SoyValue operand1 = (SoyValue)this.visit(node.getChild(1));
        return this.convertResult(operand1.coerceToBoolean());
    }

    @Override
    protected SoyValue visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0.coerceToBoolean()) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return (SoyValue)this.visit(node.getChild(2));
    }

    @Override
    protected SoyValue visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        SoyValue operand0 = (SoyValue)this.visit(node.getChild(0));
        if (operand0 instanceof NullData || operand0 instanceof UndefinedData) {
            return (SoyValue)this.visit(node.getChild(1));
        }
        return operand0;
    }

    @Override
    protected SoyValue visitFunctionNode(FunctionNode node) {
        SoyFunction soyFunction = node.getSoyFunction();
        if (soyFunction instanceof BuiltinFunction) {
            BuiltinFunction nonpluginFn = (BuiltinFunction)soyFunction;
            switch (nonpluginFn) {
                case IS_FIRST: {
                    return this.visitIsFirstFunction(node);
                }
                case IS_LAST: {
                    return this.visitIsLastFunction(node);
                }
                case INDEX: {
                    return this.visitIndexFunction(node);
                }
                case QUOTE_KEYS_IF_JS: {
                    return this.visitLegacyObjectMapLiteralNode((LegacyObjectMapLiteralNode)node.getChild(0));
                }
                case CHECK_NOT_NULL: {
                    return this.visitCheckNotNullFunction(node.getChild(0));
                }
                case CSS: {
                    return this.visitCssFunction(node);
                }
                case XID: {
                    return this.visitXidFunction(node);
                }
                case V1_EXPRESSION: {
                    throw new UnsupportedOperationException("the v1Expression function can't be used in templates compiled to Java");
                }
            }
            throw new AssertionError();
        }
        if (soyFunction instanceof SoyJavaFunction) {
            List<SoyValue> args = this.visitChildren(node);
            SoyJavaFunction fn = (SoyJavaFunction)soyFunction;
            return this.computeFunctionHelper(fn, args, node);
        }
        if (soyFunction instanceof LoggingFunction) {
            return StringData.forValue(((LoggingFunction)soyFunction).getPlaceholder());
        }
        throw RenderException.create("Failed to find Soy function with name '" + node.getFunctionName() + "' (function call \"" + node.toSourceString() + "\").");
    }

    @Override
    protected SoyValue visitProtoInitNode(ProtoInitNode node) {
        SoyProtoType soyProto = (SoyProtoType)node.getType();
        ImmutableList<String> paramNames = node.getParamNames();
        SoyProtoValueImpl.Builder builder = new SoyProtoValueImpl.Builder(soyProto.getDescriptor());
        for (int i = 0; i < node.numChildren(); ++i) {
            SoyValue visit = (SoyValue)this.visit(node.getChild(i));
            if (visit instanceof NullData || visit instanceof UndefinedData) continue;
            builder.setField((String)paramNames.get(i), visit);
        }
        return builder.build();
    }

    private SoyValue visitCheckNotNullFunction(ExprNode child) {
        SoyValue childValue = (SoyValue)this.visit(child);
        if (childValue instanceof NullData || childValue instanceof UndefinedData) {
            throw new SoyDataException(child.toSourceString() + " is null");
        }
        return childValue;
    }

    protected SoyValue computeFunctionHelper(SoyJavaFunction fn, List<SoyValue> args, FunctionNode fnNode) {
        if (fn instanceof DebugSoyTemplateInfoFunction) {
            return BooleanData.forValue(this.debugSoyTemplateInfo);
        }
        try {
            return fn.computeForJava(args);
        }
        catch (Exception e) {
            throw RenderException.create("While computing function \"" + fnNode.toSourceString() + "\": " + e.getMessage(), e);
        }
    }

    private SoyValue visitIsFirstFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex == 0);
    }

    private SoyValue visitIsLastFunction(FunctionNode node) {
        boolean isLast;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            isLast = this.env.isLast((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(isLast);
    }

    private SoyValue visitIndexFunction(FunctionNode node) {
        int localVarIndex;
        try {
            VarRefNode dataRef = (VarRefNode)node.getChild(0);
            localVarIndex = this.env.getIndex((LoopVar)dataRef.getDefnDecl());
        }
        catch (Exception e) {
            throw RenderException.create("Failed to evaluate function call " + node.toSourceString() + ".", e);
        }
        return this.convertResult(localVarIndex);
    }

    private SoyValue visitCssFunction(FunctionNode node) {
        List children = this.visitChildren(node);
        String selector = ((SoyValue)Iterables.getLast(children)).stringValue();
        String renamedSelector = this.cssRenamingMap.get(selector);
        if (renamedSelector == null) {
            renamedSelector = selector;
        }
        if (node.numChildren() == 1) {
            return StringData.forValue(renamedSelector);
        }
        String fullSelector = ((SoyValue)children.get(0)).stringValue() + "-" + renamedSelector;
        return StringData.forValue(fullSelector);
    }

    private SoyValue visitXidFunction(FunctionNode node) {
        String xid = ((SoyValue)this.visit(node.getChild(0))).stringValue();
        String renamed = this.xidRenamingMap.get(xid);
        return renamed != null ? StringData.forValue(renamed) : StringData.forValue(xid + "_");
    }

    private SoyValue convertResult(boolean b) {
        return BooleanData.forValue(b);
    }

    private SoyValue convertResult(long i) {
        return IntegerData.forValue(i);
    }

    private SoyValue convertResult(double f) {
        return FloatData.forValue(f);
    }

    private SoyValue convertResult(String s) {
        return StringData.forValue(s);
    }

    private static final class NullSafetySentinel
    extends SoyAbstractValue {
        public static final NullSafetySentinel INSTANCE = new NullSafetySentinel();

        private NullSafetySentinel() {
        }

        @Override
        public boolean equals(Object other) {
            return other == this;
        }

        public int hashCode() {
            return System.identityHashCode(this);
        }

        @Override
        public boolean coerceToBoolean() {
            return false;
        }

        @Override
        public String coerceToString() {
            return "null";
        }

        @Override
        public void render(LoggingAdvisingAppendable appendable) throws IOException {
            appendable.append(this.coerceToString());
        }
    }

    public static interface EvalVisitorFactory {
        public EvalVisitor create(Environment var1, @Nullable SoyRecord var2, @Nullable SoyCssRenamingMap var3, @Nullable SoyIdRenamingMap var4, boolean var5);
    }
}

