/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.collect.ImmutableMap;
import com.google.inject.AbstractModule;
import com.google.inject.Module;
import com.google.inject.Provides;
import com.google.template.soy.basicdirectives.BasicDirectivesModule;
import com.google.template.soy.basicfunctions.BasicFunctionsModule;
import com.google.template.soy.bididirectives.BidiDirectivesModule;
import com.google.template.soy.bidifunctions.BidiFunctionsModule;
import com.google.template.soy.coredirectives.CoreDirectivesModule;
import com.google.template.soy.data.SoyValueConverter;
import com.google.template.soy.i18ndirectives.I18nDirectivesModule;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.shared.internal.ApiCallScope;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.restricted.ApiCallScopeBindingAnnotations;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import java.util.Set;
import javax.inject.Singleton;

public final class SharedModule
extends AbstractModule {
    protected void configure() {
        this.install((Module)new CoreDirectivesModule());
        this.install((Module)new BasicDirectivesModule());
        this.install((Module)new BidiDirectivesModule());
        this.install((Module)new BasicFunctionsModule());
        this.install((Module)new BidiFunctionsModule());
        this.install((Module)new I18nDirectivesModule());
        GuiceSimpleScope apiCallScope = new GuiceSimpleScope();
        this.bindScope(ApiCallScope.class, apiCallScope);
        this.bind(GuiceSimpleScope.class).annotatedWith(ApiCallScopeBindingAnnotations.ApiCall.class).toInstance((Object)apiCallScope);
        this.bind(String.class).annotatedWith(ApiCallScopeBindingAnnotations.LocaleString.class).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
        this.bind(BidiGlobalDir.class).toProvider(GuiceSimpleScope.getUnscopedProvider()).in(ApiCallScope.class);
        this.bind(SoyValueConverter.class).in(Singleton.class);
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyFunction> provideSoyFunctionsMap(Set<SoyFunction> soyFunctionsSet) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (SoyFunction function : soyFunctionsSet) {
            mapBuilder.put((Object)function.getName(), (Object)function);
        }
        return mapBuilder.build();
    }

    @Provides
    @Singleton
    ImmutableMap<String, ? extends SoyPrintDirective> provideSoyDirectivesMap(Set<SoyPrintDirective> soyDirectivesSet) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (SoyPrintDirective directive : soyDirectivesSet) {
            mapBuilder.put((Object)directive.getName(), (Object)directive);
        }
        return mapBuilder.build();
    }

    public boolean equals(Object other) {
        return other != null && ((Object)((Object)this)).getClass().equals(other.getClass());
    }

    public int hashCode() {
        return ((Object)((Object)this)).getClass().hashCode();
    }
}

