/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.common.base.Preconditions;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.CallBasicNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.LinkedHashSet;
import java.util.Set;

public final class FindCalleesNotInFileVisitor
extends AbstractSoyNodeVisitor<Set<CallBasicNode>> {
    private Set<String> templatesInFile;
    private Set<CallBasicNode> calleesNotInFile;

    @Override
    public Set<CallBasicNode> exec(SoyNode node) {
        Preconditions.checkArgument((boolean)(node instanceof SoyFileNode));
        this.visit(node);
        return this.calleesNotInFile;
    }

    @Override
    protected void visitSoyFileNode(SoyFileNode node) {
        this.templatesInFile = new LinkedHashSet<String>();
        for (TemplateNode template : node.getChildren()) {
            this.templatesInFile.add(template.getTemplateName());
        }
        this.calleesNotInFile = new LinkedHashSet<CallBasicNode>();
        this.visitChildren(node);
    }

    @Override
    protected void visitCallBasicNode(CallBasicNode node) {
        String calleeName = node.getCalleeName();
        if (!this.templatesInFile.contains(calleeName)) {
            this.calleesNotInFile.add(node);
        }
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

