/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.base.Supplier;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multimap;
import com.google.common.io.Files;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.SoyBidiUtils;
import com.google.template.soy.pysrc.SoyPySrcOptions;
import com.google.template.soy.pysrc.internal.GenPyCallExprVisitor;
import com.google.template.soy.pysrc.internal.GenPyCodeVisitor;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.IsComputableAsPyExprVisitor;
import com.google.template.soy.shared.internal.ApiCallScopeUtils;
import com.google.template.soy.shared.internal.GuiceSimpleScope;
import com.google.template.soy.shared.internal.MainEntryPointUtils;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import java.io.BufferedWriter;
import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;

public final class PySrcMain {
    private final GuiceSimpleScope apiCallScope;

    public PySrcMain(GuiceSimpleScope apiCallScope) {
        this.apiCallScope = apiCallScope;
    }

    public List<String> genPySrc(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest, ErrorReporter errorReporter) {
        try (GuiceSimpleScope.InScope inScope = this.apiCallScope.enter();){
            BidiGlobalDir bidiGlobalDir = SoyBidiUtils.decodeBidiGlobalDirFromPyOptions(pySrcOptions.getBidiIsRtlFn());
            ApiCallScopeUtils.seedSharedParams(inScope, null, bidiGlobalDir);
            List<String> list = PySrcMain.createVisitor(pySrcOptions, currentManifest).gen(soyTree, errorReporter);
            return list;
        }
    }

    public void genPyFiles(SoyFileSetNode soyTree, SoyPySrcOptions pySrcOptions, String outputPathFormat, String inputPathsPrefix, ErrorReporter errorReporter) throws IOException {
        ImmutableList srcsToCompile = ImmutableList.copyOf((Iterable)Iterables.filter(soyTree.getChildren(), SoyFileNode.MATCH_SRC_FILENODE));
        List<String> soyNamespaces = this.getSoyNamespaces(soyTree);
        Multimap<String, Integer> outputs = MainEntryPointUtils.mapOutputsToSrcs(null, outputPathFormat, inputPathsPrefix, (ImmutableList<SoyFileNode>)srcsToCompile);
        ImmutableMap<String, String> manifest = PySrcMain.generateManifest(soyNamespaces, outputs);
        List<String> pyFileContents = this.genPySrc(soyTree, pySrcOptions, manifest, errorReporter);
        if (srcsToCompile.size() != pyFileContents.size()) {
            throw new AssertionError((Object)String.format("Expected to generate %d code chunk(s), got %d", srcsToCompile.size(), pyFileContents.size()));
        }
        for (String outputFilePath : outputs.keySet()) {
            BufferedWriter out = Files.newWriter((File)new File(outputFilePath), (Charset)StandardCharsets.UTF_8);
            Throwable throwable = null;
            try {
                Iterator iterator = outputs.get((Object)outputFilePath).iterator();
                while (iterator.hasNext()) {
                    int inputFileIndex = (Integer)iterator.next();
                    out.write(pyFileContents.get(inputFileIndex));
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (out == null) continue;
                if (throwable != null) {
                    try {
                        ((Writer)out).close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                ((Writer)out).close();
            }
        }
        if (pySrcOptions.namespaceManifestFile() != null) {
            try (BufferedWriter out = Files.newWriter((File)new File(pySrcOptions.namespaceManifestFile()), (Charset)StandardCharsets.UTF_8);){
                Properties prop = new Properties();
                for (String namespace : manifest.keySet()) {
                    prop.put(namespace, manifest.get((Object)namespace));
                }
                prop.store(out, null);
            }
        }
    }

    private static ImmutableMap<String, String> generateManifest(List<String> soyNamespaces, Multimap<String, Integer> outputs) {
        ImmutableMap.Builder manifest = new ImmutableMap.Builder();
        for (String outputFilePath : outputs.keySet()) {
            Iterator iterator = outputs.get((Object)outputFilePath).iterator();
            while (iterator.hasNext()) {
                int inputFileIndex = (Integer)iterator.next();
                String pythonPath = outputFilePath.replace(".py", "").replace('/', '.');
                manifest.put((Object)soyNamespaces.get(inputFileIndex), (Object)pythonPath);
            }
        }
        return manifest.build();
    }

    private List<String> getSoyNamespaces(SoyFileSetNode soyTree) {
        ArrayList<String> namespaces = new ArrayList<String>();
        for (SoyFileNode soyFile : soyTree.getChildren()) {
            namespaces.add(soyFile.getNamespace());
        }
        return namespaces;
    }

    @VisibleForTesting
    static GenPyCodeVisitor createVisitor(SoyPySrcOptions pySrcOptions, ImmutableMap<String, String> currentManifest) {
        GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsFactory;
        IsComputableAsPyExprVisitor isComputableAsPyExprs = new IsComputableAsPyExprVisitor();
        class PyCallExprVisitorSupplier
        implements Supplier<GenPyCallExprVisitor> {
            GenPyExprsVisitor.GenPyExprsVisitorFactory factory;
            final /* synthetic */ IsComputableAsPyExprVisitor val$isComputableAsPyExprs;

            PyCallExprVisitorSupplier(IsComputableAsPyExprVisitor isComputableAsPyExprVisitor) {
                this.val$isComputableAsPyExprs = isComputableAsPyExprVisitor;
            }

            public GenPyCallExprVisitor get() {
                return new GenPyCallExprVisitor(this.val$isComputableAsPyExprs, (GenPyExprsVisitor.GenPyExprsVisitorFactory)Preconditions.checkNotNull((Object)this.factory));
            }
        }
        PyCallExprVisitorSupplier provider = new PyCallExprVisitorSupplier(isComputableAsPyExprs);
        provider.factory = genPyExprsFactory = new GenPyExprsVisitor.GenPyExprsVisitorFactory(isComputableAsPyExprs, provider);
        return new GenPyCodeVisitor(pySrcOptions, currentManifest, isComputableAsPyExprs, genPyExprsFactory, provider.get());
    }
}

