/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.SanitizedContentKind;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.basetree.ParentNode;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.Condition;
import com.google.template.soy.passes.ConditionalBranches;
import com.google.template.soy.passes.HtmlTagEntry;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.CallParamContentNode;
import com.google.template.soy.soytree.ForeachIfemptyNode;
import com.google.template.soy.soytree.HtmlCloseTagNode;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPluralCaseNode;
import com.google.template.soy.soytree.MsgPluralDefaultNode;
import com.google.template.soy.soytree.MsgSelectCaseNode;
import com.google.template.soy.soytree.MsgSelectDefaultNode;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.SwitchCaseNode;
import com.google.template.soy.soytree.SwitchDefaultNode;
import com.google.template.soy.soytree.SwitchNode;
import com.google.template.soy.soytree.TagName;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.VeLogNode;
import java.util.ArrayDeque;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;

final class StrictHtmlValidationPass
extends CompilerFilePass {
    private static final SoyErrorKind STRICT_HTML_WITHOUT_AUTOESCAPE = SoyErrorKind.of("stricthtml=\"true\" must be used with autoescape=\"strict\".", SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind STRICT_HTML_WITH_NON_HTML = SoyErrorKind.of("stricthtml=\"true\" can only be used with kind=\"html\".", SoyErrorKind.StyleAllowance.NO_CAPS);
    private static final SoyErrorKind INVALID_SELF_CLOSING_TAG = SoyErrorKind.of("''{0}'' tag is not allowed to be self-closing.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_CLOSE_TAG = SoyErrorKind.of("''{0}'' tag is a void element and must not specify a close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind SWITCH_HTML_MODE_IN_BLOCK = SoyErrorKind.of("Foreign elements (svg) must be opened and closed within the same block.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NESTED_SVG = SoyErrorKind.of("Nested SVG tags are disallowed.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG = SoyErrorKind.of("Unexpected HTML close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNEXPECTED_CLOSE_TAG_IN_CONTROL = SoyErrorKind.of("Unexpected HTML close tag. Within an if or switch block, all branches must end with unmatched open tags or unmatched close tags.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VELOG_NODE_FIRST_CHILD_NOT_TAG = SoyErrorKind.of("The first child of '{velog'} must be a HTML open tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VELOG_NODE_LAST_CHILD_NOT_TAG = SoyErrorKind.of("The last child of '{velog'} must be a HTML close tag.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VELOG_NODE_EXACTLY_ONE_TAG = SoyErrorKind.of("'{velog'} must contain exactly one top-level HTML element.", new SoyErrorKind.StyleAllowance[0]);
    private final ErrorReporter errorReporter;

    StrictHtmlValidationPass(ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
    }

    @Override
    public void run(SoyFileNode file, IdGenerator nodeIdGen) {
        for (TemplateNode node : file.getChildren()) {
            this.checkTemplateNode(node);
        }
    }

    private void checkTemplateNode(TemplateNode node) {
        AutoescapeMode autoescapeMode = node.getAutoescapeMode();
        if (autoescapeMode != AutoescapeMode.STRICT && node.isStrictHtml()) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_HTML_WITHOUT_AUTOESCAPE, new Object[0]);
            return;
        }
        SanitizedContentKind contentKind = node.getContentKind();
        if (contentKind != SanitizedContentKind.HTML && node.isStrictHtml()) {
            this.errorReporter.report(node.getSourceLocation(), STRICT_HTML_WITH_NON_HTML, new Object[0]);
            return;
        }
        if (node.isStrictHtml()) {
            new HtmlTagVisitor(this.errorReporter).exec(node);
        }
    }

    private static final class HtmlTagVisitor
    extends AbstractSoyNodeVisitor<Void> {
        private Condition currentCondition = Condition.getEmptyCondition();
        private final ConditionalBranches openTagBranches = new ConditionalBranches();
        private final ConditionalBranches closeTagBranches = new ConditionalBranches();
        private final ArrayDeque<HtmlTagEntry> openTagStack = new ArrayDeque();
        private final ArrayDeque<HtmlTagEntry> closeTagQueue = new ArrayDeque();
        private boolean inForeignContent = false;
        private final Map<HtmlCloseTagNode, HtmlOpenTagNode> tagMatches = new IdentityHashMap<HtmlCloseTagNode, HtmlOpenTagNode>();
        private SourceLocation foreignContentStartLocation = SourceLocation.UNKNOWN;
        private SourceLocation foreignContentEndLocation = SourceLocation.UNKNOWN;
        private final ErrorReporter errorReporter;

        HtmlTagVisitor(ErrorReporter errorReporter) {
            this.errorReporter = errorReporter;
        }

        @Override
        protected void visitHtmlOpenTagNode(HtmlOpenTagNode node) {
            TagName openTag = node.getTagName();
            HtmlTagEntry entry = new HtmlTagEntry(node);
            if (openTag.isForeignContent()) {
                if (this.inForeignContent) {
                    this.errorReporter.report(node.getSourceLocation(), NESTED_SVG, new Object[0]);
                }
                this.inForeignContent = true;
                this.foreignContentStartLocation = node.getSourceLocation();
            }
            if (openTag.isStatic() && !this.inForeignContent && !openTag.isDefinitelyVoid() && node.isSelfClosing()) {
                this.errorReporter.report(node.getSourceLocation(), INVALID_SELF_CLOSING_TAG, openTag.getStaticTagName());
                return;
            }
            if (!node.isSelfClosing() && !openTag.isDefinitelyVoid()) {
                this.openTagStack.addFirst(entry);
            }
        }

        @Override
        protected void visitHtmlCloseTagNode(HtmlCloseTagNode node) {
            TagName closeTag = node.getTagName();
            HtmlTagEntry entry = new HtmlTagEntry(node);
            if (closeTag.isDefinitelyVoid()) {
                this.errorReporter.report(closeTag.getTagLocation(), INVALID_CLOSE_TAG, closeTag.getStaticTagName());
                return;
            }
            if (closeTag.isForeignContent()) {
                this.foreignContentEndLocation = node.getSourceLocation();
                this.inForeignContent = false;
            }
            if (!HtmlTagEntry.tryMatchCloseTag(this.openTagStack, entry, this.tagMatches, this.errorReporter)) {
                if (HtmlTagVisitor.isInControlBlock(node)) {
                    this.closeTagQueue.addLast(entry);
                } else {
                    this.errorReporter.report(closeTag.getTagLocation(), UNEXPECTED_CLOSE_TAG, new Object[0]);
                }
            }
        }

        @Override
        protected void visitIfNode(IfNode node) {
            ConditionalBranches outerOpenTagBranches = new ConditionalBranches(this.openTagBranches);
            ConditionalBranches outerCloseTagBranches = new ConditionalBranches(this.closeTagBranches);
            this.openTagBranches.clear();
            this.closeTagBranches.clear();
            this.visitChildren(node);
            if (!this.openTagBranches.isEmpty() && !this.closeTagBranches.isEmpty()) {
                this.errorReporter.report(this.closeTagBranches.getSourceLocation(), UNEXPECTED_CLOSE_TAG_IN_CONTROL, new Object[0]);
                this.openTagBranches.clear();
                this.closeTagBranches.clear();
            }
            if (!this.openTagBranches.isEmpty()) {
                this.openTagStack.addFirst(new HtmlTagEntry(this.openTagBranches));
                this.openTagBranches.clear();
            }
            if (!this.closeTagBranches.isEmpty()) {
                this.closeTagQueue.addLast(new HtmlTagEntry(this.closeTagBranches));
                this.closeTagBranches.clear();
            }
            HtmlTagEntry.tryMatchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
            this.openTagBranches.addAll(outerOpenTagBranches);
            this.closeTagBranches.addAll(outerCloseTagBranches);
        }

        @Override
        protected void visitIfCondNode(IfCondNode node) {
            Condition outerCondition = this.currentCondition.copy();
            this.currentCondition = Condition.createIfCondition(node.getExpr());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitIfElseNode(IfElseNode node) {
            Condition outerCondition = this.currentCondition.copy();
            this.currentCondition = Condition.createIfCondition();
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitSwitchNode(SwitchNode node) {
            ConditionalBranches outerOpenTagBranches = new ConditionalBranches(this.openTagBranches);
            ConditionalBranches outerCloseTagBranches = new ConditionalBranches(this.closeTagBranches);
            this.openTagBranches.clear();
            this.closeTagBranches.clear();
            this.visitChildren(node);
            if (!this.openTagBranches.isEmpty() && !this.closeTagBranches.isEmpty()) {
                this.errorReporter.report(this.closeTagBranches.getSourceLocation(), UNEXPECTED_CLOSE_TAG_IN_CONTROL, new Object[0]);
                this.openTagBranches.clear();
                this.closeTagBranches.clear();
            }
            if (!this.openTagBranches.isEmpty()) {
                this.openTagStack.addFirst(new HtmlTagEntry(this.openTagBranches));
                this.openTagBranches.clear();
            }
            if (!this.closeTagBranches.isEmpty()) {
                this.closeTagQueue.addLast(new HtmlTagEntry(this.closeTagBranches));
                this.closeTagBranches.clear();
            }
            HtmlTagEntry.tryMatchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
            this.openTagBranches.addAll(outerOpenTagBranches);
            this.closeTagBranches.addAll(outerCloseTagBranches);
        }

        @Override
        protected void visitSwitchCaseNode(SwitchCaseNode node) {
            Condition outerCondition = this.currentCondition.copy();
            SwitchNode parent = (SwitchNode)node.getParent();
            this.currentCondition = Condition.createSwitchCondition(parent.getExpr(), node.getExprList());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitSwitchDefaultNode(SwitchDefaultNode node) {
            Condition outerCondition = this.currentCondition.copy();
            SwitchNode parent = (SwitchNode)node.getParent();
            this.currentCondition = Condition.createSwitchCondition(parent.getExpr(), (List<ExprRootNode>)ImmutableList.of());
            this.visitBlockChildren(node, true);
            this.currentCondition = outerCondition.copy();
        }

        @Override
        protected void visitVeLogNode(VeLogNode node) {
            HtmlCloseTagNode lastTag;
            if (node.numChildren() == 0) {
                this.errorReporter.report(node.getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
                return;
            }
            Node firstChild = node.getChild(0);
            if (firstChild.getKind() != SoyNode.Kind.HTML_OPEN_TAG_NODE) {
                this.errorReporter.report(firstChild.getSourceLocation(), VELOG_NODE_FIRST_CHILD_NOT_TAG, new Object[0]);
                return;
            }
            HtmlOpenTagNode firstTag = (HtmlOpenTagNode)firstChild;
            if (node.numChildren() > 1 && (firstTag.isSelfClosing() || firstTag.getTagName().isDefinitelyVoid())) {
                this.errorReporter.report(((SoyNode.StandaloneNode)node.getChild(1)).getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
                return;
            }
            Node lastChild = node.getChild(node.numChildren() - 1);
            if (node.numChildren() > 1 && lastChild.getKind() != SoyNode.Kind.HTML_CLOSE_TAG_NODE) {
                this.errorReporter.report(lastChild.getSourceLocation(), VELOG_NODE_LAST_CHILD_NOT_TAG, new Object[0]);
                return;
            }
            this.visitBlockChildren(node, false);
            if (node.numChildren() > 1 && this.tagMatches.get(lastTag = (HtmlCloseTagNode)lastChild) != null && !this.tagMatches.get(lastTag).equals(firstTag)) {
                this.errorReporter.report(this.tagMatches.get(lastTag).getSourceLocation(), VELOG_NODE_EXACTLY_ONE_TAG, new Object[0]);
            }
        }

        @Override
        protected void visitTemplateNode(TemplateNode node) {
            ErrorReporter.Checkpoint checkpoint = this.errorReporter.checkpoint();
            this.visitChildren(node);
            if (this.errorReporter.errorsSince(checkpoint)) {
                return;
            }
            HtmlTagEntry.matchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
        }

        @Override
        protected void visitMsgNode(MsgNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitMsgPluralCaseNode(MsgPluralCaseNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitMsgPluralDefaultNode(MsgPluralDefaultNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitMsgSelectCaseNode(MsgSelectCaseNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitMsgSelectDefaultNode(MsgSelectDefaultNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitLetContentNode(LetContentNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitForeachIfemptyNode(ForeachIfemptyNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitLoopNode(SoyNode.LoopNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitCallParamContentNode(CallParamContentNode node) {
            this.visitBlockChildren(node, false);
        }

        @Override
        protected void visitSoyNode(SoyNode node) {
            if (node instanceof SoyNode.ParentSoyNode) {
                this.visitChildren((SoyNode.ParentSoyNode)node);
            }
        }

        private void visitBlockChildren(SoyNode.BlockNode node, boolean inControlBlock) {
            ArrayDeque<HtmlTagEntry> outerOpenTagStack = new ArrayDeque<HtmlTagEntry>();
            ArrayDeque<HtmlTagEntry> outerCloseTagQueue = new ArrayDeque<HtmlTagEntry>();
            outerOpenTagStack.addAll(this.openTagStack);
            outerCloseTagQueue.addAll(this.closeTagQueue);
            this.openTagStack.clear();
            this.closeTagQueue.clear();
            boolean inForeignContentBeforeBlock = this.inForeignContent;
            this.visitChildren(node);
            if (inControlBlock) {
                boolean matched = HtmlTagEntry.tryMatchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
                if (matched && !this.openTagStack.isEmpty() && !this.closeTagQueue.isEmpty()) {
                    throw new AssertionError((Object)"This should not happen. At least one of the stack/queue should be empty.");
                }
                if (!this.openTagStack.isEmpty() && this.closeTagQueue.isEmpty()) {
                    this.openTagBranches.add(this.currentCondition, this.openTagStack);
                }
                if (this.openTagStack.isEmpty() && !this.closeTagQueue.isEmpty()) {
                    this.closeTagBranches.add(this.currentCondition, this.closeTagQueue);
                }
            } else {
                HtmlTagEntry.matchOrError(this.openTagStack, this.closeTagQueue, this.errorReporter);
            }
            this.openTagStack.clear();
            this.closeTagQueue.clear();
            this.openTagStack.addAll(outerOpenTagStack);
            this.closeTagQueue.addAll(outerCloseTagQueue);
            if (this.inForeignContent != inForeignContentBeforeBlock) {
                this.errorReporter.report(this.inForeignContent ? this.foreignContentStartLocation : this.foreignContentEndLocation, SWITCH_HTML_MODE_IN_BLOCK, new Object[0]);
            }
            this.inForeignContent = inForeignContentBeforeBlock;
        }

        private static boolean isInControlBlock(SoyNode node) {
            ParentNode parent = node.getParent();
            if (parent instanceof TemplateNode || parent instanceof SoyFileNode || parent instanceof SoyFileSetNode) {
                return false;
            }
            if (parent instanceof IfCondNode || parent instanceof IfElseNode || parent instanceof SwitchCaseNode || parent instanceof SwitchDefaultNode) {
                return true;
            }
            return HtmlTagVisitor.isInControlBlock((SoyNode)((Object)parent));
        }
    }
}

