/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Equivalence;
import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionUpperBound;
import com.google.template.soy.basicfunctions.LegacyObjectMapToMapFunction;
import com.google.template.soy.basicfunctions.LengthFunction;
import com.google.template.soy.basicfunctions.MapToLegacyObjectMapFunction;
import com.google.template.soy.basicfunctions.ParseFloatFunction;
import com.google.template.soy.basicfunctions.ParseIntFunction;
import com.google.template.soy.basicfunctions.RangeFunction;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.error.SoyErrors;
import com.google.template.soy.exprtree.AbstractExprNodeVisitor;
import com.google.template.soy.exprtree.AbstractOperatorNode;
import com.google.template.soy.exprtree.AbstractParentExprNode;
import com.google.template.soy.exprtree.ExprEquivalence;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.FieldAccessNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.ItemAccessNode;
import com.google.template.soy.exprtree.LegacyObjectMapLiteralNode;
import com.google.template.soy.exprtree.ListLiteralNode;
import com.google.template.soy.exprtree.MapLiteralNode;
import com.google.template.soy.exprtree.OperatorNodes;
import com.google.template.soy.exprtree.ProtoInitNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.exprtree.VarRefNode;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.internal.BuiltinFunction;
import com.google.template.soy.shared.restricted.SoyFunction;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.ForeachNonemptyNode;
import com.google.template.soy.soytree.IfCondNode;
import com.google.template.soy.soytree.IfElseNode;
import com.google.template.soy.soytree.IfNode;
import com.google.template.soy.soytree.LetContentNode;
import com.google.template.soy.soytree.LetValueNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.LoopVar;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.SoyTypeRegistry;
import com.google.template.soy.types.SoyTypes;
import com.google.template.soy.types.aggregate.AbstractMapType;
import com.google.template.soy.types.aggregate.LegacyObjectMapType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.aggregate.MapType;
import com.google.template.soy.types.aggregate.RecordType;
import com.google.template.soy.types.aggregate.UnionType;
import com.google.template.soy.types.primitive.AnyType;
import com.google.template.soy.types.primitive.BoolType;
import com.google.template.soy.types.primitive.ErrorType;
import com.google.template.soy.types.primitive.FloatType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.NullType;
import com.google.template.soy.types.primitive.SanitizedType;
import com.google.template.soy.types.primitive.StringType;
import com.google.template.soy.types.primitive.UnknownType;
import com.google.template.soy.types.proto.SoyProtoType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.annotation.Nullable;

final class ResolveExpressionTypesVisitor
extends AbstractSoyNodeVisitor<Void> {
    private static final SoyErrorKind BAD_FOREACH_TYPE = SoyErrorKind.of("Cannot iterate over {0} of type {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_INDEX_TYPE = SoyErrorKind.of("Bad index type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BAD_KEY_TYPE = SoyErrorKind.of("Bad key type {0} for {1}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support bracket access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind BRACKET_ACCESS_NULLABLE_UNION = SoyErrorKind.of("Union type that is nullable cannot use bracket access. To access this value, first check for null or use null-safe (\"?[\") operations.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind CHECK_NOT_NULL_ON_COMPILE_TIME_NULL = SoyErrorKind.of("Cannot call checkNotNull on a parameter with a static type of ''null''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED = SoyErrorKind.of("Type {0} does not support dot access.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD = SoyErrorKind.of("Type {0} does not support dot access (consider record instead of map).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind DUPLICATE_KEY_IN_MAP_OR_RECORD_LITERAL = SoyErrorKind.of("{0} literals with duplicate keys are not allowed.  Duplicate key: ''{1}''", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_ACCESS = SoyErrorKind.of("Accessing item in empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_LIST_FOREACH = SoyErrorKind.of("Cannot iterate over empty list.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EMPTY_MAP_ACCESS = SoyErrorKind.of("Accessing item in empty map.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind EXPERIMENTAL_MAP_PLUGIN_NOT_ALLOWED = SoyErrorKind.of("Function ''{0}'' is not allowed for general use yet.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INVALID_TYPE_SUBSTITUTION = SoyErrorKind.of("Expected expression of type ''{0}'', found ''{1}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LIST_LENGTH_ERROR = SoyErrorKind.of("Soy lists do not have a ''length'' field. Use function length(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for node {0}.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind NOT_A_PROTO_TYPE = SoyErrorKind.of("''{0}'' is a ''{1}'', expected a protocol buffer.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRING_LENGTH_ERROR = SoyErrorKind.of("Soy strings do not have a ''length'' field. Use function strLen(...) instead.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_PROTO_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for proto type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind UNDEFINED_FIELD_FOR_RECORD_TYPE = SoyErrorKind.of("Undefined field ''{0}'' for record type {1}.{2}", SoyErrorKind.StyleAllowance.NO_PUNCTUATION);
    private static final SoyErrorKind PROTO_MAP_FIELDS_DONT_WORK = SoyErrorKind.of("Field ''{0}'' on proto ''{1}'' is a map field. Proto map fields are broken in Soy. While we are fixing them, you can''t use them.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNKNOWN_PROTO_TYPE = SoyErrorKind.of("Unknown proto type ''{0}''.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind VAR_REF_MISSING_SOY_TYPE = SoyErrorKind.of("Missing Soy type for variable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind TYPE_MISMATCH = SoyErrorKind.of("Soy types ''{0}'' and ''{1}'' are not comparable.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCOMPATIBLE_AIRTHMETIC_OP = SoyErrorKind.of("Using arithmetic operators on Soy types ''{0}'' and ''{1}'' is illegal.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind INCORRECT_ARG_TYPE = SoyErrorKind.of("Function ''{0}'' called with incorrect arg type {1} (expected {2}).", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind LOOP_VARIABLE_NOT_IN_SCOPE = SoyErrorKind.of("Function ''{0}'' must have a foreach loop variable as its argument.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind STRING_LITERAL_REQUIRED = SoyErrorKind.of("Argument to function ''{0}'' must be a string literal.", new SoyErrorKind.StyleAllowance[0]);
    private final SyntaxVersion declaredSyntaxVersion;
    private final ErrorReporter errorReporter;
    private final SoyGeneralOptions generalOptions;
    private final SoyTypeRegistry typeRegistry;
    private TypeSubstitution substitutions;

    ResolveExpressionTypesVisitor(SoyTypeRegistry typeRegistry, SyntaxVersion declaredSyntaxVersion, SoyGeneralOptions generalOptions, ErrorReporter errorReporter) {
        this.errorReporter = errorReporter;
        this.typeRegistry = typeRegistry;
        this.generalOptions = generalOptions;
        this.declaredSyntaxVersion = declaredSyntaxVersion;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.visitSoyNode(node);
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        this.visitSoyNode(node);
        ExprRootNode expr = node.getExpr();
        if (expr != null && expr.getType().equals(BoolType.getInstance())) {
            String errorMsg = "Bool values can no longer be printed";
            if (this.declaredSyntaxVersion.num >= SyntaxVersion.V2_3.num && expr.getRoot() instanceof OperatorNodes.OrOpNode) {
                errorMsg = errorMsg + " (if you're intending the 'or' operator to return one of the operands instead of bool, please use the binary null-coalescing operator '?:' instead)";
            }
            errorMsg = errorMsg + ".";
            node.maybeSetSyntaxVersionUpperBound(new SyntaxVersionUpperBound(SyntaxVersion.V2_3, errorMsg));
        }
    }

    @Override
    protected void visitLetValueNode(LetValueNode node) {
        this.visitSoyNode(node);
        node.getVar().setType(node.getExpr().getType());
    }

    @Override
    protected void visitLetContentNode(LetContentNode node) {
        this.visitSoyNode(node);
        node.getVar().setType(node.getContentKind() != null ? SanitizedType.getTypeForContentKind(node.getContentKind()) : StringType.getInstance());
    }

    @Override
    protected void visitIfNode(IfNode node) {
        TypeSubstitution savedSubstitutionState = this.substitutions;
        for (SoyNode child : node.getChildren()) {
            if (child instanceof IfCondNode) {
                IfCondNode icn = (IfCondNode)child;
                this.visitExpressions(icn);
                TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
                visitor.exec(icn.getExpr());
                TypeSubstitution previousSubstitutionState = this.substitutions;
                this.addTypeSubstitutions(visitor.positiveTypeConstraints);
                this.visitChildren(icn);
                this.substitutions = previousSubstitutionState;
                this.addTypeSubstitutions(visitor.negativeTypeConstraints);
                continue;
            }
            if (!(child instanceof IfElseNode)) continue;
            IfElseNode ien = (IfElseNode)child;
            this.visitChildren(ien);
        }
        this.substitutions = savedSubstitutionState;
    }

    private void addTypeSubstitutions(Map<Equivalence.Wrapper<ExprNode>, SoyType> substitutionsToAdd) {
        for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : substitutionsToAdd.entrySet()) {
            ExprNode expr = (ExprNode)entry.getKey().get();
            SoyType previousType = expr.getType();
            TypeSubstitution subst = this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    previousType = subst.type;
                    break;
                }
                subst = subst.parent;
            }
            if (entry.getValue().equals(previousType)) continue;
            this.substitutions = new TypeSubstitution(this.substitutions, expr, entry.getValue());
        }
    }

    @Override
    protected void visitForeachNonemptyNode(ForeachNonemptyNode node) {
        this.visitExpressions(node.getParent());
        node.getVar().setType(this.getElementType(node.getExpr().getType(), node));
        this.visitChildren(node);
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ExprHolderNode) {
            this.visitExpressions((SoyNode.ExprHolderNode)node);
        }
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }

    private void visitExpressions(SoyNode.ExprHolderNode node) {
        ResolveTypesExprVisitor exprVisitor = new ResolveTypesExprVisitor();
        for (ExprRootNode expr : node.getExprList()) {
            exprVisitor.exec(expr);
        }
    }

    private SoyType getElementType(SoyType collectionType, ForeachNonemptyNode node) {
        Preconditions.checkNotNull((Object)collectionType);
        switch (collectionType.getKind()) {
            case UNKNOWN: {
                return UnknownType.getInstance();
            }
            case LIST: {
                if (collectionType == ListType.EMPTY_LIST) {
                    this.errorReporter.report(node.getParent().getSourceLocation(), EMPTY_LIST_FOREACH, new Object[0]);
                    return ErrorType.getInstance();
                }
                return ((ListType)collectionType).getElementType();
            }
            case UNION: {
                UnionType unionType = (UnionType)collectionType;
                ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                for (SoyType unionMember : unionType.getMembers()) {
                    SoyType elementType = this.getElementType(unionMember, node);
                    if (elementType.getKind() == SoyType.Kind.ERROR) {
                        return ErrorType.getInstance();
                    }
                    fieldTypes.add(elementType);
                }
                return SoyTypes.computeLowestCommonType(this.typeRegistry, fieldTypes);
            }
        }
        this.errorReporter.report(node.getParent().getSourceLocation(), BAD_FOREACH_TYPE, node.getExpr().toSourceString(), node.getExpr().getType());
        return ErrorType.getInstance();
    }

    private static final class TypeSubstitution {
        @Nullable
        final TypeSubstitution parent;
        final ExprNode expression;
        final SoyType type;

        TypeSubstitution(@Nullable TypeSubstitution parent, ExprNode expression, SoyType type) {
            this.parent = parent;
            this.expression = expression;
            this.type = type;
        }
    }

    private final class TypeNarrowingConditionVisitor
    extends AbstractExprNodeVisitor<Void> {
        Map<Equivalence.Wrapper<ExprNode>, SoyType> positiveTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();
        Map<Equivalence.Wrapper<ExprNode>, SoyType> negativeTypeConstraints = new LinkedHashMap<Equivalence.Wrapper<ExprNode>, SoyType>();

        private TypeNarrowingConditionVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            this.visit(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitAndImplicitlyCastToBoolean(node.getRoot());
        }

        void visitAndImplicitlyCastToBoolean(ExprNode node) {
            this.visit(node);
            Equivalence.Wrapper wrapped = ExprEquivalence.get().wrap(node);
            this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, SoyTypes.tryRemoveNull(node.getType()));
            this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrapped, node.getType());
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            Preconditions.checkArgument((node.getChildren().size() == 2 ? 1 : 0) != 0);
            TypeNarrowingConditionVisitor leftVisitor = new TypeNarrowingConditionVisitor();
            TypeNarrowingConditionVisitor rightVisitor = new TypeNarrowingConditionVisitor();
            leftVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            rightVisitor.visitAndImplicitlyCastToBoolean(node.getChild(1));
            this.positiveTypeConstraints.putAll(this.computeConstraintIntersection(leftVisitor.positiveTypeConstraints, rightVisitor.positiveTypeConstraints));
            this.negativeTypeConstraints.putAll(this.computeConstraintUnion(leftVisitor.negativeTypeConstraints, rightVisitor.negativeTypeConstraints));
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            TypeNarrowingConditionVisitor childVisitor = new TypeNarrowingConditionVisitor();
            childVisitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            this.positiveTypeConstraints.putAll(childVisitor.negativeTypeConstraints);
            this.negativeTypeConstraints.putAll(childVisitor.positiveTypeConstraints);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            if (node.getChild(1).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getChild(0).getKind() == ExprNode.Kind.NULL_NODE) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(1));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            }
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            if (node.numChildren() != 1) {
                return;
            }
            if (node.getFunctionName().equals("isNonnull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
            } else if (node.getFunctionName().equals("isNull")) {
                Equivalence.Wrapper wrappedExpr = ExprEquivalence.get().wrap(node.getChild(0));
                this.positiveTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, NullType.getInstance());
                this.negativeTypeConstraints.put((Equivalence.Wrapper<ExprNode>)wrappedExpr, SoyTypes.tryRemoveNull(((ExprNode)wrappedExpr.get()).getType()));
            }
        }

        @Override
        protected void visitExprNode(ExprNode node) {
            if (node instanceof ExprNode.ParentExprNode) {
                this.visitChildren((ExprNode.ParentExprNode)node);
            }
        }

        private <T> Map<T, SoyType> computeConstraintUnion(Map<T, SoyType> left, Map<T, SoyType> right) {
            if (left.isEmpty()) {
                return right;
            }
            if (right.isEmpty()) {
                return left;
            }
            LinkedHashMap<T, SoyType> result = new LinkedHashMap<T, SoyType>(left);
            for (Map.Entry<T, SoyType> entry : right.entrySet()) {
                if (left.containsKey(entry.getKey())) continue;
                result.put(entry.getKey(), entry.getValue());
            }
            return result;
        }

        private Map<Equivalence.Wrapper<ExprNode>, SoyType> computeConstraintIntersection(Map<Equivalence.Wrapper<ExprNode>, SoyType> left, Map<Equivalence.Wrapper<ExprNode>, SoyType> right) {
            if (left.isEmpty()) {
                return left;
            }
            if (right.isEmpty()) {
                return right;
            }
            HashMap result = Maps.newHashMapWithExpectedSize((int)left.size());
            for (Map.Entry<Equivalence.Wrapper<ExprNode>, SoyType> entry : left.entrySet()) {
                if (!right.containsKey(entry.getKey())) continue;
                SoyType rightSideType = right.get(entry.getKey());
                result.put(entry.getKey(), SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, entry.getValue(), rightSideType));
            }
            return result;
        }
    }

    private final class ResolveTypesExprVisitor
    extends AbstractExprNodeVisitor<Void> {
        private final AbstractExprNodeVisitor<Void> checkAllTypesAssignedVisitor = new AbstractExprNodeVisitor<Void>(){

            @Override
            protected void visitExprNode(ExprNode node) {
                if (node instanceof ExprNode.ParentExprNode) {
                    this.visitChildren((ExprNode.ParentExprNode)node);
                }
                ResolveTypesExprVisitor.this.requireNodeType(node);
            }
        };

        private ResolveTypesExprVisitor() {
        }

        @Override
        public Void exec(ExprNode node) {
            Preconditions.checkArgument((boolean)(node instanceof ExprRootNode));
            this.visit(node);
            this.checkAllTypesAssignedVisitor.exec(node);
            return null;
        }

        @Override
        protected void visitExprRootNode(ExprRootNode node) {
            this.visitChildren(node);
            ExprNode expr = node.getRoot();
            node.setType(expr.getType());
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitPrimitiveNode(ExprNode.PrimitiveNode node) {
        }

        @Override
        protected void visitListLiteralNode(ListLiteralNode node) {
            this.visitChildren(node);
            ArrayList<SoyType> elementTypes = new ArrayList<SoyType>(node.getChildren().size());
            for (ExprNode child : node.getChildren()) {
                this.requireNodeType(child);
                elementTypes.add(child.getType());
            }
            if (elementTypes.isEmpty()) {
                node.setType(ListType.EMPTY_LIST);
            } else {
                node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateListType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, elementTypes)));
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitLegacyObjectMapLiteralNode(LegacyObjectMapLiteralNode node) {
            this.visitChildren(node);
            this.setMapLiteralNodeType(node);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMapLiteralNode(MapLiteralNode node) {
            this.visitChildren(node);
            this.setMapLiteralNodeType(node);
            this.tryApplySubstitution(node);
        }

        private void setMapLiteralNodeType(AbstractParentExprNode node) {
            ExprNode.Kind nodeKind = node.getKind();
            Preconditions.checkState((nodeKind == ExprNode.Kind.MAP_LITERAL_NODE || nodeKind == ExprNode.Kind.LEGACY_OBJECT_MAP_LITERAL_NODE ? 1 : 0) != 0);
            int numChildren = node.numChildren();
            Preconditions.checkState((numChildren % 2 == 0 ? 1 : 0) != 0);
            if (numChildren == 0) {
                node.setType(nodeKind == ExprNode.Kind.MAP_LITERAL_NODE ? MapType.EMPTY_MAP : LegacyObjectMapType.EMPTY_MAP);
                return;
            }
            HashSet<String> duplicateKeyErrors = new HashSet<String>();
            LinkedHashMap<String, SoyType> recordFieldTypes = new LinkedHashMap<String, SoyType>();
            ArrayList<SoyType> keyTypes = new ArrayList<SoyType>(numChildren / 2);
            ArrayList<SoyType> valueTypes = new ArrayList<SoyType>(numChildren / 2);
            for (int i = 0; i < numChildren; i += 2) {
                String fieldName;
                SoyType prev;
                ExprNode key = node.getChild(i);
                ExprNode value = node.getChild(i + 1);
                if (key.getKind() == ExprNode.Kind.STRING_NODE && (prev = recordFieldTypes.put(fieldName = ((StringNode)key).getValue(), value.getType())) != null && duplicateKeyErrors.add(fieldName)) {
                    ResolveExpressionTypesVisitor.this.errorReporter.report(key.getSourceLocation(), DUPLICATE_KEY_IN_MAP_OR_RECORD_LITERAL, nodeKind == ExprNode.Kind.MAP_LITERAL_NODE ? "Map" : "Record", fieldName);
                }
                keyTypes.add(key.getType());
                valueTypes.add(value.getType());
            }
            SoyType commonKeyType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, keyTypes);
            SoyType commonValueType = SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, valueTypes);
            if (nodeKind == ExprNode.Kind.LEGACY_OBJECT_MAP_LITERAL_NODE && StringType.getInstance().isAssignableFrom(commonKeyType) && recordFieldTypes.size() == numChildren / 2) {
                HashMap leastCommonFieldTypes = Maps.newHashMapWithExpectedSize((int)recordFieldTypes.size());
                for (String fieldName : recordFieldTypes.keySet()) {
                    leastCommonFieldTypes.put(fieldName, recordFieldTypes.get(fieldName));
                }
                node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateRecordType(leastCommonFieldTypes));
            } else {
                node.setType(nodeKind == ExprNode.Kind.MAP_LITERAL_NODE ? ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateMapType(commonKeyType, commonValueType) : ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateLegacyObjectMapType(commonKeyType, commonValueType));
            }
        }

        @Override
        protected void visitVarRefNode(VarRefNode varRef) {
            SoyType newType;
            if (varRef.getType() == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(varRef.getSourceLocation(), VAR_REF_MISSING_SOY_TYPE, new Object[0]);
            }
            if ((newType = this.getTypeSubstitution(varRef)) != null) {
                varRef.setSubstituteType(newType);
            }
        }

        @Override
        protected void visitFieldAccessNode(FieldAccessNode node) {
            this.visit(node.getBaseExprChild());
            node.setType(this.getFieldType(node.getBaseExprChild().getType(), node.getFieldName(), node.getSourceLocation()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitItemAccessNode(ItemAccessNode node) {
            this.visit(node.getBaseExprChild());
            this.visit(node.getKeyExprChild());
            SoyType itemType = this.getItemType(node.getBaseExprChild().getType(), node.getKeyExprChild().getType(), node.isNullSafe(), node.getSourceLocation(), node.getKeyExprChild().getSourceLocation());
            node.setType(itemType);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitGlobalNode(GlobalNode node) {
        }

        @Override
        protected void visitNegativeOpNode(OperatorNodes.NegativeOpNode node) {
            this.visitChildren(node);
            SoyType childType = node.getChild(0).getType();
            if (SoyTypes.isNumericOrUnknown(childType)) {
                node.setType(childType);
            } else {
                node.setType(UnknownType.getInstance());
            }
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitNotOpNode(OperatorNodes.NotOpNode node) {
            this.visitChildren(node);
            node.setType(BoolType.getInstance());
        }

        @Override
        protected void visitTimesOpNode(OperatorNodes.TimesOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitDivideByOpNode(OperatorNodes.DivideByOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitModOpNode(OperatorNodes.ModOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitPlusOpNode(OperatorNodes.PlusOpNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypePlusOperator());
            if (result == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), INCOMPATIBLE_AIRTHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(result);
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitMinusOpNode(OperatorNodes.MinusOpNode node) {
            this.visitArithmeticOpNode(node);
        }

        @Override
        protected void visitLessThanOpNode(OperatorNodes.LessThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOpNode(OperatorNodes.GreaterThanOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitLessThanOrEqualOpNode(OperatorNodes.LessThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitGreaterThanOrEqualOpNode(OperatorNodes.GreaterThanOrEqualOpNode node) {
            this.visitComparisonOpNode(node);
        }

        @Override
        protected void visitEqualOpNode(OperatorNodes.EqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitNotEqualOpNode(OperatorNodes.NotEqualOpNode node) {
            this.visitEqualComparisonOpNode(node);
        }

        @Override
        protected void visitAndOpNode(OperatorNodes.AndOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            this.markLogicalOpType(node);
        }

        @Override
        protected void visitOrOpNode(OperatorNodes.OrOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            this.markLogicalOpType(node);
        }

        @Override
        protected void visitNullCoalescingOpNode(OperatorNodes.NullCoalescingOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, node.getChild(0).getType(), node.getChild(1).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitConditionalOpNode(OperatorNodes.ConditionalOpNode node) {
            this.visit(node.getChild(0));
            TypeSubstitution savedSubstitutionState = ResolveExpressionTypesVisitor.this.substitutions;
            TypeNarrowingConditionVisitor visitor = new TypeNarrowingConditionVisitor();
            visitor.visitAndImplicitlyCastToBoolean(node.getChild(0));
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.positiveTypeConstraints);
            this.visit(node.getChild(1));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            ResolveExpressionTypesVisitor.this.addTypeSubstitutions(visitor.negativeTypeConstraints);
            this.visit(node.getChild(2));
            ResolveExpressionTypesVisitor.this.substitutions = savedSubstitutionState;
            node.setType(SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, node.getChild(1).getType(), node.getChild(2).getType()));
            this.tryApplySubstitution(node);
        }

        @Override
        protected void visitFunctionNode(FunctionNode node) {
            this.visitChildren(node);
            SoyFunction knownFunction = node.getSoyFunction();
            if (knownFunction instanceof BuiltinFunction) {
                this.visitBuiltinFunction((BuiltinFunction)knownFunction, node);
            } else {
                this.visitSoyFunction(knownFunction, node);
            }
            this.tryApplySubstitution(node);
        }

        private void visitLegacyObjectMapToMapFunction(FunctionNode node) {
            SoyType argType;
            if (!ResolveExpressionTypesVisitor.this.generalOptions.getExperimentalFeatures().contains((Object)"experimental_map")) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), EXPERIMENTAL_MAP_PLUGIN_NOT_ALLOWED, "legacyObjectMapToMap");
            }
            if ((argType = node.getChild(0).getType()).isAssignableFrom(UnknownType.getInstance())) {
                node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateMapType(UnknownType.getInstance(), UnknownType.getInstance()));
                return;
            }
            LegacyObjectMapType actualArgType = (LegacyObjectMapType)argType;
            node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateMapType(actualArgType.getKeyType(), actualArgType.getValueType()));
        }

        private void visitMapToLegacyObjectMapFunction(FunctionNode node) {
            if (!ResolveExpressionTypesVisitor.this.generalOptions.getExperimentalFeatures().contains((Object)"experimental_map")) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), EXPERIMENTAL_MAP_PLUGIN_NOT_ALLOWED, "mapToLegacyObjectMap");
            }
            SoyType argType = node.getChild(0).getType();
            MapType actualArgType = (MapType)argType;
            node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateLegacyObjectMapType(actualArgType.getKeyType(), actualArgType.getValueType()));
        }

        @Override
        protected void visitProtoInitNode(ProtoInitNode node) {
            this.visitChildren(node);
            String protoName = node.getProtoName();
            SoyType type = ResolveExpressionTypesVisitor.this.typeRegistry.getType(protoName);
            if (type == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), UNKNOWN_PROTO_TYPE, protoName);
                node.setType(ErrorType.getInstance());
            } else if (type.getKind() != SoyType.Kind.PROTO && type.getKind() != SoyType.Kind.PROTO_ENUM) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), NOT_A_PROTO_TYPE, protoName, type);
                node.setType(ErrorType.getInstance());
            } else {
                node.setType(type);
            }
        }

        private void markLogicalOpType(AbstractOperatorNode node) {
            if (((ResolveExpressionTypesVisitor)ResolveExpressionTypesVisitor.this).declaredSyntaxVersion.num >= SyntaxVersion.V2_3.num) {
                node.setType(BoolType.getInstance());
            } else {
                node.setType(UnknownType.getInstance());
            }
        }

        private void visitComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeComparisonOp());
            if (result == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitEqualComparisonOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeEqualComparisonOp());
            if (result == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), TYPE_MISMATCH, left, right);
            }
            node.setType(BoolType.getInstance());
        }

        private void visitArithmeticOpNode(AbstractOperatorNode node) {
            this.visitChildren(node);
            boolean isDivide = node instanceof OperatorNodes.DivideByOpNode;
            SoyType left = node.getChild(0).getType();
            SoyType right = node.getChild(1).getType();
            SoyType result = SoyTypes.getSoyTypeForBinaryOperator(left, right, new SoyTypes.SoyTypeArithmeticOperator());
            if (result == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), INCOMPATIBLE_AIRTHMETIC_OP, left, right);
                result = UnknownType.getInstance();
            }
            node.setType(isDivide ? FloatType.getInstance() : result);
            this.tryApplySubstitution(node);
        }

        private void requireNodeType(ExprNode node) {
            if (node.getType() == null) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), MISSING_SOY_TYPE, node.getClass().getName());
            }
        }

        private SoyType getFieldType(SoyType baseType, String fieldName, SourceLocation sourceLocation) {
            Preconditions.checkNotNull((Object)baseType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case STRING: 
                case CSS: 
                case JS: 
                case ATTRIBUTES: 
                case HTML: 
                case URI: {
                    if (!fieldName.equals("length")) break;
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, STRING_LENGTH_ERROR, new Object[0]);
                    return ErrorType.getInstance();
                }
                case LIST: {
                    if (!fieldName.equals("length")) break;
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, LIST_LENGTH_ERROR, new Object[0]);
                    return ErrorType.getInstance();
                }
                case RECORD: {
                    RecordType recordType = (RecordType)baseType;
                    SoyType fieldType = recordType.getFieldType(fieldName);
                    if (fieldType != null) {
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessage(recordType.getFieldNames(), fieldName);
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_RECORD_TYPE, fieldName, baseType, extraErrorMessage);
                    return ErrorType.getInstance();
                }
                case PROTO: {
                    SoyProtoType protoType = (SoyProtoType)baseType;
                    SoyType fieldType = protoType.getFieldType(fieldName);
                    if (fieldType != null) {
                        if (protoType.getFieldDescriptor(fieldName).isMapField() && !ResolveExpressionTypesVisitor.this.generalOptions.getExperimentalFeatures().contains((Object)"experimental_map")) {
                            ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, PROTO_MAP_FIELDS_DONT_WORK, fieldName, baseType);
                            return ErrorType.getInstance();
                        }
                        return fieldType;
                    }
                    String extraErrorMessage = SoyErrors.getDidYouMeanMessageForProtoFields(protoType.getFieldNames(), fieldName);
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, UNDEFINED_FIELD_FOR_PROTO_TYPE, fieldName, baseType, extraErrorMessage);
                    return ErrorType.getInstance();
                }
                case LEGACY_OBJECT_MAP: {
                    ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED_CONSIDER_RECORD, baseType);
                    return ErrorType.getInstance();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> fieldTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.getKind() == SoyType.Kind.NULL) continue;
                        SoyType fieldType = this.getFieldType(unionMember, fieldName, sourceLocation);
                        if (fieldType == ErrorType.getInstance()) {
                            return fieldType;
                        }
                        fieldTypes.add(fieldType);
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, fieldTypes);
                }
                case ERROR: {
                    return ErrorType.getInstance();
                }
            }
            ResolveExpressionTypesVisitor.this.errorReporter.report(sourceLocation, DOT_ACCESS_NOT_SUPPORTED, baseType);
            return ErrorType.getInstance();
        }

        private SoyType getItemType(SoyType baseType, SoyType keyType, boolean isNullSafe, SourceLocation baseLocation, SourceLocation keyLocation) {
            Preconditions.checkNotNull((Object)baseType);
            Preconditions.checkNotNull((Object)keyType);
            switch (baseType.getKind()) {
                case UNKNOWN: {
                    return UnknownType.getInstance();
                }
                case LIST: {
                    ListType listType = (ListType)baseType;
                    if (listType.equals(ListType.EMPTY_LIST)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(baseLocation, EMPTY_LIST_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !IntType.getInstance().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(keyLocation, BAD_INDEX_TYPE, keyType, baseType);
                    }
                    return listType.getElementType();
                }
                case LEGACY_OBJECT_MAP: 
                case MAP: {
                    AbstractMapType mapType = (AbstractMapType)baseType;
                    if (mapType.equals(LegacyObjectMapType.EMPTY_MAP) || mapType.equals(MapType.EMPTY_MAP)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(baseLocation, EMPTY_MAP_ACCESS, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    if (keyType.getKind() != SoyType.Kind.UNKNOWN && !mapType.getKeyType().isAssignableFrom(keyType)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(keyLocation, BAD_KEY_TYPE, keyType, baseType);
                    }
                    return mapType.getValueType();
                }
                case UNION: {
                    UnionType unionType = (UnionType)baseType;
                    ArrayList<SoyType> itemTypes = new ArrayList<SoyType>(unionType.getMembers().size());
                    for (SoyType unionMember : unionType.getMembers()) {
                        if (unionMember.equals(NullType.getInstance())) continue;
                        SoyType itemType = this.getItemType(unionMember, keyType, isNullSafe, baseLocation, keyLocation);
                        if (itemType == ErrorType.getInstance()) {
                            return itemType;
                        }
                        itemTypes.add(itemType);
                    }
                    if (unionType.isNullable() && !isNullSafe) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NULLABLE_UNION, new Object[0]);
                        return ErrorType.getInstance();
                    }
                    return SoyTypes.computeLowestCommonType(ResolveExpressionTypesVisitor.this.typeRegistry, itemTypes);
                }
                case ERROR: {
                    return ErrorType.getInstance();
                }
            }
            ResolveExpressionTypesVisitor.this.errorReporter.report(baseLocation, BRACKET_ACCESS_NOT_SUPPORTED, baseType);
            return ErrorType.getInstance();
        }

        private void tryApplySubstitution(AbstractParentExprNode parentNode) {
            SoyType newType = this.getTypeSubstitution(parentNode);
            if (newType != null) {
                if (!parentNode.getType().isAssignableFrom(newType)) {
                    ResolveExpressionTypesVisitor.this.errorReporter.report(parentNode.getSourceLocation(), INVALID_TYPE_SUBSTITUTION, parentNode.getType(), newType);
                }
                parentNode.setType(newType);
            }
        }

        @Nullable
        private SoyType getTypeSubstitution(ExprNode expr) {
            TypeSubstitution subst = ResolveExpressionTypesVisitor.this.substitutions;
            while (subst != null) {
                if (ExprEquivalence.get().equivalent(subst.expression, expr)) {
                    return subst.type;
                }
                subst = subst.parent;
            }
            return null;
        }

        private void visitBuiltinFunction(BuiltinFunction builtinFunction, FunctionNode node) {
            ExprNode arg1 = node.getChild(0);
            switch (builtinFunction) {
                case CHECK_NOT_NULL: {
                    SoyType type = node.getChild(0).getType();
                    if (type.equals(NullType.getInstance())) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(node.getSourceLocation(), CHECK_NOT_NULL_ON_COMPILE_TIME_NULL, new Object[0]);
                        break;
                    }
                    node.setType(SoyTypes.removeNull(type));
                    break;
                }
                case INDEX: {
                    this.requireLoopVariableInScope(node, arg1);
                    node.setType(IntType.getInstance());
                    break;
                }
                case QUOTE_KEYS_IF_JS: {
                    if (!(arg1 instanceof LegacyObjectMapLiteralNode)) {
                        ResolveExpressionTypesVisitor.this.errorReporter.report(arg1.getSourceLocation(), INCORRECT_ARG_TYPE, "quoteKeysIfJs", arg1.getType(), "map literal");
                    }
                    node.setType(UnknownType.getInstance());
                    break;
                }
                case IS_FIRST: 
                case IS_LAST: {
                    this.requireLoopVariableInScope(node, arg1);
                    node.setType(BoolType.getInstance());
                    break;
                }
                case CSS: {
                    this.checkArgIsStringLiteral(node.getChild(node.numChildren() - 1), "css");
                    node.setType(StringType.getInstance());
                    break;
                }
                case XID: {
                    this.checkArgIsStringLiteral(arg1, "xid");
                    node.setType(StringType.getInstance());
                    break;
                }
                case V1_EXPRESSION: {
                    this.checkArgIsStringLiteral(arg1, "v1Expression");
                    node.setType(UnknownType.getInstance());
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
        }

        private void checkArgIsStringLiteral(ExprNode arg, String funcName) {
            if (!(arg instanceof StringNode)) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(arg.getSourceLocation(), STRING_LITERAL_REQUIRED, funcName);
            }
        }

        private void visitSoyFunction(SoyFunction fn, FunctionNode node) {
            if (fn instanceof ParseIntFunction) {
                this.checkArgType(node.getChild(0), StringType.getInstance(), node);
                node.setType(SoyTypes.makeNullable(IntType.getInstance()));
            } else if (fn instanceof ParseFloatFunction) {
                this.checkArgType(node.getChild(0), StringType.getInstance(), node);
                node.setType(SoyTypes.makeNullable(FloatType.getInstance()));
            } else if (fn instanceof LegacyObjectMapToMapFunction) {
                if (this.checkArgType(node.getChild(0), LegacyObjectMapType.ANY_MAP, node)) {
                    this.visitLegacyObjectMapToMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof MapToLegacyObjectMapFunction) {
                if (this.checkArgType(node.getChild(0), MapType.ANY_MAP, node)) {
                    this.visitMapToLegacyObjectMapFunction(node);
                } else {
                    node.setType(UnknownType.getInstance());
                }
            } else if (fn instanceof LengthFunction) {
                this.checkArgType(node.getChild(0), ListType.of(AnyType.getInstance()), node);
                node.setType(IntType.getInstance());
            } else if (fn instanceof RangeFunction) {
                node.setType(ResolveExpressionTypesVisitor.this.typeRegistry.getOrCreateListType(IntType.getInstance()));
            } else {
                node.setType(UnknownType.getInstance());
            }
        }

        private void requireLoopVariableInScope(FunctionNode fn, ExprNode loopVariable) {
            if (!(loopVariable instanceof VarRefNode) || !(((VarRefNode)loopVariable).getDefnDecl() instanceof LoopVar)) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(fn.getSourceLocation(), LOOP_VARIABLE_NOT_IN_SCOPE, fn.getFunctionName());
            }
        }

        private boolean checkArgType(ExprNode arg, SoyType expectedType, FunctionNode node) {
            SoyType.Kind argTypeKind = arg.getType().getKind();
            if (argTypeKind == SoyType.Kind.UNKNOWN || argTypeKind == SoyType.Kind.ERROR) {
                return true;
            }
            if (!expectedType.isAssignableFrom(arg.getType())) {
                ResolveExpressionTypesVisitor.this.errorReporter.report(arg.getSourceLocation(), INCORRECT_ARG_TYPE, node.getSoyFunction().getName(), arg.getType(), expectedType);
                return false;
            }
            return true;
        }
    }
}

