/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.passes;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.base.internal.TriState;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.conformance.ValidatedConformanceConfig;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.logging.ValidatedLoggingConfig;
import com.google.template.soy.parsepasses.contextautoesc.ContextualAutoescaper;
import com.google.template.soy.parsepasses.contextautoesc.DerivedTemplateUtils;
import com.google.template.soy.passes.AddHtmlCommentsForDebugPass;
import com.google.template.soy.passes.AssertStrictAutoescapingVisitor;
import com.google.template.soy.passes.CheckDelegatesVisitor;
import com.google.template.soy.passes.CheckEscapingSanityFileSetPass;
import com.google.template.soy.passes.CheckGlobalsPass;
import com.google.template.soy.passes.CheckNonEmptyMsgNodesPass;
import com.google.template.soy.passes.CheckProtoInitCallsPass;
import com.google.template.soy.passes.CheckTemplateCallsPass;
import com.google.template.soy.passes.CheckTemplateParamsVisitor;
import com.google.template.soy.passes.CheckTemplateVisibility;
import com.google.template.soy.passes.CombineConsecutiveRawTextNodesPass;
import com.google.template.soy.passes.CompilerFilePass;
import com.google.template.soy.passes.CompilerFileSetPass;
import com.google.template.soy.passes.ContentSecurityPolicyNonceInjectionPass;
import com.google.template.soy.passes.DesugarHtmlNodesPass;
import com.google.template.soy.passes.HtmlRewritePass;
import com.google.template.soy.passes.InferRequiredSyntaxVersion;
import com.google.template.soy.passes.InsertMsgPlaceholderNodesPass;
import com.google.template.soy.passes.ReportSyntaxVersionErrors;
import com.google.template.soy.passes.ResolveExpressionTypesVisitor;
import com.google.template.soy.passes.ResolveNamesVisitor;
import com.google.template.soy.passes.ResolvePackageRelativeCssNamesVisitor;
import com.google.template.soy.passes.RewriteGenderMsgsVisitor;
import com.google.template.soy.passes.RewriteGlobalsPass;
import com.google.template.soy.passes.RewriteRemaindersPass;
import com.google.template.soy.passes.SoyConformancePass;
import com.google.template.soy.passes.StrictDepsVisitor;
import com.google.template.soy.passes.StrictHtmlValidationPass;
import com.google.template.soy.passes.VeLogValidationPass;
import com.google.template.soy.shared.SoyGeneralOptions;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.sharedpasses.opti.SimplifyVisitor;
import com.google.template.soy.soytree.AliasDeclaration;
import com.google.template.soy.soytree.SoyFileNode;
import com.google.template.soy.soytree.SoyFileSetNode;
import com.google.template.soy.soytree.TemplateDelegateNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.TemplateRegistry;
import com.google.template.soy.types.SoyTypeRegistry;
import java.util.HashMap;
import java.util.List;
import javax.annotation.CheckReturnValue;
import javax.annotation.Nullable;

public final class PassManager {
    private final ImmutableList<CompilerFilePass> singleFilePasses;
    private final ImmutableList<CompilerFileSetPass> crossTemplateCheckingPasses;
    private final ImmutableList<CompilerFileSetPass> simplificationPasses;
    private final SoyTypeRegistry registry;
    private final ErrorReporter errorReporter;
    private final SyntaxVersion declaredSyntaxVersion;
    private final SoyGeneralOptions options;
    private final boolean desugarHtmlNodes;
    @Nullable
    private final ContextualAutoescaper autoescaper;
    @Nullable
    private final SimplifyVisitor simplifyVisitor;
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL = SoyErrorKind.of("Alias ''{0}'' conflicts with a global of the same name.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX = SoyErrorKind.of("Alias ''{0}'' conflicts with namespace for global ''{1}''.", new SoyErrorKind.StyleAllowance[0]);

    private PassManager(Builder builder) {
        this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)builder.registry);
        this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)builder.errorReporter);
        this.declaredSyntaxVersion = (SyntaxVersion)((Object)Preconditions.checkNotNull((Object)((Object)builder.declaredSyntaxVersion)));
        this.options = (SoyGeneralOptions)Preconditions.checkNotNull((Object)builder.opts);
        boolean allowUnknownGlobals = builder.allowUnknownGlobals;
        boolean disableAllTypeChecking = builder.disableAllTypeChecking;
        this.desugarHtmlNodes = builder.desugarHtmlNodes;
        this.autoescaper = builder.autoescaperEnabled ? new ContextualAutoescaper((ImmutableMap<String, ? extends SoyPrintDirective>)builder.soyPrintDirectives) : null;
        this.simplifyVisitor = this.options.isOptimizerEnabled() ? SimplifyVisitor.create() : null;
        ImmutableList.Builder singleFilePassesBuilder = ImmutableList.builder().add((Object)new HtmlRewritePass(this.errorReporter)).add((Object)new SoyConformancePass(builder.conformanceConfig, this.errorReporter)).add((Object)new ContentSecurityPolicyNonceInjectionPass(this.errorReporter)).add((Object)new InsertMsgPlaceholderNodesPass(this.errorReporter)).add((Object)new RewriteGendersPass()).add((Object)new RewriteRemaindersPass(this.errorReporter)).add((Object)new StrictHtmlValidationPass(this.errorReporter)).add((Object)new RewriteGlobalsPass(this.registry, this.options.getCompileTimeGlobals(), this.errorReporter)).add((Object)new ResolveNamesPass());
        if (!disableAllTypeChecking) {
            singleFilePassesBuilder.add((Object)new ResolveExpressionTypesPass());
            singleFilePassesBuilder.add((Object)new VeLogValidationPass(this.errorReporter, builder.loggingConfig));
        }
        singleFilePassesBuilder.add((Object)new ResolvePackageRelativeCssNamesPass());
        if (!allowUnknownGlobals) {
            singleFilePassesBuilder.add((Object)new CheckGlobalsPass(this.errorReporter));
        }
        singleFilePassesBuilder.add((Object)new ValidateAliasesPass()).add((Object)new CheckNonEmptyMsgNodesPass(this.errorReporter)).add((Object)new CheckSyntaxVersionPass());
        if (!disableAllTypeChecking) {
            singleFilePassesBuilder.add((Object)new CheckProtoInitCallsPass(this.errorReporter));
        }
        if (this.options.isStrictAutoescapingRequired() == TriState.ENABLED) {
            singleFilePassesBuilder.add((Object)new EnforceStrictAutoescapingPass());
        }
        this.singleFilePasses = singleFilePassesBuilder.build();
        ImmutableList.Builder beforeAutoescaperFileSetPassBuilder = ImmutableList.builder().add((Object)new CheckTemplateParamsPass());
        if (!disableAllTypeChecking) {
            beforeAutoescaperFileSetPassBuilder.add((Object)new CheckTemplateCallsPass(this.errorReporter));
        }
        beforeAutoescaperFileSetPassBuilder.add((Object)new CheckVisibilityPass()).add((Object)new CheckDelegatesPass()).add((Object)new CheckEscapingSanityFileSetPass(this.errorReporter));
        if (this.options.allowExternalCalls() == TriState.DISABLED) {
            beforeAutoescaperFileSetPassBuilder.add((Object)new StrictDepsPass());
        }
        beforeAutoescaperFileSetPassBuilder.add((Object)new CombineConsecutiveRawTextNodesPass());
        if (builder.addHtmlCommentsForDebug) {
            beforeAutoescaperFileSetPassBuilder.add((Object)new AddHtmlCommentsForDebugPass());
        }
        this.crossTemplateCheckingPasses = beforeAutoescaperFileSetPassBuilder.build();
        ImmutableList.Builder simplificationPassesBuilder = ImmutableList.builder();
        if (this.desugarHtmlNodes) {
            simplificationPassesBuilder.add((Object)new DesugarHtmlNodesPass());
        }
        if (builder.optimize) {
            simplificationPassesBuilder.add((Object)new OptimizationPass());
        }
        simplificationPassesBuilder.add((Object)new CombineConsecutiveRawTextNodesPass());
        this.simplificationPasses = simplificationPassesBuilder.build();
    }

    public void runSingleFilePasses(SoyFileNode file, IdGenerator nodeIdGen) {
        for (CompilerFilePass pass : this.singleFilePasses) {
            pass.run(file, nodeIdGen);
        }
    }

    @CheckReturnValue
    public TemplateRegistry runWholeFilesetPasses(SoyFileSetNode soyTree) {
        TemplateRegistry templateRegistry = new TemplateRegistry(soyTree, this.errorReporter);
        for (CompilerFileSetPass pass : this.crossTemplateCheckingPasses) {
            pass.run(soyTree, templateRegistry);
        }
        if (this.errorReporter.hasErrors()) {
            return templateRegistry;
        }
        if (this.autoescaper != null) {
            this.doContextualEscaping(soyTree, templateRegistry);
            if (this.errorReporter.hasErrors()) {
                return templateRegistry;
            }
            templateRegistry = new TemplateRegistry(soyTree, this.errorReporter);
        }
        for (CompilerFileSetPass pass : this.simplificationPasses) {
            pass.run(soyTree, templateRegistry);
        }
        return templateRegistry;
    }

    private void doContextualEscaping(SoyFileSetNode soyTree, TemplateRegistry registry) {
        List<TemplateNode> extraTemplates = this.autoescaper.rewrite(soyTree, registry, this.errorReporter);
        if (!extraTemplates.isEmpty()) {
            HashMap<String, SoyFileNode> containingFile = new HashMap<String, SoyFileNode>();
            for (SoyFileNode fileNode : soyTree.getChildren()) {
                for (TemplateNode templateNode : fileNode.getChildren()) {
                    String name = templateNode instanceof TemplateDelegateNode ? ((TemplateDelegateNode)templateNode).getDelTemplateName() : templateNode.getTemplateName();
                    containingFile.put(DerivedTemplateUtils.getBaseName(name), fileNode);
                }
            }
            for (TemplateNode extraTemplate : extraTemplates) {
                String name = extraTemplate instanceof TemplateDelegateNode ? ((TemplateDelegateNode)extraTemplate).getDelTemplateName() : extraTemplate.getTemplateName();
                ((SoyFileNode)containingFile.get(DerivedTemplateUtils.getBaseName(name))).addChild(extraTemplate);
            }
        }
    }

    private final class ValidateAliasesPass
    extends CompilerFilePass {
        private ValidateAliasesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            for (AliasDeclaration alias : file.getAliasDeclarations()) {
                if (PassManager.this.options.getCompileTimeGlobals().containsKey((Object)alias.getAlias())) {
                    PassManager.this.errorReporter.report(alias.getLocation(), ALIAS_CONFLICTS_WITH_GLOBAL, alias.getAlias());
                }
                for (String global : PassManager.this.options.getCompileTimeGlobals().keySet()) {
                    if (!global.startsWith(alias.getAlias() + ".")) continue;
                    PassManager.this.errorReporter.report(alias.getLocation(), ALIAS_CONFLICTS_WITH_GLOBAL_PREFIX, alias.getAlias(), global);
                }
            }
        }
    }

    private final class OptimizationPass
    extends CompilerFileSetPass {
        private OptimizationPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            if (PassManager.this.simplifyVisitor != null) {
                PassManager.this.simplifyVisitor.simplify(fileSet, registry);
            }
        }
    }

    private final class StrictDepsPass
    extends CompilerFileSetPass {
        private StrictDepsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new StrictDepsVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckVisibilityPass
    extends CompilerFileSetPass {
        private CheckVisibilityPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateVisibility(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckDelegatesPass
    extends CompilerFileSetPass {
        private CheckDelegatesPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckDelegatesVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class CheckTemplateParamsPass
    extends CompilerFileSetPass {
        private CheckTemplateParamsPass() {
        }

        @Override
        public void run(SoyFileSetNode fileSet, TemplateRegistry registry) {
            new CheckTemplateParamsVisitor(registry, PassManager.this.errorReporter).exec(fileSet);
        }
    }

    private final class EnforceStrictAutoescapingPass
    extends CompilerFilePass {
        final AssertStrictAutoescapingVisitor visitor;

        private EnforceStrictAutoescapingPass() {
            this.visitor = new AssertStrictAutoescapingVisitor(PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            this.visitor.exec(file);
        }
    }

    private final class ResolvePackageRelativeCssNamesPass
    extends CompilerFilePass {
        private ResolvePackageRelativeCssNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolvePackageRelativeCssNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveExpressionTypesPass
    extends CompilerFilePass {
        private ResolveExpressionTypesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveExpressionTypesVisitor(PassManager.this.registry, PassManager.this.declaredSyntaxVersion, PassManager.this.options, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class ResolveNamesPass
    extends CompilerFilePass {
        private ResolveNamesPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new ResolveNamesVisitor(PassManager.this.errorReporter).exec(file);
        }
    }

    private final class RewriteGendersPass
    extends CompilerFilePass {
        private RewriteGendersPass() {
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            new RewriteGenderMsgsVisitor(nodeIdGen, PassManager.this.errorReporter).exec(file);
        }
    }

    private final class CheckSyntaxVersionPass
    extends CompilerFilePass {
        final ReportSyntaxVersionErrors reportDeclaredVersionErrors;

        private CheckSyntaxVersionPass() {
            this.reportDeclaredVersionErrors = new ReportSyntaxVersionErrors(PassManager.this.declaredSyntaxVersion, true, PassManager.this.errorReporter);
        }

        @Override
        public void run(SoyFileNode file, IdGenerator nodeIdGen) {
            ErrorReporter.Checkpoint checkpoint = PassManager.this.errorReporter.checkpoint();
            this.reportDeclaredVersionErrors.report(file);
            if (!PassManager.this.errorReporter.errorsSince(checkpoint)) {
                SyntaxVersion inferredSyntaxVersion = InferRequiredSyntaxVersion.infer(file);
                if (inferredSyntaxVersion.num > ((PassManager)PassManager.this).declaredSyntaxVersion.num) {
                    new ReportSyntaxVersionErrors(inferredSyntaxVersion, false, PassManager.this.errorReporter).report(file);
                }
            }
        }
    }

    public static final class Builder {
        private SoyTypeRegistry registry;
        private ImmutableMap<String, ? extends SoyPrintDirective> soyPrintDirectives;
        private ErrorReporter errorReporter;
        private SyntaxVersion declaredSyntaxVersion;
        private SoyGeneralOptions opts;
        private boolean allowUnknownGlobals;
        private boolean disableAllTypeChecking;
        private boolean desugarHtmlNodes = true;
        private boolean optimize = true;
        private ValidatedConformanceConfig conformanceConfig = ValidatedConformanceConfig.EMPTY;
        private ValidatedLoggingConfig loggingConfig = ValidatedLoggingConfig.EMPTY;
        private boolean autoescaperEnabled = true;
        private boolean addHtmlCommentsForDebug = true;

        public Builder setErrorReporter(ErrorReporter errorReporter) {
            this.errorReporter = (ErrorReporter)Preconditions.checkNotNull((Object)errorReporter);
            return this;
        }

        public Builder setSoyPrintDirectiveMap(ImmutableMap<String, ? extends SoyPrintDirective> printDirectives) {
            this.soyPrintDirectives = (ImmutableMap)Preconditions.checkNotNull(printDirectives);
            return this;
        }

        public Builder setTypeRegistry(SoyTypeRegistry registry) {
            this.registry = (SoyTypeRegistry)Preconditions.checkNotNull((Object)registry);
            return this;
        }

        public Builder setDeclaredSyntaxVersion(SyntaxVersion declaredSyntaxVersion) {
            this.declaredSyntaxVersion = (SyntaxVersion)((Object)Preconditions.checkNotNull((Object)((Object)declaredSyntaxVersion)));
            return this;
        }

        public Builder setGeneralOptions(SoyGeneralOptions opts) {
            this.opts = opts;
            return this;
        }

        public Builder disableAllTypeChecking() {
            this.disableAllTypeChecking = true;
            return this;
        }

        public Builder allowUnknownGlobals() {
            this.allowUnknownGlobals = true;
            return this;
        }

        public Builder desugarHtmlNodes(boolean desugarHtmlNodes) {
            this.desugarHtmlNodes = desugarHtmlNodes;
            return this;
        }

        public Builder optimize(boolean optimize) {
            this.optimize = optimize;
            return this;
        }

        public Builder addHtmlCommentsForDebug(boolean addHtmlCommentsForDebug) {
            this.addHtmlCommentsForDebug = addHtmlCommentsForDebug;
            return this;
        }

        public Builder setConformanceConfig(ValidatedConformanceConfig conformanceConfig) {
            this.conformanceConfig = (ValidatedConformanceConfig)Preconditions.checkNotNull((Object)conformanceConfig);
            return this;
        }

        public Builder setLoggingConfig(ValidatedLoggingConfig loggingConfig) {
            this.loggingConfig = (ValidatedLoggingConfig)Preconditions.checkNotNull((Object)loggingConfig);
            return this;
        }

        public Builder setAutoescaperEnabled(boolean autoescaperEnabled) {
            this.autoescaperEnabled = autoescaperEnabled;
            return this;
        }

        public PassManager build() {
            return new PassManager(this);
        }
    }
}

