/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.parsepasses.contextautoesc;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.internal.IdGenerator;
import com.google.template.soy.coredirectives.EscapeHtmlDirective;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.shared.restricted.SoyPrintDirective;
import com.google.template.soy.soytree.AbstractSoyNodeVisitor;
import com.google.template.soy.soytree.AutoescapeMode;
import com.google.template.soy.soytree.PrintDirectiveNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import java.util.Collection;

final class PerformDeprecatedNonContextualAutoescapeVisitor
extends AbstractSoyNodeVisitor<Void> {
    private final IdGenerator nodeIdGen;
    private AutoescapeMode autoescapeMode;

    public PerformDeprecatedNonContextualAutoescapeVisitor(IdGenerator nodeIdGen) {
        this.nodeIdGen = nodeIdGen;
    }

    @Override
    protected void visitTemplateNode(TemplateNode node) {
        this.autoescapeMode = node.getAutoescapeMode();
        this.visitChildren(node);
        this.autoescapeMode = null;
    }

    @Override
    protected void visitPrintNode(PrintNode node) {
        if (this.autoescapeMode != AutoescapeMode.NONCONTEXTUAL) {
            if (node.getChildren().isEmpty()) {
                throw new IllegalStateException(String.format("Internal error: A contextual or strict template has a print node that was never assigned any escape directives: %s at %s", node.toSourceString(), node.getSourceLocation()));
            }
            return;
        }
        boolean shouldCancelAutoescape = false;
        for (PrintDirectiveNode directiveNode : ImmutableList.copyOf((Collection)node.getChildren())) {
            SoyPrintDirective directive = directiveNode.getPrintDirective();
            if (directive == null || !directive.shouldCancelAutoescape()) continue;
            shouldCancelAutoescape = true;
            break;
        }
        if (this.autoescapeMode == AutoescapeMode.NONCONTEXTUAL && !shouldCancelAutoescape) {
            PrintDirectiveNode newEscapeHtmlDirectiveNode = new PrintDirectiveNode(this.nodeIdGen.genId(), node.getSourceLocation(), (ImmutableList<ExprNode>)ImmutableList.of(), new EscapeHtmlDirective());
            node.addChild(0, newEscapeHtmlDirectiveNode);
        }
    }

    @Override
    protected void visitSoyNode(SoyNode node) {
        if (node instanceof SoyNode.ParentSoyNode) {
            this.visitChildren((SoyNode.ParentSoyNode)node);
        }
    }
}

