/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.internal;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.internal.JsSrcUtils;
import com.google.template.soy.jssrc.internal.SoyToJsVariableMappings;
import com.google.template.soy.jssrc.restricted.JsExpr;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;

final class V1JsExprTranslator {
    private static final SoyErrorKind UNSUPPORTED_FUNCTION = SoyErrorKind.of("''v1Expression'' no longer supports the ''index'', ''isFirst'' or ''isLast'' functions. Migrate to a v2 expression to access this functionality.", new SoyErrorKind.StyleAllowance[0]);
    private static final SoyErrorKind UNSUPPORTED_OPERATOR = SoyErrorKind.of("''v1Expression'' no longer supports the ''and'', ''or'' or ''and'' operators. Move the operator outside of the ''v1Expression'' or migrate to a v2 expression to access this functionality.", new SoyErrorKind.StyleAllowance[0]);
    private static final String VAR_RE = "\\$([a-zA-Z_][a-zA-Z0-9_]*)";
    private static final Pattern VAR = Pattern.compile("\\$([a-zA-Z_][a-zA-Z0-9_]*)");
    private static final String SOY_FUNCTION_RE = "(isFirst|isLast|index)\\(\\s*\\$([a-zA-Z0-9_]+)\\s*\\)";
    private static final Pattern BOOL_OP_RE = Pattern.compile("\\b(not|and|or)\\b");
    private static final Pattern VAR_OR_BOOL_OP_OR_SOY_FUNCTION = Pattern.compile("\\$([a-zA-Z_][a-zA-Z0-9_]*)|" + BOOL_OP_RE + "|" + "(isFirst|isLast|index)\\(\\s*\\$([a-zA-Z0-9_]+)\\s*\\)");

    V1JsExprTranslator() {
    }

    @VisibleForTesting
    static JsExpr translateToJsExpr(String soyExpr, SourceLocation sourceLocation, SoyToJsVariableMappings variableMappings, ErrorReporter errorReporter) {
        StringBuffer jsExprTextSb = new StringBuffer();
        Matcher matcher = VAR_OR_BOOL_OP_OR_SOY_FUNCTION.matcher(soyExpr);
        while (matcher.find()) {
            String group = matcher.group();
            Matcher var = VAR.matcher(group);
            if (var.matches()) {
                matcher.appendReplacement(jsExprTextSb, Matcher.quoteReplacement(V1JsExprTranslator.translateVar(variableMappings, var)));
                continue;
            }
            if (BOOL_OP_RE.matcher(group).matches()) {
                errorReporter.report(V1JsExprTranslator.matcherLocation(matcher, sourceLocation), UNSUPPORTED_OPERATOR, new Object[0]);
                continue;
            }
            errorReporter.report(V1JsExprTranslator.matcherLocation(matcher, sourceLocation), UNSUPPORTED_FUNCTION, new Object[0]);
        }
        matcher.appendTail(jsExprTextSb);
        String jsExprText = jsExprTextSb.toString();
        jsExprText = JsSrcUtils.escapeUnicodeFormatChars(jsExprText);
        return new JsExpr('(' + jsExprText + ')', Integer.MAX_VALUE);
    }

    private static SourceLocation matcherLocation(Matcher matcher, SourceLocation textLocation) {
        return textLocation.getBeginLocation().offsetEndCol(matcher.end() + 1).offsetStartCol(matcher.start() + 1);
    }

    private static String translateVar(SoyToJsVariableMappings variableMappings, Matcher matcher) {
        Preconditions.checkArgument((boolean)matcher.matches());
        String firstPart = matcher.group(1);
        StringBuilder exprTextSb = new StringBuilder();
        String translation = V1JsExprTranslator.getLocalVarTranslation(firstPart, variableMappings);
        if (translation != null) {
            exprTextSb.append(translation);
        } else {
            exprTextSb.append("opt_data.").append(firstPart);
        }
        return exprTextSb.toString();
    }

    @Nullable
    private static String getLocalVarTranslation(String ident, SoyToJsVariableMappings mappings) {
        CodeChunk.WithValue translation = mappings.maybeGet(ident);
        if (translation == null) {
            return null;
        }
        JsExpr asExpr = translation.assertExpr();
        return asExpr.getPrecedence() != Integer.MAX_VALUE ? "(" + asExpr.getText() + ")" : asExpr.getText();
    }
}

