/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jssrc.dsl;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.jssrc.dsl.AutoValue_FunctionDeclaration;
import com.google.template.soy.jssrc.dsl.CodeChunk;
import com.google.template.soy.jssrc.dsl.FormattingContext;
import com.google.template.soy.jssrc.restricted.JsExpr;

abstract class FunctionDeclaration
extends CodeChunk.WithValue {
    FunctionDeclaration() {
    }

    abstract ImmutableList<String> params();

    abstract CodeChunk body();

    static FunctionDeclaration create(Iterable<String> parameters, CodeChunk body) {
        return new AutoValue_FunctionDeclaration((ImmutableList<String>)ImmutableList.copyOf(parameters), body);
    }

    @Override
    public JsExpr singleExprOrName() {
        FormattingContext ctx = new FormattingContext();
        ctx.appendOutputExpression(this);
        return new JsExpr(ctx.toString(), Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<CodeChunk> initialStatements() {
        return ImmutableSet.of();
    }

    @Override
    void doFormatInitialStatements(FormattingContext ctx) {
    }

    @Override
    public void collectRequires(CodeChunk.RequiresCollector collector) {
        this.body().collectRequires(collector);
    }

    @Override
    void doFormatOutputExpr(FormattingContext ctx) {
        ctx.append("function(");
        ImmutableList<String> params = this.params();
        for (int i = 0; i < params.size(); ++i) {
            ctx.append((String)params.get(i));
            if (i + 1 >= params.size()) continue;
            ctx.append(", ");
        }
        ctx.append(") ");
        try (FormattingContext ignored = ctx.enterBlock();){
            ctx.appendAll(this.body());
        }
    }
}

