/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.jbcsrc.restricted;

import javax.annotation.Nullable;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.commons.Method;
import org.objectweb.asm.commons.TableSwitchGenerator;

public final class CodeBuilder
extends MethodVisitor {
    private final GeneratorAdapter adapter;

    public CodeBuilder(int access, Method method, MethodVisitor mv) {
        this(mv, access, method.getName(), method.getDescriptor());
    }

    public CodeBuilder(int access, Method method, @Nullable Type[] exceptions, ClassVisitor cv) {
        this(access, method, cv.visitMethod(access, method.getName(), method.getDescriptor(), null, CodeBuilder.getInternalNames(exceptions)));
    }

    public CodeBuilder(MethodVisitor mv, int access, String name, String desc) {
        super(393216, mv);
        this.adapter = new GeneratorAdapter(mv, access, name, desc);
    }

    private static String[] getInternalNames(@Nullable Type[] types) {
        if (types == null) {
            return null;
        }
        String[] names = new String[types.length];
        for (int i = 0; i < names.length; ++i) {
            names[i] = types[i].getInternalName();
        }
        return names;
    }

    public void pushBoolean(boolean value) {
        this.adapter.push(value);
    }

    public void pushInt(int value) {
        this.adapter.push(value);
    }

    public void pushLong(long value) {
        this.adapter.push(value);
    }

    public void pushFloat(float value) {
        this.adapter.push(value);
    }

    public void pushDouble(double value) {
        this.adapter.push(value);
    }

    public void pushString(String value) {
        this.adapter.push(value);
    }

    public void pushType(Type value) {
        this.adapter.push(value);
    }

    public void pushNull() {
        this.adapter.visitInsn(1);
    }

    public void loadThis() {
        this.adapter.loadThis();
    }

    public void loadArgs() {
        this.adapter.loadArgs();
    }

    public void pop() {
        this.adapter.pop();
    }

    public void pop2() {
        this.adapter.pop2();
    }

    public void dup() {
        this.adapter.dup();
    }

    public void dupX1() {
        this.adapter.dupX1();
    }

    public void dupX2() {
        this.adapter.dupX2();
    }

    public void dup2() {
        this.adapter.dup2();
    }

    public void dup2X1() {
        this.adapter.dup2X1();
    }

    public void dup2X2() {
        this.adapter.dup2X2();
    }

    public void iinc(int local, int amount) {
        this.adapter.iinc(local, amount);
    }

    public void cast(Type from, Type to) {
        this.adapter.cast(from, to);
    }

    public void box(Type type) {
        this.adapter.box(type);
    }

    public void valueOf(Type type) {
        this.adapter.valueOf(type);
    }

    public void unbox(Type type) {
        this.adapter.unbox(type);
    }

    public Label newLabel() {
        return this.adapter.newLabel();
    }

    public void mark(Label label) {
        this.adapter.mark(label);
    }

    public Label mark() {
        return this.adapter.mark();
    }

    public void ifCmp(Type type, int mode, Label label) {
        this.adapter.ifCmp(type, mode, label);
    }

    public void ifICmp(int mode, Label label) {
        this.adapter.ifICmp(mode, label);
    }

    public void ifZCmp(int mode, Label label) {
        this.adapter.ifZCmp(mode, label);
    }

    public void ifNull(Label label) {
        this.adapter.ifNull(label);
    }

    public void ifNonNull(Label label) {
        this.adapter.ifNonNull(label);
    }

    public void goTo(Label label) {
        this.adapter.goTo(label);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator) {
        this.adapter.tableSwitch(keys, generator);
    }

    public void tableSwitch(int[] keys, TableSwitchGenerator generator, boolean useTable) {
        this.adapter.tableSwitch(keys, generator, useTable);
    }

    public void returnValue() {
        this.adapter.returnValue();
    }

    public void getStatic(Type owner, String name, Type type) {
        this.adapter.getStatic(owner, name, type);
    }

    public void getField(Type owner, String name, Type type) {
        this.adapter.getField(owner, name, type);
    }

    public void putField(Type owner, String name, Type type) {
        this.adapter.putField(owner, name, type);
    }

    public void putStatic(Type owner, String name, Type type) {
        this.adapter.putStatic(owner, name, type);
    }

    public void invokeVirtual(Type owner, Method method) {
        this.adapter.invokeVirtual(owner, method);
    }

    public void invokeConstructor(Type type, Method method) {
        this.adapter.invokeConstructor(type, method);
    }

    public void newInstance(Type type) {
        this.adapter.newInstance(type);
    }

    public void newArray(Type type) {
        this.adapter.newArray(type);
    }

    public void arrayLength() {
        this.adapter.arrayLength();
    }

    public void throwException() {
        this.adapter.throwException();
    }

    public void throwException(Type type, String msg) {
        this.adapter.throwException(type, msg);
    }

    public void checkCast(Type type) {
        this.adapter.checkCast(type);
    }

    public void endMethod() {
        this.adapter.endMethod();
    }

    public void swap() {
        this.adapter.swap();
    }

    public void arrayStore(Type type) {
        this.adapter.arrayStore(type);
    }
}

