/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.internal.i18n;

import com.google.common.base.Preconditions;
import com.google.template.soy.base.SoyBackendKind;
import com.google.template.soy.internal.i18n.BidiGlobalDir;
import com.google.template.soy.internal.i18n.BidiUtils;
import java.util.regex.Pattern;

public class SoyBidiUtils {
    public static final String IS_RTL_MODULE_ALIAS = "external_bidi";
    private static final String GOOG_IS_RTL_CODE_SNIPPET = "soy.$$IS_LOCALE_RTL";
    private static final String GOOG_IS_RTL_CODE_SNIPPET_NAMESPACE = "soy";
    private static final Pattern FAKE_RTL_LOCALES_PATTERN = Pattern.compile("qbi|.*[-_]psrtl", 2);

    private SoyBidiUtils() {
    }

    static BidiGlobalDir getBidiGlobalDir(String localeString) {
        boolean isRtl;
        try {
            isRtl = localeString != null && (BidiUtils.isRtlLanguage(localeString) || FAKE_RTL_LOCALES_PATTERN.matcher(localeString).matches());
        }
        catch (IllegalArgumentException localeException) {
            isRtl = false;
        }
        return BidiGlobalDir.forStaticIsRtl(isRtl);
    }

    public static BidiGlobalDir decodeBidiGlobalDirFromJsOptions(int bidiGlobalDir, boolean useGoogIsRtlForBidiGlobalDir) {
        if (bidiGlobalDir == 0) {
            if (!useGoogIsRtlForBidiGlobalDir) {
                return null;
            }
            return BidiGlobalDir.forIsRtlCodeSnippet(GOOG_IS_RTL_CODE_SNIPPET, GOOG_IS_RTL_CODE_SNIPPET_NAMESPACE, SoyBackendKind.JS_SRC);
        }
        Preconditions.checkState((!useGoogIsRtlForBidiGlobalDir ? 1 : 0) != 0, (Object)"Must not specify both bidiGlobalDir and bidiGlobalDirIsRtlCodeSnippet.");
        Preconditions.checkArgument((bidiGlobalDir == 1 || bidiGlobalDir == -1 ? 1 : 0) != 0, (Object)"If specified, bidiGlobalDir must be 1 for LTR or -1 for RTL.");
        return BidiGlobalDir.forStaticIsRtl(bidiGlobalDir < 0);
    }

    public static BidiGlobalDir decodeBidiGlobalDirFromPyOptions(String bidiIsRtlFn) {
        if (bidiIsRtlFn == null || bidiIsRtlFn.isEmpty()) {
            return null;
        }
        int dotIndex = bidiIsRtlFn.lastIndexOf(46);
        Preconditions.checkArgument((dotIndex > 0 && dotIndex < bidiIsRtlFn.length() - 1 ? 1 : 0) != 0, (Object)"If specified a bidiIsRtlFn must include the module path to allow for proper importing.");
        String fnName = bidiIsRtlFn.substring(dotIndex + 1) + "()";
        return BidiGlobalDir.forIsRtlCodeSnippet("external_bidi." + fnName, null, SoyBackendKind.PYTHON_SRC);
    }
}

