/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.coredirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyJsSrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPurePrintDirective
public class IdDirective
implements SoyJavaPrintDirective,
SoyJsSrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    public static final String NAME = "|id";

    @Inject
    public IdDirective() {
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)0);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return true;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        return value instanceof StringData ? value : StringData.forValue(value.coerceToString());
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return value.coerceToString();
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(JbcSrcMethods.stringCoercing.invoke(delegateAppendable));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return value;
    }

    private static final class JbcSrcMethods {
        static final MethodRef stringCoercing = MethodRef.create(LoggingAdvisingAppendable.class, "stringCoercing", LoggingAdvisingAppendable.class).asNonNullable();

        private JbcSrcMethods() {
        }
    }
}

