/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.RawTextNode;

final class BannedRawText
extends Rule<RawTextNode> {
    private final ImmutableSet<String> bannedTexts;

    BannedRawText(ImmutableSet<String> bannedRawText, SoyErrorKind error) {
        super(error);
        this.bannedTexts = bannedRawText;
    }

    @Override
    protected void doCheckConformance(RawTextNode node, ErrorReporter errorReporter) {
        String rawText = node.getRawText();
        for (String bannedText : this.bannedTexts) {
            int indexOf = rawText.indexOf(bannedText);
            if (indexOf <= -1) continue;
            errorReporter.report(node.substringLocation(indexOf, indexOf + bannedText.length()), this.error, new Object[0]);
        }
    }
}

