/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.base.Ascii;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.soytree.HtmlOpenTagNode;
import java.util.Collection;

final class BannedHtmlTag
extends Rule<HtmlOpenTagNode> {
    private final ImmutableSet<String> bannedTagNames;

    BannedHtmlTag(Collection<String> bannedTagNames, SoyErrorKind error) {
        super(error);
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String tagName : bannedTagNames) {
            builder.add((Object)Ascii.toLowerCase((String)tagName));
        }
        this.bannedTagNames = builder.build();
    }

    @Override
    protected void doCheckConformance(HtmlOpenTagNode node, ErrorReporter errorReporter) {
        if (node.getTagName().isStatic() && this.bannedTagNames.contains((Object)node.getTagName().getStaticTagNameAsLowerCase())) {
            errorReporter.report(node.getSourceLocation(), this.error, new Object[0]);
        }
    }
}

