/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.conformance;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.conformance.Rule;
import com.google.template.soy.error.ErrorReporter;
import com.google.template.soy.error.SoyErrorKind;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.FunctionNode;
import com.google.template.soy.exprtree.StringNode;

final class BannedCssSelector
extends Rule<FunctionNode> {
    private final ImmutableSet<String> bannedSelectors;

    BannedCssSelector(ImmutableSet<String> bannedSelectors, SoyErrorKind error) {
        super(error);
        this.bannedSelectors = bannedSelectors;
    }

    @Override
    protected void doCheckConformance(FunctionNode node, ErrorReporter errorReporter) {
        if (node.getFunctionName().equals("css")) {
            ExprNode selectorTextNode;
            ExprNode exprNode = selectorTextNode = node.numChildren() == 2 ? node.getChild(1) : node.getChild(0);
            if (selectorTextNode instanceof StringNode && this.bannedSelectors.contains((Object)((StringNode)selectorTextNode).getValue())) {
                errorReporter.report(selectorTextNode.getSourceLocation(), this.error, new Object[0]);
            }
        }
    }
}

