/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.bidifunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.bidifunctions.BidiFunctionsRuntime;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
final class BidiTextDirFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    BidiTextDirFunction() {
    }

    @Override
    public String getName() {
        return "bidiTextDir";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1, (Object)2);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue value = args.get(0);
        return IntegerData.forValue(BidiFunctionsRuntime.bidiTextDir(value, args.size() == 2 && args.get(1).booleanValue()));
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        return SoyExpression.forInt(BytecodeUtils.numericConversion(JbcSrcMethods.BIDI_TEXT_DIR.invoke(args.get(0).box(), args.size() > 1 ? args.get(1).unboxAs(Boolean.TYPE) : BytecodeUtils.constant(false)), Type.LONG_TYPE));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr value = args.get(0);
        JsExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = isHtml != null ? "soy.$$bidiTextDir(" + value.getText() + ", " + isHtml.getText() + ")" : "soy.$$bidiTextDir(" + value.getText() + ")";
        return new JsExpr(callText, Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr value = args.get(0);
        PyExpr isHtml = args.size() == 2 ? args.get(1) : null;
        String callText = isHtml != null ? "bidi.text_dir(" + value.getText() + ", " + isHtml.getText() + ")" : "bidi.text_dir(" + value.getText() + ")";
        return new PyExpr(callText, Integer.MAX_VALUE);
    }

    private static final class JbcSrcMethods {
        static final MethodRef BIDI_TEXT_DIR = MethodRef.create(BidiFunctionsRuntime.class, "bidiTextDir", SoyValue.class, Boolean.TYPE);

        private JbcSrcMethods() {
        }
    }
}

