/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.StringData;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.JsExprUtils;
import com.google.template.soy.jssrc.restricted.SoyJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyPureFunction
final class StrIndexOfFunction
implements SoyJavaFunction,
SoyJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    StrIndexOfFunction() {
    }

    @Override
    public String getName() {
        return "strIndexOf";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)2);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg0 = args.get(0);
        SoyValue arg1 = args.get(1);
        Preconditions.checkArgument((arg0 instanceof StringData || arg0 instanceof SanitizedContent ? 1 : 0) != 0, (String)"First argument to strIndexOf() function is not StringData or SanitizedContent: %s", (Object)arg0);
        Preconditions.checkArgument((arg1 instanceof StringData || arg1 instanceof SanitizedContent ? 1 : 0) != 0, (String)"Second argument to strIndexOf() function is not StringData or SanitizedContent: %s", (Object)arg1);
        String strArg0 = arg0.coerceToString();
        String strArg1 = arg1.coerceToString();
        return IntegerData.forValue(strArg0.indexOf(strArg1));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        String arg0 = JsExprUtils.toString(args.get(0)).getText();
        String arg1 = JsExprUtils.toString(args.get(1)).getText();
        return new JsExpr("(" + arg0 + ").indexOf(" + arg1 + ")", Integer.MAX_VALUE);
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        String arg0 = args.get(0).toPyString().getText();
        String arg1 = args.get(1).toPyString().getText();
        return new PyExpr("(" + arg0 + ").find(" + arg1 + ")", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression left = args.get(0);
        SoyExpression right = args.get(1);
        return SoyExpression.forInt(BytecodeUtils.numericConversion(left.unboxAs(String.class).invoke(JbcSrcMethods.STRING_INDEX_OF, right.unboxAs(String.class)), Type.LONG_TYPE));
    }

    private static final class JbcSrcMethods {
        static final MethodRef STRING_INDEX_OF = MethodRef.create(String.class, "indexOf", String.class);

        private JbcSrcMethods() {
        }
    }
}

