/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicfunctions;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicfunctions.BasicFunctionsRuntime;
import com.google.template.soy.data.SoyMap;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.internal.ListImpl;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcFunction;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcFunction;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyListExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcFunction;
import com.google.template.soy.shared.restricted.SoyJavaFunction;
import com.google.template.soy.shared.restricted.SoyPureFunction;
import com.google.template.soy.types.SoyType;
import com.google.template.soy.types.aggregate.LegacyObjectMapType;
import com.google.template.soy.types.aggregate.ListType;
import com.google.template.soy.types.primitive.IntType;
import com.google.template.soy.types.primitive.UnknownType;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Singleton
@SoyPureFunction
public final class KeysFunction
implements SoyJavaFunction,
SoyLibraryAssistedJsSrcFunction,
SoyPySrcFunction,
SoyJbcSrcFunction {
    @Inject
    KeysFunction() {
    }

    @Override
    public String getName() {
        return "keys";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public SoyValue computeForJava(List<SoyValue> args) {
        SoyValue arg = args.get(0);
        if (!(arg instanceof SoyMap)) {
            throw new IllegalArgumentException("Argument to keys() function is not SoyMap.");
        }
        return ListImpl.forProviderList(BasicFunctionsRuntime.keys((SoyMap)arg));
    }

    @Override
    public JsExpr computeForJsSrc(List<JsExpr> args) {
        JsExpr arg = args.get(0);
        return new JsExpr("soy.$$getMapKeys(" + arg.getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr computeForPySrc(List<PyExpr> args) {
        PyExpr arg = args.get(0);
        return new PyListExpr("(" + arg.getText() + ").keys()", Integer.MAX_VALUE);
    }

    @Override
    public SoyExpression computeForJbcSrc(JbcSrcPluginContext context, List<SoyExpression> args) {
        SoyExpression soyExpression = args.get(0);
        SoyType argType = soyExpression.soyType();
        SoyType listElementType = argType.getKind() == SoyType.Kind.LEGACY_OBJECT_MAP ? ((LegacyObjectMapType)argType).getKeyType() : (argType.getKind() == SoyType.Kind.LIST ? IntType.getInstance() : UnknownType.getInstance());
        return SoyExpression.forList(ListType.of(listElementType), JbcSrcMethods.KEYS_FN.invoke(soyExpression.box().checkedCast(SoyMap.class)));
    }

    private static final class JbcSrcMethods {
        static final MethodRef KEYS_FN = MethodRef.create(BasicFunctionsRuntime.class, "keys", SoyMap.class);

        private JbcSrcMethods() {
        }
    }
}

