/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.basicdirectives;

import com.google.common.collect.ImmutableSet;
import com.google.template.soy.basicdirectives.BasicDirectivesRuntime;
import com.google.template.soy.data.LoggingAdvisingAppendable;
import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SanitizedContentOperator;
import com.google.template.soy.data.SoyDataException;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.jbcsrc.restricted.BytecodeUtils;
import com.google.template.soy.jbcsrc.restricted.Expression;
import com.google.template.soy.jbcsrc.restricted.JbcSrcPluginContext;
import com.google.template.soy.jbcsrc.restricted.MethodRef;
import com.google.template.soy.jbcsrc.restricted.SoyExpression;
import com.google.template.soy.jbcsrc.restricted.SoyJbcSrcPrintDirective;
import com.google.template.soy.jssrc.restricted.JsExpr;
import com.google.template.soy.jssrc.restricted.SoyLibraryAssistedJsSrcPrintDirective;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.SoyPySrcPrintDirective;
import com.google.template.soy.shared.restricted.SoyJavaPrintDirective;
import com.google.template.soy.shared.restricted.SoyPurePrintDirective;
import com.google.template.soy.types.primitive.StringType;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.objectweb.asm.Type;

@Singleton
@SoyPurePrintDirective
final class InsertWordBreaksDirective
implements SanitizedContentOperator,
SoyJavaPrintDirective,
SoyLibraryAssistedJsSrcPrintDirective,
SoyPySrcPrintDirective,
SoyJbcSrcPrintDirective.Streamable {
    @Inject
    InsertWordBreaksDirective() {
    }

    @Override
    public String getName() {
        return "|insertWordBreaks";
    }

    @Override
    public Set<Integer> getValidArgsSizes() {
        return ImmutableSet.of((Object)1);
    }

    @Override
    public boolean shouldCancelAutoescape() {
        return false;
    }

    @Override
    @Nonnull
    public SanitizedContent.ContentKind getContentKind() {
        return SanitizedContent.ContentKind.HTML;
    }

    @Override
    public SoyValue applyForJava(SoyValue value, List<SoyValue> args) {
        int maxCharsBetweenWordBreaks;
        try {
            maxCharsBetweenWordBreaks = args.get(0).integerValue();
        }
        catch (SoyDataException sde) {
            throw new IllegalArgumentException("Could not parse 'insertWordBreaks' parameter as integer.");
        }
        return BasicDirectivesRuntime.insertWordBreaks(value, maxCharsBetweenWordBreaks);
    }

    @Override
    public SoyExpression applyForJbcSrc(JbcSrcPluginContext context, SoyExpression value, List<SoyExpression> args) {
        return SoyExpression.forSoyValue(StringType.getInstance(), JbcSrcMethods.INSERT_WORD_BREAKS.invoke(value.box(), BytecodeUtils.numericConversion(args.get(0).unboxAs(Long.TYPE), Type.INT_TYPE)));
    }

    @Override
    public SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions applyForJbcSrcStreaming(JbcSrcPluginContext context, Expression delegateAppendable, List<SoyExpression> args) {
        return SoyJbcSrcPrintDirective.Streamable.AppendableAndOptions.create(JbcSrcMethods.INSERT_WORD_BREAKS_STREAMING.invoke(delegateAppendable, BytecodeUtils.numericConversion(args.get(0).unboxAs(Long.TYPE), Type.INT_TYPE)));
    }

    @Override
    public JsExpr applyForJsSrc(JsExpr value, List<JsExpr> args) {
        return new JsExpr("soy.$$insertWordBreaks(" + value.getText() + ", " + args.get(0).getText() + ")", Integer.MAX_VALUE);
    }

    @Override
    public ImmutableSet<String> getRequiredJsLibNames() {
        return ImmutableSet.of((Object)"soy");
    }

    @Override
    public PyExpr applyForPySrc(PyExpr value, List<PyExpr> args) {
        return new PyExpr("runtime.unsupported('|insertWordBreaks')", Integer.MAX_VALUE);
    }

    private static final class JbcSrcMethods {
        static final MethodRef INSERT_WORD_BREAKS = MethodRef.create(BasicDirectivesRuntime.class, "insertWordBreaks", SoyValue.class, Integer.TYPE).asNonNullable();
        static final MethodRef INSERT_WORD_BREAKS_STREAMING = MethodRef.create(BasicDirectivesRuntime.class, "insertWordBreaksStreaming", LoggingAdvisingAppendable.class, Integer.TYPE);

        private JbcSrcMethods() {
        }
    }
}

