/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SoySyntaxException;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.Node;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.exprtree.GlobalNode;
import com.google.template.soy.exprtree.IntegerNode;
import com.google.template.soy.exprtree.StringNode;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateDelegateNodeBuilder;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.Visibility;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.List;
import java.util.Objects;

public final class TemplateDelegateNode
extends TemplateNode
implements SoyNode.ExprHolderNode {
    private final String delTemplateName;
    private String delTemplateVariant;
    private final ExprRootNode<?> delTemplateVariantExpr;
    private DelTemplateKey delTemplateKey;
    private final int delPriority;

    TemplateDelegateNode(TemplateDelegateNodeBuilder nodeBuilder, TemplateNode.SoyFileHeaderInfo soyFileHeaderInfo, String delTemplateName, String delTemplateVariant, ExprRootNode<?> delTemplateVariantExpr, DelTemplateKey delTemplateKey, int delPriority, ImmutableList<TemplateParam> params) {
        super(nodeBuilder, "deltemplate", soyFileHeaderInfo, Visibility.PUBLIC, params);
        this.delTemplateName = delTemplateName;
        this.delTemplateVariant = delTemplateVariant;
        this.delTemplateVariantExpr = delTemplateVariantExpr;
        this.delTemplateKey = delTemplateKey;
        this.delPriority = delPriority;
    }

    private TemplateDelegateNode(TemplateDelegateNode orig) {
        super(orig);
        this.delTemplateName = orig.delTemplateName;
        this.delTemplateVariant = orig.delTemplateVariant;
        this.delTemplateVariantExpr = orig.delTemplateVariantExpr;
        this.delTemplateKey = orig.delTemplateKey;
        this.delPriority = orig.delPriority;
    }

    static void verifyVariantName(String delTemplateVariant) {
        if (delTemplateVariant.length() > 0 && !BaseUtils.isIdentifier(delTemplateVariant)) {
            throw SoySyntaxException.createWithoutMetaInfo("Invalid variant \"" + delTemplateVariant + "\" in 'deltemplate'" + " (when a string literal is used, value must be an identifier).");
        }
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.TEMPLATE_DELEGATE_NODE;
    }

    public String getDelTemplateName() {
        return this.delTemplateName;
    }

    public String getDelTemplateVariant() {
        if (this.delTemplateVariant != null) {
            return this.delTemplateVariant;
        }
        return this.resolveVariantExpression().variant;
    }

    public DelTemplateKey getDelTemplateKey() {
        if (this.delTemplateKey != null) {
            return this.delTemplateKey;
        }
        return this.resolveVariantExpression();
    }

    public int getDelPriority() {
        return this.delPriority;
    }

    @Override
    public TemplateDelegateNode clone() {
        return new TemplateDelegateNode(this);
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        if (this.delTemplateVariantExpr == null) {
            return ImmutableList.of();
        }
        return ImmutableList.of((Object)new ExprUnion(this.delTemplateVariantExpr));
    }

    private DelTemplateKey resolveVariantExpression() {
        if (this.delTemplateVariantExpr == null || this.delTemplateVariantExpr.numChildren() != 1) {
            throw this.invalidExpressionError();
        }
        Node exprNode = this.delTemplateVariantExpr.getChild(0);
        if (exprNode instanceof IntegerNode) {
            int variantValue = ((IntegerNode)exprNode).getValue();
            Preconditions.checkArgument((variantValue >= 0 ? 1 : 0) != 0, (Object)"Globals used as deltemplate variants must not evaluate to negative numbers.");
            this.delTemplateVariant = String.valueOf(variantValue);
            this.delTemplateKey = new DelTemplateKey(this.delTemplateName, this.delTemplateVariant);
            return this.delTemplateKey;
        }
        if (exprNode instanceof StringNode) {
            this.delTemplateVariant = ((StringNode)exprNode).getValue();
            TemplateDelegateNode.verifyVariantName(this.delTemplateVariant);
            this.delTemplateKey = new DelTemplateKey(this.delTemplateName, this.delTemplateVariant);
            return this.delTemplateKey;
        }
        if (exprNode instanceof GlobalNode) {
            return new DelTemplateKey(this.delTemplateName, null, ((GlobalNode)exprNode).getName());
        }
        throw this.invalidExpressionError();
    }

    private AssertionError invalidExpressionError() {
        return new AssertionError((Object)("Invalid expression for deltemplate variant for " + this.delTemplateName + " template"));
    }

    public static final class DelTemplateKey {
        public final String name;
        public final String variant;
        public final String variantExpr;

        public DelTemplateKey(String name, String variant) {
            this(name, variant, null);
        }

        public DelTemplateKey(String name, String variant, String variantExpr) {
            this.name = name;
            this.variant = variant;
            this.variantExpr = variantExpr;
        }

        public boolean equals(Object other) {
            if (!(other instanceof DelTemplateKey)) {
                return false;
            }
            DelTemplateKey otherKey = (DelTemplateKey)other;
            return Objects.equals(this.name, otherKey.name) && Objects.equals(this.variant, otherKey.variant) && Objects.equals(this.variantExpr, otherKey.variantExpr);
        }

        public int hashCode() {
            return Objects.hash(this.name, this.variant, this.variantExpr);
        }

        public String toString() {
            return this.name + (this.variant == null || this.variant.length() == 0 ? "" : ":" + this.variant) + (this.variantExpr == null || this.variantExpr.length() == 0 ? "" : ":" + this.variantExpr);
        }
    }
}

