/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprparse.ExpressionParser;
import com.google.template.soy.exprtree.ExprNode;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.AbstractParentCommandNode;
import com.google.template.soy.soytree.CaseOrDefaultNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.MsgSubstUnitBaseVarNameUtils;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class MsgPluralNode
extends AbstractParentCommandNode<CaseOrDefaultNode>
implements SoyNode.MsgSubstUnitNode,
SoyNode.SplitLevelTopNode<CaseOrDefaultNode>,
SoyNode.ExprHolderNode {
    private static final SoyError INVALID_PLURAL_COMMAND_TEXT = SoyError.of("Invalid ''plural'' command text \"{0}\".");
    private static final SoyError PLURAL_OFFSET_OUT_OF_BOUNDS = SoyError.of("The ''offset'' for plural must be a nonnegative integer.");
    private static final SoyError MALFORMED_PLURAL_OFFSET = SoyError.of("Invalid offset in ''plural'' command text \"{0}\".");
    private static final Pattern COMMAND_TEXT_PATTERN = Pattern.compile("(.+?) ( \\s+ offset= .+ )?", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("plural", new CommandTextAttributesParser.Attribute("offset", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    public static final String FALLBACK_BASE_PLURAL_VAR_NAME = "NUM";
    private final int offset;
    private final ExprRootNode<?> pluralExpr;
    private final String basePluralVarName;

    private MsgPluralNode(int id, String commandText, int offset, ExprRootNode<?> pluralExpr, String basePluralVarName) {
        super(id, "plural", commandText);
        this.offset = offset;
        this.pluralExpr = pluralExpr;
        this.basePluralVarName = basePluralVarName;
    }

    private MsgPluralNode(MsgPluralNode orig) {
        super(orig);
        this.offset = orig.offset;
        this.pluralExpr = orig.pluralExpr.clone();
        this.basePluralVarName = orig.basePluralVarName;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.MSG_PLURAL_NODE;
    }

    public int getOffset() {
        return this.offset;
    }

    public String getExprText() {
        return this.pluralExpr.toSourceString();
    }

    public ExprRootNode<?> getExpr() {
        return this.pluralExpr;
    }

    @Override
    public String getBaseVarName() {
        return this.basePluralVarName;
    }

    @Override
    public boolean shouldUseSameVarNameAs(SoyNode.MsgSubstUnitNode other) {
        return other instanceof MsgPluralNode && this.getCommandText().equals(((MsgPluralNode)other).getCommandText());
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.pluralExpr));
    }

    @Override
    public SoyNode.MsgBlockNode getParent() {
        return (SoyNode.MsgBlockNode)super.getParent();
    }

    @Override
    public MsgPluralNode clone() {
        return new MsgPluralNode(this);
    }

    public static final class Builder {
        public static final MsgPluralNode ERROR = new Builder(-1, "plural", SourceLocation.UNKNOWN).buildAndThrowIfInvalid();
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public MsgPluralNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            Matcher matcher = COMMAND_TEXT_PATTERN.matcher(this.commandText);
            if (!matcher.matches()) {
                errorReporter.report(this.sourceLocation, INVALID_PLURAL_COMMAND_TEXT, this.commandText);
            }
            ExprRootNode<? extends ExprNode> pluralExpr = new ExpressionParser(matcher.group(1), this.sourceLocation, errorReporter).parseExpression();
            int offset = 0;
            if (matcher.group(2) != null) {
                try {
                    Map<String, String> attributes = ATTRIBUTES_PARSER.parse(matcher.group(2).trim());
                    String offsetAttribute = attributes.get("offset");
                    offset = Integer.parseInt(offsetAttribute);
                    if (offset < 0) {
                        errorReporter.report(this.sourceLocation, PLURAL_OFFSET_OUT_OF_BOUNDS, new String[0]);
                    }
                }
                catch (NumberFormatException nfe) {
                    errorReporter.report(this.sourceLocation, MALFORMED_PLURAL_OFFSET, this.commandText);
                }
            }
            String basePluralVarName = MsgSubstUnitBaseVarNameUtils.genNaiveBaseNameForExpr(pluralExpr, MsgPluralNode.FALLBACK_BASE_PLURAL_VAR_NAME);
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            MsgPluralNode node = new MsgPluralNode(this.id, this.commandText, offset, pluralExpr, basePluralVarName);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        private MsgPluralNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorReporter = new TransitionalThrowingErrorReporter();
            MsgPluralNode node = this.build(errorReporter);
            errorReporter.throwIfErrorsPresent();
            return node;
        }
    }
}

