/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.collect.ImmutableList;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.ExprUnion;
import com.google.template.soy.soytree.LetNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.List;

public final class LetValueNode
extends LetNode
implements SoyNode.ExprHolderNode {
    public static final SoyError SELF_ENDING_WITHOUT_VALUE = SoyError.of("A ''let'' tag should be self-ending (with a trailing ''/'') if and only if it also contains a value (invalid tag is '{'let {0} /'}').");
    private static final SoyError KIND_ATTRIBUTE_NOT_ALLOWED_WITH_VALUE = SoyError.of("The ''kind'' attribute is not allowed on self-ending ''let'' tags that contain a value (invalid tag is '{'let {0} /'}').");
    private final ExprRootNode<?> valueExpr;

    private LetValueNode(int id, String localVarName, String commandText, ExprRootNode<?> valueExpr) {
        super(id, localVarName, commandText);
        this.valueExpr = valueExpr;
    }

    private LetValueNode(LetValueNode orig) {
        super(orig);
        this.valueExpr = orig.valueExpr.clone();
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.LET_VALUE_NODE;
    }

    @Override
    public final String getVarName() {
        return this.var.name();
    }

    public ExprRootNode<?> getValueExpr() {
        return this.valueExpr;
    }

    @Override
    public List<ExprUnion> getAllExprUnions() {
        return ImmutableList.of((Object)new ExprUnion(this.valueExpr));
    }

    @Override
    public LetValueNode clone() {
        return new LetValueNode(this);
    }

    public static final class Builder {
        public static final LetValueNode ERROR = new Builder(-1, "$error: 1", SourceLocation.UNKNOWN).buildAndThrowIfInvalid();
        private final int id;
        private final String commandText;
        private final SourceLocation sourceLocation;

        public Builder(int id, String commandText, SourceLocation sourceLocation) {
            this.id = id;
            this.commandText = commandText;
            this.sourceLocation = sourceLocation;
        }

        public LetValueNode build(ErrorReporter errorReporter) {
            ErrorReporter.Checkpoint checkpoint = errorReporter.checkpoint();
            LetNode.CommandTextParseResult parseResult = LetNode.parseCommandTextHelper(this.commandText, errorReporter, this.sourceLocation);
            if (parseResult.valueExpr == null) {
                errorReporter.report(this.sourceLocation, SELF_ENDING_WITHOUT_VALUE, this.commandText);
            }
            if (parseResult.contentKind != null) {
                errorReporter.report(this.sourceLocation, KIND_ATTRIBUTE_NOT_ALLOWED_WITH_VALUE, this.commandText);
            }
            if (errorReporter.errorsSince(checkpoint)) {
                return ERROR;
            }
            LetValueNode node = new LetValueNode(this.id, parseResult.localVarName, this.commandText, parseResult.valueExpr);
            node.setSourceLocation(this.sourceLocation);
            return node;
        }

        private LetValueNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorReporter = new TransitionalThrowingErrorReporter();
            LetValueNode node = this.build(errorReporter);
            errorReporter.throwIfErrorsPresent();
            return node;
        }
    }
}

