/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.soytree;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.template.soy.base.SourceLocation;
import com.google.template.soy.base.internal.BaseUtils;
import com.google.template.soy.basetree.SyntaxVersion;
import com.google.template.soy.basetree.SyntaxVersionBound;
import com.google.template.soy.exprtree.ExprRootNode;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.soyparse.ErrorReporter;
import com.google.template.soy.soyparse.SoyError;
import com.google.template.soy.soyparse.TransitionalThrowingErrorReporter;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.CommandTextAttributesParser;
import com.google.template.soy.soytree.SoyNode;
import com.google.template.soy.soytree.TemplateNode;
import com.google.template.soy.soytree.defn.TemplateParam;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;

public final class CallBasicNode
extends CallNode {
    public static final SoyError MISSING_CALLEE_NAME = SoyError.of("Invalid ''call'' command missing callee name: '{'call {0}'}'.");
    private static final SoyError BAD_CALLEE_NAME = SoyError.of("Invalid callee name \"{0}\" for ''call'' command.");
    private static final SoyError MULTIPLE_CALLEE_NAMES = SoyError.of("call: multiple callee names: `{0}`, `{1}`");
    private static final Pattern NONATTRIBUTE_CALLEE_NAME = Pattern.compile("^ (?! name=\" | function=\") [.\\w]+ (?= \\s | $)", 4);
    private static final CommandTextAttributesParser ATTRIBUTES_PARSER = new CommandTextAttributesParser("call", new CommandTextAttributesParser.Attribute("name", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("function", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null), new CommandTextAttributesParser.Attribute("data", CommandTextAttributesParser.Attribute.ALLOW_ALL_VALUES, null));
    private final String sourceCalleeName;
    private String calleeName;
    private ImmutableList<TemplateParam> paramsToRuntimeTypeCheck;

    private CallBasicNode(int id, CommandTextInfo commandTextInfo, ImmutableList<String> escapingDirectiveNames, @Nullable String calleeName) {
        super(id, "call", commandTextInfo, escapingDirectiveNames);
        this.sourceCalleeName = commandTextInfo.srcCalleeName;
        this.calleeName = calleeName;
    }

    private CallBasicNode(CallBasicNode orig) {
        super(orig);
        this.sourceCalleeName = orig.sourceCalleeName;
        this.calleeName = orig.calleeName;
        this.paramsToRuntimeTypeCheck = orig.paramsToRuntimeTypeCheck;
    }

    @Override
    public SoyNode.Kind getKind() {
        return SoyNode.Kind.CALL_BASIC_NODE;
    }

    public String getSrcCalleeName() {
        return this.sourceCalleeName;
    }

    public void setCalleeName(String calleeName) {
        Preconditions.checkState((this.calleeName == null ? 1 : 0) != 0);
        Preconditions.checkArgument((boolean)BaseUtils.isDottedIdentifier(calleeName));
        this.calleeName = calleeName;
    }

    public void setParamsToRuntimeCheck(Collection<TemplateParam> paramNames) {
        this.paramsToRuntimeTypeCheck = ImmutableList.copyOf(paramNames);
    }

    @Override
    public Collection<TemplateParam> getParamsToRuntimeCheck(TemplateNode callee) {
        return this.paramsToRuntimeTypeCheck == null ? callee.getParams() : this.paramsToRuntimeTypeCheck;
    }

    public String getCalleeName() {
        return this.calleeName;
    }

    @Override
    public CallBasicNode clone() {
        return new CallBasicNode(this);
    }

    public static final class Builder {
        public static final CallBasicNode ERROR = new Builder(-1, SourceLocation.UNKNOWN).commandText(".error").buildAndThrowIfInvalid();
        private final int id;
        private final SourceLocation sourceLocation;
        private ImmutableList<String> escapingDirectiveNames = ImmutableList.of();
        private boolean isPassingData;
        private boolean isPassingAllData;
        private boolean useV1FunctionAttrForCalleeName;
        @Nullable
        private String commandText;
        @Nullable
        private ExprRootNode<?> dataExpr;
        @Nullable
        private String userSuppliedPlaceholderName;
        @Nullable
        private String calleeName;
        @Nullable
        private String sourceCalleeName;
        @Nullable
        private SyntaxVersionBound syntaxVersionBound;

        public Builder(int id, SourceLocation sourceLocation) {
            this.id = id;
            this.sourceLocation = sourceLocation;
        }

        public Builder calleeName(String calleeName) {
            this.calleeName = calleeName;
            return this;
        }

        public Builder commandText(String commandText) {
            this.commandText = commandText;
            return this;
        }

        public Builder dataExpr(ExprRootNode<?> dataExpr) {
            this.dataExpr = dataExpr;
            return this;
        }

        public Builder escapingDirectiveNames(ImmutableList<String> escapingDirectiveNames) {
            this.escapingDirectiveNames = escapingDirectiveNames;
            return this;
        }

        public Builder isPassingData(boolean isPassingData) {
            this.isPassingData = isPassingData;
            return this;
        }

        public Builder isPassingAllData(boolean isPassingAllData) {
            this.isPassingAllData = isPassingAllData;
            return this;
        }

        public Builder sourceCalleeName(String sourceCalleeName) {
            this.sourceCalleeName = sourceCalleeName;
            return this;
        }

        public Builder syntaxVersionBound(SyntaxVersionBound syntaxVersionBound) {
            this.syntaxVersionBound = syntaxVersionBound;
            return this;
        }

        public Builder userSuppliedPlaceholderName(String userSuppliedPlaceholderName) {
            this.userSuppliedPlaceholderName = userSuppliedPlaceholderName;
            return this;
        }

        public Builder useV1FunctionAttrForCalleeName(boolean useV1FunctionAttrForCalleeName) {
            this.useV1FunctionAttrForCalleeName = useV1FunctionAttrForCalleeName;
            return this;
        }

        public CallBasicNode buildAndThrowIfInvalid() {
            TransitionalThrowingErrorReporter errorManager = new TransitionalThrowingErrorReporter();
            CallBasicNode node = this.build(errorManager);
            errorManager.throwIfErrorsPresent();
            return node;
        }

        public CallBasicNode build(ErrorReporter errorReporter) {
            CommandTextInfo commandTextInfo;
            ErrorReporter.Checkpoint c = errorReporter.checkpoint();
            CommandTextInfo commandTextInfo2 = commandTextInfo = this.commandText != null ? this.parseCommandText(errorReporter) : this.buildCommandText();
            if (errorReporter.errorsSince(c)) {
                return ERROR;
            }
            CallBasicNode callBasicNode = new CallBasicNode(this.id, commandTextInfo, this.escapingDirectiveNames, this.calleeName);
            callBasicNode.setSourceLocation(this.sourceLocation);
            return callBasicNode;
        }

        private CommandTextInfo parseCommandText(ErrorReporter errorReporter) {
            String functionAttr;
            Map<String, String> attributes;
            String nameAttr;
            String cmdText = this.commandText + (this.userSuppliedPlaceholderName != null ? " phname=\"" + this.userSuppliedPlaceholderName + "\"" : "");
            String cmdTextForParsing = this.commandText;
            SyntaxVersionBound syntaxVersionBound = null;
            ArrayList srcCalleeNames = Lists.newArrayList();
            Matcher ncnMatcher = NONATTRIBUTE_CALLEE_NAME.matcher(cmdTextForParsing);
            if (ncnMatcher.find()) {
                srcCalleeNames.add(ncnMatcher.group());
                cmdTextForParsing = cmdTextForParsing.substring(ncnMatcher.end()).trim();
            }
            if ((nameAttr = (attributes = ATTRIBUTES_PARSER.parse(cmdTextForParsing, errorReporter, this.sourceLocation)).get("name")) != null) {
                srcCalleeNames.add(nameAttr);
                SyntaxVersionBound newSyntaxVersionBound = new SyntaxVersionBound(SyntaxVersion.V2_2, String.format("Callee name should be written directly instead of within attribute 'name' (i.e. use {call %s} instead of {call name=\"%s\"}.", nameAttr, nameAttr));
                syntaxVersionBound = SyntaxVersionBound.selectLower(syntaxVersionBound, newSyntaxVersionBound);
            }
            if ((functionAttr = attributes.get("function")) != null) {
                srcCalleeNames.add(functionAttr);
                SyntaxVersionBound newSyntaxVersionBound = new SyntaxVersionBound(SyntaxVersion.V2_0, "The 'function' attribute in a 'call' tag is a Soy V1 artifact.");
                syntaxVersionBound = SyntaxVersionBound.selectLower(syntaxVersionBound, newSyntaxVersionBound);
            }
            if (srcCalleeNames.isEmpty()) {
                errorReporter.report(this.sourceLocation, MISSING_CALLEE_NAME, this.commandText);
            } else if (srcCalleeNames.size() == 1) {
                this.sourceCalleeName = (String)srcCalleeNames.get(0);
                if (!BaseUtils.isIdentifierWithLeadingDot(this.sourceCalleeName) && !BaseUtils.isDottedIdentifier(this.sourceCalleeName)) {
                    errorReporter.report(this.sourceLocation, BAD_CALLEE_NAME, this.sourceCalleeName);
                }
            } else {
                errorReporter.report(this.sourceLocation, MULTIPLE_CALLEE_NAMES, (String)srcCalleeNames.get(0), (String)srcCalleeNames.get(1));
            }
            Pair<Boolean, ExprRootNode<?>> dataAttrInfo = CallNode.parseDataAttributeHelper(attributes.get("data"), errorReporter);
            return new CommandTextInfo(cmdText, this.sourceCalleeName, (Boolean)dataAttrInfo.first, (ExprRootNode)dataAttrInfo.second, this.userSuppliedPlaceholderName, syntaxVersionBound);
        }

        private CommandTextInfo buildCommandText() {
            if (this.isPassingAllData) {
                Preconditions.checkArgument((boolean)this.isPassingData);
            }
            if (this.dataExpr != null) {
                Preconditions.checkArgument((this.isPassingData && !this.isPassingAllData ? 1 : 0) != 0);
            }
            String commandText = "";
            if (this.useV1FunctionAttrForCalleeName) {
                Preconditions.checkArgument((this.syntaxVersionBound != null && this.syntaxVersionBound.syntaxVersion == SyntaxVersion.V2_0 ? 1 : 0) != 0);
                commandText = commandText + "function=\"" + this.sourceCalleeName + '\"';
            } else {
                commandText = commandText + this.sourceCalleeName;
            }
            if (this.isPassingAllData) {
                commandText = commandText + " data=\"all\"";
            } else if (this.isPassingData) {
                assert (this.dataExpr != null);
                commandText = commandText + " data=\"" + this.dataExpr.toSourceString() + '\"';
            }
            if (this.userSuppliedPlaceholderName != null) {
                commandText = commandText + " phname=\"" + this.userSuppliedPlaceholderName + '\"';
            }
            return new CommandTextInfo(commandText, this.sourceCalleeName, this.isPassingData, this.dataExpr, this.userSuppliedPlaceholderName, this.syntaxVersionBound);
        }
    }

    @Immutable
    private static final class CommandTextInfo
    extends CallNode.CommandTextInfo {
        private final String srcCalleeName;

        CommandTextInfo(String commandText, String srcCalleeName, boolean isPassingData, @Nullable ExprRootNode<?> dataExpr, @Nullable String userSuppliedPlaceholderName, @Nullable SyntaxVersionBound syntaxVersionBound) {
            super(commandText, isPassingData, dataExpr, userSuppliedPlaceholderName, syntaxVersionBound);
            this.srcCalleeName = srcCalleeName;
        }
    }
}

