/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.shared.internal;

import com.google.template.soy.data.SanitizedContent;
import com.google.template.soy.data.SoyValue;
import com.google.template.soy.data.restricted.FloatData;
import com.google.template.soy.data.restricted.IntegerData;
import com.google.template.soy.data.restricted.NumberData;
import com.google.template.soy.data.restricted.StringData;

public final class SharedRuntime {
    public static boolean equal(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof StringData) {
            return SharedRuntime.compareString((StringData)operand0, operand1);
        }
        if (operand1 instanceof StringData) {
            return SharedRuntime.compareString((StringData)operand1, operand0);
        }
        return operand0.equals(operand1);
    }

    public static SoyValue plus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() + operand1.longValue());
        }
        if (operand0 instanceof StringData || operand1 instanceof StringData) {
            return StringData.forValue(operand0.toString() + operand1);
        }
        return FloatData.forValue(operand0.numberValue() + operand1.numberValue());
    }

    public static SoyValue minus(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() - operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() - operand1.numberValue());
    }

    public static NumberData times(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return IntegerData.forValue(operand0.longValue() * operand1.longValue());
        }
        return FloatData.forValue(operand0.numberValue() * operand1.numberValue());
    }

    public static double dividedBy(SoyValue operand0, SoyValue operand1) {
        return operand0.numberValue() / operand1.numberValue();
    }

    public static boolean lessThan(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return operand0.longValue() < operand1.longValue();
        }
        return operand0.numberValue() < operand1.numberValue();
    }

    public static boolean lessThanOrEqual(SoyValue operand0, SoyValue operand1) {
        if (operand0 instanceof IntegerData && operand1 instanceof IntegerData) {
            return operand0.longValue() <= operand1.longValue();
        }
        return operand0.numberValue() <= operand1.numberValue();
    }

    public static NumberData negative(SoyValue node) {
        if (node instanceof IntegerData) {
            return IntegerData.forValue(-node.longValue());
        }
        return FloatData.forValue(-node.floatValue());
    }

    private static boolean compareString(StringData stringData, SoyValue other) {
        if (other instanceof StringData || other instanceof SanitizedContent) {
            return stringData.stringValue().equals(other.toString());
        }
        if (other instanceof NumberData) {
            try {
                return Double.parseDouble(stringData.stringValue()) == other.numberValue();
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        return false;
    }

    private SharedRuntime() {
    }
}

