/*
 * Decompiled with CFR 0.152.
 */
package com.google.template.soy.pysrc.internal;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import com.google.template.soy.internal.base.Pair;
import com.google.template.soy.msgs.internal.IcuSyntaxUtils;
import com.google.template.soy.msgs.internal.MsgUtils;
import com.google.template.soy.msgs.restricted.SoyMsgPart;
import com.google.template.soy.msgs.restricted.SoyMsgPlaceholderPart;
import com.google.template.soy.msgs.restricted.SoyMsgPluralPart;
import com.google.template.soy.msgs.restricted.SoyMsgRawTextPart;
import com.google.template.soy.pysrc.internal.GenPyExprsVisitor;
import com.google.template.soy.pysrc.internal.LocalVariableStack;
import com.google.template.soy.pysrc.internal.TranslateToPyExprVisitor;
import com.google.template.soy.pysrc.restricted.PyExpr;
import com.google.template.soy.pysrc.restricted.PyExprUtils;
import com.google.template.soy.pysrc.restricted.PyFunctionExprBuilder;
import com.google.template.soy.pysrc.restricted.PyStringExpr;
import com.google.template.soy.soytree.AbstractParentSoyNode;
import com.google.template.soy.soytree.CallNode;
import com.google.template.soy.soytree.MsgHtmlTagNode;
import com.google.template.soy.soytree.MsgNode;
import com.google.template.soy.soytree.MsgPlaceholderNode;
import com.google.template.soy.soytree.MsgPluralNode;
import com.google.template.soy.soytree.MsgSelectNode;
import com.google.template.soy.soytree.PrintNode;
import com.google.template.soy.soytree.SoyNode;
import java.util.LinkedHashMap;
import java.util.Map;

final class MsgFuncGenerator {
    static final String TRANSLATOR_NAME = "translator_impl";
    private final MsgNode msgNode;
    private final long msgId;
    private final ImmutableList<SoyMsgPart> msgParts;
    private final GenPyExprsVisitor genPyExprsVisitor;
    private final PyFunctionExprBuilder prepareFunc;
    private final PyFunctionExprBuilder renderFunc;
    private final TranslateToPyExprVisitor translateToPyExprVisitor;

    @AssistedInject
    MsgFuncGenerator(GenPyExprsVisitor.GenPyExprsVisitorFactory genPyExprsVisitorFactory, TranslateToPyExprVisitor.TranslateToPyExprVisitorFactory translateToPyExprVisitorFactory, @Assisted MsgNode msgNode, @Assisted LocalVariableStack localVarExprs) {
        this.msgNode = msgNode;
        this.genPyExprsVisitor = genPyExprsVisitorFactory.create(localVarExprs);
        this.translateToPyExprVisitor = translateToPyExprVisitorFactory.create(localVarExprs);
        if (this.msgNode.isPlrselMsg()) {
            if (this.msgNode.isPluralMsg()) {
                this.prepareFunc = new PyFunctionExprBuilder("translator_impl.prepare_plural");
                this.renderFunc = new PyFunctionExprBuilder("translator_impl.render_plural");
            } else {
                this.prepareFunc = new PyFunctionExprBuilder("translator_impl.prepare_icu");
                this.renderFunc = new PyFunctionExprBuilder("translator_impl.render_icu");
            }
        } else if (this.msgNode.isRawTextMsg()) {
            this.prepareFunc = new PyFunctionExprBuilder("translator_impl.prepare_literal");
            this.renderFunc = new PyFunctionExprBuilder("translator_impl.render_literal");
        } else {
            this.prepareFunc = new PyFunctionExprBuilder("translator_impl.prepare");
            this.renderFunc = new PyFunctionExprBuilder("translator_impl.render");
        }
        MsgUtils.MsgPartsAndIds msgPartsAndIds = MsgUtils.buildMsgPartsAndComputeMsgIdForDualFormat(msgNode);
        Preconditions.checkNotNull((Object)msgPartsAndIds);
        this.msgId = msgPartsAndIds.id;
        this.msgParts = msgPartsAndIds.parts;
        Preconditions.checkState((!this.msgParts.isEmpty() ? 1 : 0) != 0);
    }

    PyStringExpr getPyExpr() {
        this.addMsgAttributesToPrepare();
        if (this.msgNode.isPlrselMsg()) {
            return this.msgNode.isPluralMsg() ? this.pyFuncForPluralMsg() : this.pyFuncForSelectMsg();
        }
        return this.msgNode.isRawTextMsg() ? this.pyFuncForRawTextMsg() : this.pyFuncForGeneralMsg();
    }

    private PyStringExpr pyFuncForRawTextMsg() {
        SoyMsgRawTextPart rawTextPart = (SoyMsgRawTextPart)this.msgParts.get(0);
        this.prepareFunc.addArg(this.msgId).addArg(rawTextPart.getRawText());
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).asPyStringExpr();
    }

    private PyStringExpr pyFuncForGeneralMsg() {
        String pyMsgText = MsgFuncGenerator.processMsgPartsHelper(this.msgParts);
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        this.prepareFunc.addArg(this.msgId).addArg(pyMsgText).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private PyStringExpr pyFuncForPluralMsg() {
        SoyMsgPluralPart pluralPart = (SoyMsgPluralPart)this.msgParts.get(0);
        MsgPluralNode pluralNode = this.msgNode.getRepPluralNode(pluralPart.getPluralVarName());
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        LinkedHashMap<PyExpr, PyExpr> caseSpecStrToMsgTexts = new LinkedHashMap<PyExpr, PyExpr>();
        for (Pair pluralCase : pluralPart.getCases()) {
            caseSpecStrToMsgTexts.put(new PyStringExpr("'" + pluralCase.first + "'"), new PyStringExpr("'" + MsgFuncGenerator.processMsgPartsHelper((ImmutableList<SoyMsgPart>)((ImmutableList)pluralCase.second)) + "'"));
        }
        this.prepareFunc.addArg(this.msgId).addArg(PyExprUtils.convertMapToPyExpr(caseSpecStrToMsgTexts)).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        PyExpr pluralPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(pluralNode.getExpr());
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(pluralPyExpr).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private PyStringExpr pyFuncForSelectMsg() {
        Map<PyExpr, PyExpr> nodePyVarToPyExprMap = this.collectVarNameListAndToPyExprMap();
        ImmutableList<SoyMsgPart> msgPartsInIcuSyntax = IcuSyntaxUtils.convertMsgPartsToEmbeddedIcuSyntax(this.msgParts, true);
        String pyMsgText = MsgFuncGenerator.processMsgPartsHelper(msgPartsInIcuSyntax);
        this.prepareFunc.addArg(this.msgId).addArg(pyMsgText).addArg(PyExprUtils.convertIterableToPyTupleExpr(nodePyVarToPyExprMap.keySet()));
        return this.renderFunc.addArg(this.prepareFunc.asPyExpr()).addArg(PyExprUtils.convertMapToPyExpr(nodePyVarToPyExprMap)).asPyStringExpr();
    }

    private void addMsgAttributesToPrepare() {
        if (this.msgNode.getMeaning() != null) {
            this.prepareFunc.addKwarg("meaning", this.msgNode.getMeaning());
        }
    }

    private Map<PyExpr, PyExpr> collectVarNameListAndToPyExprMap() {
        LinkedHashMap<PyExpr, PyExpr> nodePyVarToPyExprMap = new LinkedHashMap<PyExpr, PyExpr>();
        for (Map.Entry entry : this.msgNode.getVarNameToRepNodeMap().entrySet()) {
            String phName = (String)entry.getKey();
            SoyNode.MsgSubstUnitNode substUnitNode = (SoyNode.MsgSubstUnitNode)entry.getValue();
            PyExpr substPyExpr = null;
            if (substUnitNode instanceof MsgPlaceholderNode) {
                SoyNode.MsgPlaceholderInitialNode phInitialNode = (SoyNode.MsgPlaceholderInitialNode)((AbstractParentSoyNode)((Object)substUnitNode)).getChild(0);
                if (phInitialNode instanceof PrintNode || phInitialNode instanceof CallNode) {
                    substPyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitor.exec(phInitialNode)).toPyString();
                }
                if (phInitialNode instanceof MsgHtmlTagNode) {
                    substPyExpr = PyExprUtils.concatPyExprs(this.genPyExprsVisitor.execOnChildren((SoyNode.ParentSoyNode)((Object)phInitialNode))).toPyString();
                }
            }
            if (substPyExpr != null) {
                nodePyVarToPyExprMap.put(new PyStringExpr("'" + phName + "'"), substPyExpr.toPyString());
            }
            if (substUnitNode instanceof MsgPluralNode) {
                substPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(((MsgPluralNode)substUnitNode).getExpr());
            }
            if (substUnitNode instanceof MsgSelectNode) {
                substPyExpr = (PyExpr)this.translateToPyExprVisitor.exec(((MsgSelectNode)substUnitNode).getExpr());
            }
            if (substPyExpr == null) continue;
            nodePyVarToPyExprMap.put(new PyStringExpr("'" + phName + "'"), substPyExpr);
        }
        return nodePyVarToPyExprMap;
    }

    private static String processMsgPartsHelper(ImmutableList<SoyMsgPart> parts) {
        StringBuilder rawMsgTextSb = new StringBuilder();
        for (SoyMsgPart part : parts) {
            if (part instanceof SoyMsgRawTextPart) {
                rawMsgTextSb.append(((SoyMsgRawTextPart)part).getRawText());
            }
            if (!(part instanceof SoyMsgPlaceholderPart)) continue;
            String phName = ((SoyMsgPlaceholderPart)part).getPlaceholderName();
            rawMsgTextSb.append("{" + phName + "}");
        }
        return rawMsgTextSb.toString();
    }

    static interface MsgFuncGeneratorFactory {
        public MsgFuncGenerator create(MsgNode var1, LocalVariableStack var2);
    }
}

